/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.main;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Optional;
import java.util.UUID;
import javax.json.spi.JsonProvider;
import ucd.pacc.http.DeployProcessApiFactory;
import ucd.pacc.http.HttpClientFactory;
import ucd.pacc.main.AbstractCommand;
import ucd.pacc.main.BadArgumentException;
import ucd.pacc.main.ConsoleWrapper;
import ucd.pacc.main.GlobalProcessState;
import ucd.pacc.parser.ParseException;
import ucd.pacc.upload.TranslatorFactory;
import ucd.pacc.util.IOFactory;
import ucd.pacc.util.Util;

abstract class AbstractProcessCommand
extends AbstractCommand {
    private final HttpClientFactory httpClientFactory;
    private final DeployProcessApiFactory deployProcessApiFactory;
    private final JsonProvider jsonProvider;
    private final TranslatorFactory translatorFactory;
    private Optional<String> password;

    AbstractProcessCommand(GlobalProcessState globalProcessState, IOFactory ioFactory, HttpClientFactory httpClientFactory, DeployProcessApiFactory deployProcessApiFactory, JsonProvider jsonProvider, TranslatorFactory translatorFactory) {
        super(globalProcessState, ioFactory);
        this.httpClientFactory = httpClientFactory;
        this.httpClientFactory.getClass();
        this.deployProcessApiFactory = deployProcessApiFactory;
        this.deployProcessApiFactory.getClass();
        this.jsonProvider = jsonProvider;
        this.jsonProvider.getClass();
        this.translatorFactory = translatorFactory;
        this.translatorFactory.getClass();
        this.password = Optional.empty();
    }

    @Override
    protected void doCommand() throws ParseException, IOException, GeneralSecurityException {
        this.doProcessCommand();
    }

    protected abstract void doProcessCommand() throws ParseException, IOException, GeneralSecurityException;

    protected void readPassword() throws IOException {
        this.password = Optional.of(new String(this.mustGetConsole().readPassword("password: ", new Object[0])));
    }

    protected Optional<String> getPassword() {
        return this.password;
    }

    protected HttpClientFactory getHttpClientFactory() {
        return this.httpClientFactory;
    }

    protected DeployProcessApiFactory getDeployProcessApiFactory() {
        return this.deployProcessApiFactory;
    }

    protected JsonProvider getJsonProvider() {
        return this.jsonProvider;
    }

    protected TranslatorFactory getTranslatorFactory() {
        return this.translatorFactory;
    }

    protected UUID parseProcessId(String s) throws BadArgumentException {
        try {
            return UUID.fromString(s);
        }
        catch (IllegalArgumentException e) {
            throw new BadArgumentException("process ID: " + Util.quote(s), e);
        }
    }

    protected int parseProcessVersion(String s) throws BadArgumentException {
        if ("latest".equals(s)) {
            return -1;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            throw new BadArgumentException("version: " + Util.quote(s), e);
        }
    }

    protected ConsoleWrapper mustGetConsole() throws IOException {
        return this.getGlobalProcessState().getConsole().orElseThrow(() -> new IOException("direct console access unavailable"));
    }
}

