/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.model;

import java.util.Arrays;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import ucd.pacc.util.ErrorHandler;

public class GenericProcessProperty {
    PropertyName name;
    String value;
    String description;
    boolean secure;

    public PropertyName getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setName(String name) {
        this.name = GenericProcessProperty.convertToEnum(name);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setSecure(boolean bool) {
        this.secure = bool;
    }

    public static PropertyName convertToEnum(String input) {
        String normalizedInput = input.replaceAll("(?<=[a-zA-Z])(?=[A-Z])", "_").toUpperCase();
        return Arrays.stream(PropertyName.values()).filter(e -> e.name().equals(normalizedInput)).findFirst().orElseThrow(() -> new IllegalArgumentException("Invalid Generic type: " + normalizedInput + ", accepted values are 'workingDir' & 'defaultResourceId'"));
    }

    public JSONObject toJson() {
        JSONObject json = new JSONObject();
        try {
            if (this.name == PropertyName.WORKING_DIR) {
                json.put("name", (Object)"workingDir");
            } else {
                json.put("name", (Object)"defaultResourceId");
            }
            json.put("value", (Object)this.value);
        }
        catch (JSONException e) {
            ErrorHandler.printErrorAndExit("Unable to build generic process configurations' properties");
        }
        return json;
    }

    public static enum PropertyName {
        WORKING_DIR,
        DEFAULT_RESOURCE_ID;

    }
}

