/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.parser.analysis;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import ucd.pacc.model.Step;
import ucd.pacc.model.StepName;
import ucd.pacc.parser.NonUniqueStepAnchorException;
import ucd.pacc.parser.ParseException;
import ucd.pacc.util.StepGraphProcessor;

public class CheckStepAnchorUniquenessProcessor
extends StepGraphProcessor<CheckStepAnchorUniquenessProcessor> {
    private final Set<StepName> anchors = new HashSet<StepName>();

    @Override
    protected CheckStepAnchorUniquenessProcessor createNestedInstance() {
        return new CheckStepAnchorUniquenessProcessor();
    }

    @Override
    protected void processStep(Step step) throws ParseException {
        this.checkName(step);
    }

    protected void checkName(Step step) throws ParseException {
        StepName anchor = step.getAnchor();
        if (!this.anchors.add(anchor)) {
            throw new NonUniqueStepAnchorException(Optional.of(step.getPosition()), String.format("non-unique step anchor: step=%s anchor=%s", step.getName().quote(), anchor.quote()));
        }
    }
}

