/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.parser.json;

import java.util.Optional;
import java.util.stream.Stream;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import ucd.pacc.model.Concurrency;
import ucd.pacc.model.ForEachAgentStep;
import ucd.pacc.model.ParseSourcePosition;
import ucd.pacc.model.ResourceTagName;
import ucd.pacc.model.StepGraph;
import ucd.pacc.parser.json.GraphExtractor;
import ucd.pacc.parser.json.StepExtractor;
import ucd.pacc.util.JsonUtil;

class StepExtractorForEachAgent
extends StepExtractor<ForEachAgentStep> {
    StepExtractorForEachAgent(ParseSourcePosition position, JsonObject object, JsonUtil jsonUtil) {
        super(position, object, "for each resource tag step", jsonUtil);
    }

    @Override
    public ForEachAgentStep extract() {
        ForEachAgentStep step = new ForEachAgentStep(this.position, this.getStepName());
        step.setGraph(this.getGraph());
        this.getMaxConcurrentAgents().ifPresent(step::setMaxConcurrentAgents);
        this.findTags().forEach(step::addTag);
        this.findTagsForNewAPI().forEach(step::addTag);
        return step;
    }

    private StepGraph getGraph() {
        return new GraphExtractor(this.findGraph(), this.position, this.jsonUtil).extract();
    }

    private Optional<Concurrency> getMaxConcurrentAgents() {
        return this.findString(new StepExtractor.JsonKey("maxIteration"), BASE).map(this.createParser(Concurrency::createFromJsonString));
    }

    private JsonObject findGraph() {
        return this.mustFindJsonObjectNode(new StepExtractor.JsonPath("$.children[?(@.type == 'graph')]"));
    }

    private Stream<ResourceTagName> findTags() {
        JsonValue tagIds = (JsonValue)this.object.get((Object)"tagIds");
        Stream<JsonValue> ids = tagIds != null && tagIds.getValueType() == JsonValue.ValueType.ARRAY ? ((JsonArray)tagIds).stream().peek(id -> this.checkIsJsonString("tagIds", (JsonValue)id)) : ((JsonArray)this.jsonUtil.find((JsonStructure)this.object, "$.tags[*].id")).stream().peek(id -> this.checkIsJsonString("id", (JsonValue)id));
        return ids.map(JsonString.class::cast).map(JsonString::getString).map(this.createParser(ResourceTagName::new));
    }

    private Stream<ResourceTagName> findTagsForNewAPI() {
        return ((JsonArray)this.jsonUtil.find((JsonStructure)this.object, "$.tags[*].name")).stream().peek(name -> this.checkIsJsonString("name", (JsonValue)name)).map(JsonString.class::cast).map(JsonString::getString).map(ResourceTagName::new);
    }
}

