/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.util.List;
import java.util.Optional;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import ucd.pacc.util.ErrorHandler;

public class JsonDataFinder {
    private static ObjectMapper mapper = new ObjectMapper();

    public static Optional<Object> findDataInJson(String json, String dataPathInJson) {
        Object data = null;
        try {
            Object jsonPath = JsonPath.read((String)json, (String)dataPathInJson, (Predicate[])new Predicate[0]);
            data = JsonDataFinder.ifListReturnJSONArray(jsonPath);
            return Optional.of(data);
        }
        catch (PathNotFoundException p) {
            return Optional.empty();
        }
        catch (JSONException e) {
            ErrorHandler.printErrorAndExit(" Unable to construct JSONArray for " + dataPathInJson + " in json " + json);
        }
        catch (JsonProcessingException e) {
            ErrorHandler.printErrorAndExit("[ERROR] Unable to convert JsonArray/List structure into String for " + dataPathInJson + " in " + json);
        }
        return Optional.empty();
    }

    private static Object ifListReturnJSONArray(Object o) throws JsonProcessingException, JSONException {
        if (o instanceof List) {
            String data = mapper.writeValueAsString(o);
            return new JSONArray(data);
        }
        return o;
    }

    public static JSONObject getJsonFromJsonArray(JSONArray json, int index) {
        try {
            return (JSONObject)json.get(index);
        }
        catch (JSONException e) {
            ErrorHandler.printErrorAndExit(" Unable to retrieve the index " + index + " from json " + json);
            return null;
        }
    }

    public static String getStringFromJson(JSONObject json, String data) {
        try {
            return (String)json.get(data);
        }
        catch (JSONException e) {
            ErrorHandler.printErrorAndExit(" Unable to get data :" + data + " from " + json);
            return null;
        }
    }
}

