/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.util.processconfiguration;

import java.util.Optional;
import java.util.function.Predicate;
import org.codehaus.jettison.json.JSONArray;
import ucd.pacc.model.ComponentProcessConfigurations;
import ucd.pacc.model.ProcessConfigurations;
import ucd.pacc.util.JsonDataFinder;
import ucd.pacc.util.processconfiguration.ProcessConfigurationBuilder;

public class ComponentProcessConfigurationBuilder
extends ProcessConfigurationBuilder {
    @Override
    ProcessConfigurations build() {
        ComponentProcessConfigurations processConfigurations = new ComponentProcessConfigurations();
        this.getDefaultWorkingDirFromJson().ifPresent(processConfigurations::setDefaultWorkingDir);
        this.getTakesVersionFromJson().ifPresent(processConfigurations::setTakesVersion);
        this.getStatusFromJson().ifPresent(processConfigurations::setStatus);
        this.getInventoryActionTypeFromJson().ifPresent(processConfigurations::setInventoryActionType);
        if (processConfigurations.getInventoryActionType() == ComponentProcessConfigurations.InventoryActionType.ADD) {
            processConfigurations.setConfigActionType(ComponentProcessConfigurations.ConfigActionType.ADD);
        } else if (processConfigurations.getInventoryActionType() != ComponentProcessConfigurations.InventoryActionType.REMOVE) {
            this.getConfigActionTypeFromJson().ifPresent(processConfigurations::setConfigActionType);
        }
        this.getActiveFromJson().ifPresent(processConfigurations::setActive);
        this.getPathFromJson().ifPresent(processConfigurations::setPath);
        this.getRequiredRoles().ifPresent(processConfigurations::setRequiredRoles);
        return processConfigurations;
    }

    Optional<String> getDefaultWorkingDirFromJson() {
        Optional<Object> data = JsonDataFinder.findDataInJson(this.json, "$.defaultWorkingDir");
        return data.map(o -> (String)o).filter(o -> !o.isEmpty());
    }

    Optional<Boolean> getTakesVersionFromJson() {
        Optional<Object> data = JsonDataFinder.findDataInJson(this.json, "$.takesVersion");
        return data.map(o -> (Boolean)o);
    }

    Optional<String> getStatusFromJson() {
        Optional<Object> data = JsonDataFinder.findDataInJson(this.json, "$.status");
        return data.map(o -> (String)o);
    }

    Optional<ComponentProcessConfigurations.InventoryActionType> getInventoryActionTypeFromJson() {
        Optional<Object> data = JsonDataFinder.findDataInJson(this.json, "$.inventoryActionType");
        return data.map(o -> (String)o).map(String::toUpperCase).filter(ComponentProcessConfigurationBuilder.isInventoryActionTypeInputValid()).map(o -> ComponentProcessConfigurations.InventoryActionType.valueOf(o));
    }

    private static Predicate<String> isInventoryActionTypeInputValid() {
        return o -> {
            for (ComponentProcessConfigurations.InventoryActionType type : ComponentProcessConfigurations.InventoryActionType.values()) {
                if (!type.name().equals(o)) continue;
                return true;
            }
            return false;
        };
    }

    Optional<ComponentProcessConfigurations.ConfigActionType> getConfigActionTypeFromJson() {
        Optional<Object> data = JsonDataFinder.findDataInJson(this.json, "$.configActionType");
        return data.map(o -> ComponentProcessConfigurations.ConfigActionType.valueOf((String)o));
    }

    Optional<Boolean> getActiveFromJson() {
        Optional<Object> data = JsonDataFinder.findDataInJson(this.json, "$.active");
        return data.map(o -> (Boolean)o);
    }

    Optional<String> getPathFromJson() {
        Optional<Object> data = JsonDataFinder.findDataInJson(this.json, "$.path");
        return data.map(o -> (String)o);
    }

    Optional<JSONArray> getRequiredRoles() {
        Optional<Object> data = JsonDataFinder.findDataInJson(this.json, "$.requiredRoleNames");
        return data.map(o -> (JSONArray)o);
    }
}

