/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.util.processconfiguration;

import java.util.Optional;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import ucd.pacc.model.Team;
import ucd.pacc.util.ErrorHandler;

public class TeamConfigFactory {
    public static Team buildFromJson(JSONObject teamJson) {
        Team team = new Team();
        Optional<String> teamId = TeamConfigFactory.getDataFromJson(teamJson, "teamId");
        if (teamId.isPresent()) {
            team.setTeamId(teamId.get());
        } else {
            ErrorHandler.printErrorAndExit("TeamId in a Team should be a String ");
        }
        Optional<String> teamLabel = TeamConfigFactory.getDataFromJson(teamJson, "teamLabel");
        if (teamLabel.isPresent()) {
            team.setTeamLabel(teamLabel.get());
        } else {
            ErrorHandler.printErrorAndExit("TeamLabel in a Team should be a String ");
        }
        Optional<String> resourceTypeId = TeamConfigFactory.getDataFromJson(teamJson, "resourceTypeId");
        if (resourceTypeId.isPresent()) {
            team.setResourceTypeId(resourceTypeId.get());
        } else {
            team.setResourceTypeId("20000000000000000000000000000109");
        }
        Optional<String> resourceTypeName = TeamConfigFactory.getDataFromJson(teamJson, "resourceTypeName");
        if (resourceTypeName.isPresent()) {
            team.setResourceTypeName(resourceTypeName.get());
        } else {
            team.setResourceTypeName("Process");
        }
        return team;
    }

    static Optional<String> getDataFromJson(JSONObject json, String data) {
        try {
            return Optional.of((String)json.get(data));
        }
        catch (JSONException e) {
            return Optional.empty();
        }
    }
}

