/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.util.processconfiguration;

import java.net.URI;
import java.net.URISyntaxException;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import ucd.pacc.model.Webhook;
import ucd.pacc.util.ExitException;

public class WebhookFactory {
    public static Webhook buildWebhookFromJson(JSONObject webhookJson) {
        Object template;
        Object proxyPort;
        Webhook webhook = new Webhook();
        Object url = WebhookFactory.getDataFromJson(webhookJson, "url");
        if (url instanceof String) {
            try {
                new URI(url.toString());
            }
            catch (URISyntaxException e) {
                throw new ExitException("Input url should be a valid type of URL, given :" + url);
            }
        } else {
            throw new ExitException("Input url appears to be empty, which is invalid, was given :'" + url + "'");
        }
        webhook.setUrl((String)url);
        Object proxyHost = WebhookFactory.getDataFromJson(webhookJson, "proxyHost");
        if (proxyHost instanceof String) {
            webhook.setProxyHost((String)proxyHost);
        }
        if ((proxyPort = WebhookFactory.getDataFromJson(webhookJson, "proxyPort")) instanceof String) {
            webhook.setProxyPort((String)proxyPort);
        }
        if ((template = WebhookFactory.getDataFromJson(webhookJson, "webhookTemplate")) instanceof JSONObject) {
            webhook.setWebhookTemplate(WebhookFactory.buildTemplateFromJson((JSONObject)template));
        }
        return webhook;
    }

    static Webhook.WebhookTemplate buildTemplateFromJson(JSONObject template) {
        String eventType;
        Object body;
        Webhook.WebhookTemplate webhookTemplate = new Webhook.WebhookTemplate();
        Object name = WebhookFactory.getDataFromJson(template, "name");
        if (!(name instanceof String) || ((String)name).isEmpty()) {
            throw new ExitException("[ERROR] Webhook Template name cannot be empty");
        }
        webhookTemplate.setName((String)name);
        Object description = WebhookFactory.getDataFromJson(template, "description");
        if (description instanceof String) {
            webhookTemplate.setDescription((String)description);
        }
        if (!((body = WebhookFactory.getDataFromJson(template, "body")) instanceof String) || ((String)body).isEmpty()) {
            throw new ExitException("[ERROR] Webhook Template body cannot be empty");
        }
        webhookTemplate.setBody((String)body);
        Object type = WebhookFactory.getDataFromJson(template, "type");
        if (type instanceof String) {
            eventType = ((String)type).toUpperCase();
            if (!WebhookFactory.isValidEventType(eventType)) {
                throw new ExitException("[ERROR] Invalid EventType '" + eventType + "' in Webhook Template ");
            }
        } else {
            throw new ExitException("[ERROR] EventType in Webhook Template cannot be empty");
        }
        webhookTemplate.setType(Webhook.WebhookTemplate.EventType.valueOf(eventType));
        return webhookTemplate;
    }

    private static boolean isValidEventType(String eventType) {
        for (Webhook.WebhookTemplate.EventType type : Webhook.WebhookTemplate.EventType.values()) {
            if (!type.toString().equals(eventType)) continue;
            return true;
        }
        return false;
    }

    static Object getDataFromJson(JSONObject json, String data) {
        try {
            return json.get(data);
        }
        catch (JSONException e) {
            return new Object();
        }
    }
}

