/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.download;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Objects;
import javax.json.Json;
import javax.json.JsonObject;
import org.codehaus.jettison.json.JSONObject;
import ucd.pacc.download.ProcessDataHandler;
import ucd.pacc.download.ScriptExtractor;
import ucd.pacc.download.UcdToUserJsonConvertor;
import ucd.pacc.main.ProcessType;
import ucd.pacc.model.StepGraph;
import ucd.pacc.parser.ParseException;
import ucd.pacc.parser.ParseSink;
import ucd.pacc.parser.ParseSource;
import ucd.pacc.parser.json.JsonParser;
import ucd.pacc.upload.Translator;
import ucd.pacc.upload.TranslatorOptions;
import ucd.pacc.util.FileTypeConverter;

public class Downloader
implements Translator {
    private final ParseSource source;
    private final ParseSink sink;
    String processType;
    String processName;
    String parentName;
    String outPutFileType;

    public Downloader(ParseSource source, ParseSink sink, TranslatorOptions options) {
        this.source = source;
        this.source.getClass();
        this.sink = sink;
        this.sink.getClass();
        options.getClass();
    }

    public void setProcessType(ProcessType processType) {
        this.processType = processType.toString();
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    public void setOutPutFileType(String outPutFileType) {
        this.outPutFileType = outPutFileType;
    }

    @Override
    public void translate() throws IOException, ParseException {
        JsonParser parser = new JsonParser();
        JsonObject originalJson = Json.createReader((Reader)this.source.getReader()).readObject();
        StepGraph graph = parser.parse(this.source);
        UcdToUserJsonConvertor convertor = new UcdToUserJsonConvertor();
        convertor.process(graph);
        String outputDir = this.processName;
        JSONObject updatedProcessDesign = this.getJsonObject(convertor.getProcessJson(), outputDir);
        ProcessDataHandler metaDataHandler = new ProcessDataHandler(updatedProcessDesign, this.processType, this.processName, this.parentName);
        String finalOutput = metaDataHandler.addProcessConfiguration(originalJson.toString());
        if (Objects.equals(this.outPutFileType, "yml")) {
            finalOutput = FileTypeConverter.jsonToYaml(finalOutput);
        }
        Writer writer = this.sink.getWriter();
        writer.write(finalOutput);
        writer.write("\n");
    }

    private JSONObject getJsonObject(JSONObject processJsonDesign, String dir) {
        ScriptExtractor scriptExtractor = new ScriptExtractor(this.processName, this.parentName);
        JSONObject updatedProcessDesign = scriptExtractor.extractScriptFilesFromProcessDesignJson(processJsonDesign, dir);
        return updatedProcessDesign;
    }
}

