/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.download;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.stream.Collectors;
import ucd.pacc.download.DefaultValueSelector;
import ucd.pacc.download.SelectPropertyValueWithSelectedFlag;
import ucd.pacc.model.AbstractManualTaskStep;
import ucd.pacc.model.AcquireLockStep;
import ucd.pacc.model.ActionGroup;
import ucd.pacc.model.ActionGroupStep;
import ucd.pacc.model.ActionsOnEvent;
import ucd.pacc.model.AddInventoryStatusStep;
import ucd.pacc.model.AddProcessWarningStep;
import ucd.pacc.model.AnyUserTaskApprovalRestriction;
import ucd.pacc.model.AppProcessResourceStep;
import ucd.pacc.model.AppProcessStep;
import ucd.pacc.model.AppRemovalProcessStep;
import ucd.pacc.model.ApplicationRunComponentProcessStep;
import ucd.pacc.model.CheckboxPropertyDefinitionOptions;
import ucd.pacc.model.CommonPropertyDefinitionOptions;
import ucd.pacc.model.ComponentRunComponentProcessStep;
import ucd.pacc.model.ComponentStep;
import ucd.pacc.model.DateTimePropertyDefinitionOptions;
import ucd.pacc.model.DeployingUserTaskApprovalRestriction;
import ucd.pacc.model.FinishStep;
import ucd.pacc.model.ForEachAgentStep;
import ucd.pacc.model.ForEachResourceTagStep;
import ucd.pacc.model.GenericManualTaskStep;
import ucd.pacc.model.IdentityBasedTaskApprovalRestriction;
import ucd.pacc.model.InventoryStep;
import ucd.pacc.model.JoinStep;
import ucd.pacc.model.MultiComponentStep;
import ucd.pacc.model.MultiSelectPropertyDefinitionOptions;
import ucd.pacc.model.MultiValuedPropertyDefinitionOptions;
import ucd.pacc.model.PluginStep;
import ucd.pacc.model.Property;
import ucd.pacc.model.PropertyContainer;
import ucd.pacc.model.PropertyDefinition;
import ucd.pacc.model.PropertyDefinitionOptions;
import ucd.pacc.model.ReleaseLockStep;
import ucd.pacc.model.RemoveInventoryStatusStep;
import ucd.pacc.model.ResourceStep;
import ucd.pacc.model.ResourceTagName;
import ucd.pacc.model.RoleBasedTaskApprovalRestriction;
import ucd.pacc.model.RoleRestriction;
import ucd.pacc.model.RunGenericProcessStep;
import ucd.pacc.model.RunOnFirstOnlineResourceOnlyStep;
import ucd.pacc.model.RunOperationalProcessForMultipleComponentsStep;
import ucd.pacc.model.SecurePropertyDefinitionOptions;
import ucd.pacc.model.SelectPropertyDefinitionOptions;
import ucd.pacc.model.SetFinalProcessStatusStep;
import ucd.pacc.model.StartStep;
import ucd.pacc.model.Step;
import ucd.pacc.model.StepAction;
import ucd.pacc.model.StepActionFinish;
import ucd.pacc.model.StepActionStart;
import ucd.pacc.model.Stringish;
import ucd.pacc.model.SwitchStep;
import ucd.pacc.model.TaskApprovalRestriction;
import ucd.pacc.model.TextAreaPropertyDefinitionOptions;
import ucd.pacc.model.TextPropertyDefinitionOptions;
import ucd.pacc.parser.ParseException;
import ucd.pacc.util.StepGraphProcessor;
import ucd.pacc.util.Util;

class GraphPacBuilder
extends StepGraphProcessor<GraphPacBuilder> {
    private static final String ON_CASE = "on case";
    private static final String ON_DEFAULT = "on default";
    private static final String INDENT = "    ";
    private final StringBuilder builder = new StringBuilder();
    private final Deque<String> indents = new ArrayDeque<String>();

    GraphPacBuilder() {
    }

    public String getString() {
        this.checkExecuted();
        return this.builder.toString();
    }

    @Override
    protected void processStep(Step step) throws ParseException {
        if (step instanceof ForEachResourceTagStep) {
            this.processForEachResourceTagStep((ForEachResourceTagStep)step);
        } else if (step instanceof ForEachAgentStep) {
            this.processForEachAgentStep((ForEachAgentStep)step);
        } else if (step instanceof PluginStep) {
            this.processPluginStep((PluginStep)step);
        } else if (step instanceof AcquireLockStep) {
            this.processAcquireLockStep((AcquireLockStep)step);
        } else if (step instanceof ReleaseLockStep) {
            this.processReleaseLockStep((ReleaseLockStep)step);
        } else if (step instanceof SetFinalProcessStatusStep) {
            this.processSetFinalStatusStep((SetFinalProcessStatusStep)step);
        } else if (step instanceof AddInventoryStatusStep) {
            this.processAddInventoryStatusStep((AddInventoryStatusStep)step);
        } else if (step instanceof RemoveInventoryStatusStep) {
            this.processRemoveInventoryStatusStep((RemoveInventoryStatusStep)step);
        } else if (step instanceof AddProcessWarningStep) {
            this.processAddProcessWarningStep((AddProcessWarningStep)step);
        } else if (step instanceof RunGenericProcessStep) {
            this.processRunGenericProcessStep((RunGenericProcessStep)step);
        } else if (step instanceof ComponentRunComponentProcessStep) {
            this.processComponentRunComponentProcessStep((ComponentRunComponentProcessStep)step);
        } else if (step instanceof GenericManualTaskStep) {
            this.processGenericManualTaskStep((GenericManualTaskStep)step);
        } else if (step instanceof AbstractManualTaskStep) {
            this.processAbstractManualTaskStep((AbstractManualTaskStep)step);
        } else if (step instanceof SwitchStep) {
            this.processSwitchStep((SwitchStep)step);
        } else if (step instanceof JoinStep) {
            this.processJoinStep((JoinStep)step);
        } else if (step instanceof FinishStep) {
            this.processFinishStep((FinishStep)step);
        } else if (step instanceof StartStep) {
            this.processStartStep((StartStep)step);
        } else if (step instanceof AppProcessStep) {
            System.out.println("PAC building using AppProcessStep ");
            this.processAppProcessStep((AppProcessStep)step);
        } else {
            throw new RuntimeException("unimplemented step: " + step.getClass().getName());
        }
    }

    @Override
    protected GraphPacBuilder createNestedInstance() throws ParseException {
        return this;
    }

    @Override
    protected void processStepStart(Step step) throws ParseException {
        if (step instanceof ForEachResourceTagStep) {
            this.processForEachResourceTagStepStart((ForEachResourceTagStep)step);
        } else if (step instanceof ForEachAgentStep) {
            this.processForEachAgentStepStart((ForEachAgentStep)step);
        } else {
            System.out.println("processStepStart : not performed for " + step.getName());
        }
    }

    @Override
    protected void processStepEnd(Step step) throws ParseException {
        if (step instanceof ForEachResourceTagStep) {
            this.processForEachResourceTagStepEnd((ForEachResourceTagStep)step);
        } else if (step instanceof ForEachAgentStep) {
            this.processForEachAgentStepEnd((ForEachAgentStep)step);
        } else {
            System.out.println("processStepEnd : no action as step is not instance of ForEachResourceTagStep or ForEachAgentStep ");
        }
    }

    protected void processForEachResourceTagStepStart(ForEachResourceTagStep step) {
        this.appendStepStart(step);
        for (ResourceTagName tag : step.getTags()) {
            this.appendLine("tag", tag);
        }
        this.appendLine("max-concurrent-tags", step.getMaxConcurrentTags());
        this.appendLine(new Object[0]);
    }

    protected void processForEachResourceTagStepEnd(ForEachResourceTagStep step) {
        this.appendActionGroup(step);
        this.appendStepEnd();
    }

    protected void processForEachAgentStepStart(ForEachAgentStep step) {
        this.appendStepStart(step);
        for (ResourceTagName tag : step.getTags()) {
            this.appendLine("tag", tag);
        }
        this.appendLine("max-concurrent-agents", step.getMaxConcurrentAgents());
        this.appendLine(new Object[0]);
    }

    protected void processForEachAgentStepEnd(ForEachAgentStep step) {
        this.appendActionGroup(step);
        this.appendStepEnd();
    }

    protected void processAppProcessStep(AppProcessStep step) {
        AppProcessResourceStep procStep;
        MultiComponentStep multiStep;
        System.out.println("processAppProcessStep : Add step start ");
        this.appendStepStart(step);
        if (step instanceof ComponentStep) {
            ComponentStep componentStep = (ComponentStep)((Object)step);
            System.out.println("processAppProcessStep : Add component step props");
            this.appendLine("component", componentStep.getComponent());
        }
        System.out.println("processAppProcessStep : add process by appendline ");
        this.appendLine("process", step.getProcess());
        if (step instanceof AppRemovalProcessStep) {
            AppRemovalProcessStep removalStep = (AppRemovalProcessStep)((Object)step);
            this.appendLine(removalStep.getPacRemovalTypeKeyword(), removalStep.getRemovalType().getPacKeyword());
        }
        if (step instanceof InventoryStep) {
            InventoryStep inventoryStep = (InventoryStep)((Object)step);
            this.appendLine(inventoryStep.getPacTargetInventoryStatusKeyword(), inventoryStep.getTargetInventoryStatus());
        }
        if (step instanceof MultiComponentStep) {
            multiStep = (MultiComponentStep)((Object)step);
            multiStep.getByComponentTag().ifPresent(tag -> this.appendLine("select-components-by-tag", tag));
        }
        if (step instanceof ResourceStep) {
            ResourceStep resourceStep = (ResourceStep)((Object)step);
            resourceStep.getByResourceTag().ifPresent(tag -> this.appendLine("select-resources-by-tag", tag));
        }
        if (step instanceof ApplicationRunComponentProcessStep) {
            procStep = (ApplicationRunComponentProcessStep)step;
            ((ApplicationRunComponentProcessStep)procStep).getByChangedComponent().ifPresent(changes -> {
                this.appendLine("select-resources-by-changed-component-list");
                this.pushIndent();
                changes.getComponents().forEach(c -> this.appendLine("component", c));
                this.appendLine("select-resources", changes.getMode().getPacKeyword());
                this.popIndent();
                this.appendLine("end");
            });
        }
        if (step instanceof RunOperationalProcessForMultipleComponentsStep) {
            procStep = (RunOperationalProcessForMultipleComponentsStep)step;
            ((RunOperationalProcessForMultipleComponentsStep)procStep).getByChangedComponent().ifPresent(changes -> {
                this.appendLine("select-resources-by-changed-component-tag");
                this.pushIndent();
                changes.getByComponentTag().ifPresent(tag -> this.appendLine("select-components-by-tag", tag));
                this.appendLine("select-resources", changes.getMode().getPacKeyword());
                this.popIndent();
                this.appendLine("end");
            });
        }
        System.out.println("processAppProcessStep : Add fail fast and ignore child warning info");
        this.appendLine("fail-fast", step.isFailFast());
        this.appendLine("ignore-child-warnings", step.isIgnoreChildWarnings());
        if (step instanceof RunOnFirstOnlineResourceOnlyStep) {
            RunOnFirstOnlineResourceOnlyStep firstOnlineStep = (RunOnFirstOnlineResourceOnlyStep)((Object)step);
            this.appendLine("run-on-first-online-resource-only", firstOnlineStep.isRunOnFirstOnlineResourceOnly());
        }
        System.out.println("processAppProcessStep : add max concurrent processes info ");
        this.appendLine("max-concurrent-processes", step.getMaxConcurrentProcesses());
        if (step instanceof MultiComponentStep) {
            multiStep = (MultiComponentStep)((Object)step);
            this.appendLine("max-concurrent-components", multiStep.getMaxConcurrentComponents());
        }
        step.getPreconditionScript().ifPresent(script -> this.appendLine("precondition-script", script));
        if (step instanceof PropertyContainer) {
            this.appendProperties((PropertyContainer)((Object)step));
        }
        System.out.println("processAppProcessStep : Add action group ");
        this.appendActionGroup(step);
        System.out.println(" processAppProcessStep : add step end ");
        this.appendStepEnd();
    }

    protected void processPluginStep(PluginStep step) {
        this.appendStepStart(step);
        this.appendLine("plugin", step.getPlugin());
        this.appendLine("command", step.getCommand());
        step.getWorkingDirectory().ifPresent(dir -> this.appendLine("working-directory", dir));
        step.getPreconditionScript().ifPresent(script -> this.appendLine("precondition-script", script));
        this.appendProperties(step);
        this.appendActionGroup(step);
        this.appendStepEnd();
    }

    protected void processAcquireLockStep(AcquireLockStep step) {
        this.appendStepStart(step);
        this.appendLine("lock", step.getLock());
        this.appendActionGroup(step);
        this.appendStepEnd();
    }

    protected void processReleaseLockStep(ReleaseLockStep step) {
        this.appendStepStart(step);
        this.appendLine("lock", step.getLock());
        this.appendActionGroup(step);
        this.appendStepEnd();
    }

    protected void processSetFinalStatusStep(SetFinalProcessStatusStep step) {
        this.appendStepStart(step);
        this.appendLine("status", step.getStatus().getPacKeyword());
        this.appendActionGroup(step);
        this.appendStepEnd();
    }

    protected void processAddInventoryStatusStep(AddInventoryStatusStep step) {
        this.appendStepStart(step);
        this.appendLine("status", step.getStatus());
        this.appendActionGroup(step);
        this.appendStepEnd();
    }

    protected void processRemoveInventoryStatusStep(RemoveInventoryStatusStep step) {
        this.appendStepStart(step);
        this.appendLine("status", step.getStatus());
        this.appendActionGroup(step);
        this.appendStepEnd();
    }

    protected void processAddProcessWarningStep(AddProcessWarningStep step) {
        this.appendStepStart(step);
        this.appendLine(step.getWarning());
        this.appendActionGroup(step);
        this.appendStepEnd();
    }

    protected void processRunGenericProcessStep(RunGenericProcessStep step) {
        this.appendStepStart(step);
        this.appendLine("process", step.getProcess());
        step.getResourcePath().ifPresent(path -> this.appendLine("resource-path", path));
        this.appendLine("ignore-child-warnings", step.isIgnoreChildWarnings());
        this.appendProperties(step);
        this.appendActionGroup(step);
        this.appendStepEnd();
    }

    protected void processComponentRunComponentProcessStep(ComponentRunComponentProcessStep step) {
        this.appendStepStart(step);
        this.appendLine("process", step.getProcess());
        this.appendProperties(step);
        this.appendActionGroup(step);
        this.appendStepEnd();
    }

    protected void processSwitchStep(SwitchStep step) {
        this.appendStepStart(step);
        this.appendLine("evaluate", step.getExpression());
        for (SwitchStep.SwitchStepMatchCase kase2 : step.getMatchCases()) {
            this.popIndent();
            this.appendLine(ON_CASE, kase2.getMatch());
            this.pushIndent();
            this.appendStepActions(kase2.getActions());
        }
        step.getDefaultCase().ifPresent(kase -> {
            this.popIndent();
            this.appendLine(ON_DEFAULT);
            this.pushIndent();
            this.appendStepActions(kase.getActions());
        });
        this.appendStepEnd();
    }

    protected void processGenericManualTaskStep(GenericManualTaskStep step) {
        this.appendStepStart(step);
        this.processTaskApprovalRestriction(step.getApprovalRestriction());
        step.getNotificationTemplate().ifPresent(template -> this.appendLine("notification-template", template));
        this.appendLine("comment-required", step.isCommentRequired());
        step.getCommentPrompt().ifPresent(prompt -> this.appendLine("comment-prompt", prompt));
        step.getPropertyDefinitions().forEach(this::processPropertyDefinition);
        this.appendActionGroup(step);
        this.appendStepEnd();
    }

    protected void processAbstractManualTaskStep(AbstractManualTaskStep step) {
        this.appendStepStart(step);
        this.processTaskApprovalRestriction(step.getApprovalRestriction());
        step.getNotificationTemplate().ifPresent(template -> this.appendLine("notification-template", template));
        step.getPropertyDefinitions().forEach(this::processPropertyDefinition);
        this.appendActionGroup(step);
        this.appendStepEnd();
    }

    protected void processTaskApprovalRestriction(TaskApprovalRestriction approvalRestriction) {
        if (approvalRestriction instanceof DeployingUserTaskApprovalRestriction) {
            this.appendLine("restrict-approval-to", "deploying-user");
        } else if (approvalRestriction instanceof RoleBasedTaskApprovalRestriction) {
            RoleBasedTaskApprovalRestriction roleBaseApprovalRestriction = (RoleBasedTaskApprovalRestriction)approvalRestriction;
            this.appendLine("restrict-approval-to", roleBaseApprovalRestriction.getPacKeyword(), "of");
            this.pushIndent();
            roleBaseApprovalRestriction.getRestrictions().forEach(this::processRoleRestriction);
            this.popIndent();
            this.appendLine("end");
        } else if (approvalRestriction instanceof AnyUserTaskApprovalRestriction) {
            this.appendLine("restrict-approval-to", "any-user");
        } else if (approvalRestriction instanceof IdentityBasedTaskApprovalRestriction) {
            IdentityBasedTaskApprovalRestriction identityBasedApprovalRestriction = (IdentityBasedTaskApprovalRestriction)approvalRestriction;
            this.appendLine("restrict-approval-to", "identities");
            this.pushIndent();
            this.processIdentityList(identityBasedApprovalRestriction.getUsers(), "users", "user");
            this.processIdentityList(identityBasedApprovalRestriction.getGroups(), "groups", "group");
            this.popIndent();
            this.appendLine("end");
        } else {
            throw new RuntimeException("unimplemented restriction type: " + approvalRestriction.getClass().getName());
        }
    }

    protected void processIdentityList(List<? extends Stringish> identities, String listKeyword, String elementKeyword) {
        listKeyword.getClass();
        elementKeyword.getClass();
        if (!identities.isEmpty()) {
            this.appendLine(listKeyword, "of");
            this.pushIndent();
            for (Stringish stringish : identities) {
                this.appendLine(elementKeyword, stringish);
            }
            this.popIndent();
            this.appendLine("end");
        }
    }

    protected void processRoleRestriction(RoleRestriction restriction) {
        Util.ifPresentOrElse(restriction.getResourceType(), type -> this.appendLine("role", restriction.getRole(), "for", type), () -> this.appendLine("role", restriction.getRole()));
    }

    protected void processPropertyDefinition(PropertyDefinition propdef) {
        if (!propdef.getOptions().isPresent()) {
            this.appendLine("property-definition", propdef.getName(), "is", propdef.getPacKeyword());
        } else {
            this.appendLine("property-definition", propdef.getName(), "is", propdef.getPacKeyword(), propdef.getPacOptionsKeyword());
            this.pushIndent();
            PropertyDefinitionOptions options = propdef.getOptions().get();
            switch (propdef.getType()) {
                case TEXT: {
                    this.processTextPropertyDefinitionOptions(propdef, (TextPropertyDefinitionOptions)options);
                    break;
                }
                case TEXT_AREA: {
                    this.processTextAreaPropertyDefinitionOptions(propdef, (TextAreaPropertyDefinitionOptions)options);
                    break;
                }
                case SECURE: {
                    this.processSecurePropertyDefinitionOptions(propdef, (SecurePropertyDefinitionOptions)options);
                    break;
                }
                case CHECKBOX: {
                    this.processCheckboxPropertyDefinitionOptions(propdef, (CheckboxPropertyDefinitionOptions)options);
                    break;
                }
                case DATE_TIME: {
                    this.processDateTimePropertyDefinitionOptions(propdef, (DateTimePropertyDefinitionOptions)options);
                    break;
                }
                case MULTI_SELECT: {
                    this.processMultiSelectPropertyDefinitionOptions(propdef, (MultiSelectPropertyDefinitionOptions)options);
                    break;
                }
                case SELECT: {
                    this.processSelectPropertyDefinitionOptions(propdef, (SelectPropertyDefinitionOptions)options);
                    break;
                }
                default: {
                    throw new RuntimeException("unimplemented propdef type: " + propdef.getType());
                }
            }
            this.popIndent();
            this.appendLine("end");
        }
    }

    protected void processTextPropertyDefinitionOptions(PropertyDefinition propdef, TextPropertyDefinitionOptions options) {
        options.getCommonOptions().ifPresent(this::processCommonPropertyDefinitionOptions);
        options.getDefaultValue().ifPresent(value -> this.appendLine("default", value));
    }

    protected void processTextAreaPropertyDefinitionOptions(PropertyDefinition propdef, TextAreaPropertyDefinitionOptions options) {
        options.getCommonOptions().ifPresent(this::processCommonPropertyDefinitionOptions);
        options.getDefaultValue().ifPresent(value -> this.appendLine("default", value));
    }

    protected void processSecurePropertyDefinitionOptions(PropertyDefinition propdef, SecurePropertyDefinitionOptions options) {
        options.getCommonOptions().ifPresent(this::processSecurePropertyDefinitionOptions);
        options.getDefaultValue().ifPresent(value -> this.appendLine("default", value));
    }

    protected void processCheckboxPropertyDefinitionOptions(PropertyDefinition propdef, CheckboxPropertyDefinitionOptions options) {
        options.getCommonOptions().ifPresent(this::processCommonPropertyDefinitionOptions);
        this.appendLine("default", options.getDefaultValue());
    }

    protected void processDateTimePropertyDefinitionOptions(PropertyDefinition propdef, DateTimePropertyDefinitionOptions options) {
        options.getCommonOptions().ifPresent(this::processCommonPropertyDefinitionOptions);
        options.getDefaultValue().ifPresent(value -> this.appendLine("default", "millis", value.toEpochMilli()));
    }

    protected void processSelectPropertyDefinitionOptions(PropertyDefinition propdef, SelectPropertyDefinitionOptions options) {
        DefaultValueSelector selector = new DefaultValueSelector(options.getDefaultValue());
        this.processMultiValuedPropertyDefinitionOptions(options, selector);
    }

    protected void processMultiSelectPropertyDefinitionOptions(PropertyDefinition propdef, MultiSelectPropertyDefinitionOptions options) {
        DefaultValueSelector selector = new DefaultValueSelector(options.getDefaultValues());
        this.processMultiValuedPropertyDefinitionOptions(options, selector);
    }

    protected void processMultiValuedPropertyDefinitionOptions(MultiValuedPropertyDefinitionOptions options, DefaultValueSelector selector) {
        options.getValues().stream().map(SelectPropertyValueWithSelectedFlag::new).map(selector::selectIfDefault).forEach(this::processSelectPropertyValueWithSelectedFlag);
        options.getCommonOptions().ifPresent(commons -> {
            this.popIndent();
            this.appendLine("with");
            this.pushIndent();
            this.processCommonPropertyDefinitionOptions((CommonPropertyDefinitionOptions)commons);
        });
    }

    protected void processSelectPropertyValueWithSelectedFlag(SelectPropertyValueWithSelectedFlag value) {
        boolean hasLabel = value.getLabel().isPresent();
        boolean isSelected = value.isSelected();
        if (hasLabel && isSelected) {
            this.appendLine("value", value.getValue(), "as", value.getLabel().get(), "selected");
        } else if (hasLabel) {
            this.appendLine("value", value.getValue(), "as", value.getLabel().get());
        } else if (isSelected) {
            this.appendLine("value", value.getValue(), "selected");
        } else {
            this.appendLine("value", value.getValue());
        }
    }

    protected void processCommonPropertyDefinitionOptions(CommonPropertyDefinitionOptions options) {
        options.getLabel().ifPresent(label -> this.appendLine("label", label));
        options.getDescription().ifPresent(description -> this.appendLine("description", description));
        options.getPattern().ifPresent(pattern -> this.appendLine("pattern", pattern));
        if (options.isRequired()) {
            this.appendLine("required", options.isRequired());
        }
    }

    protected void processSecurePropertyDefinitionOptions(CommonPropertyDefinitionOptions options) {
        options.getLabel().ifPresent(label -> this.appendLine("label", label));
        options.getDescription().ifPresent(description -> this.appendLine("description", description));
        if (options.isRequired()) {
            this.appendLine("required", options.isRequired());
        }
    }

    protected void processJoinStep(JoinStep step) {
        this.appendStepStart(step);
        this.appendStepActions(step.getActions());
        this.appendStepEnd();
    }

    protected void processStartStep(StartStep step) {
        this.appendLine(step.getPacStepKeyword(), "is");
        this.pushIndent();
        this.appendStepActions(step.getActions());
        this.appendStepEnd();
    }

    protected void processForEachResourceTagStep(ForEachResourceTagStep step) {
    }

    protected void processForEachAgentStep(ForEachAgentStep step) {
    }

    protected void processFinishStep(FinishStep step) {
    }

    protected void appendProperties(PropertyContainer container) {
        for (Property prop : container.getProperties()) {
            this.appendLine("property", prop.getName(), "=", prop.getExpression());
        }
    }

    protected void appendStepStart(Step step) {
        System.out.println("adding step start for " + step.getName());
        this.appendLine(step.getPacStepKeyword(), "step", step.getName(), "is");
        this.pushIndent();
    }

    protected void appendStepEnd() {
        this.popIndent();
        this.appendLine("end");
        this.appendLine(new Object[0]);
    }

    protected void appendLine(Object ... words) {
        for (String indent : this.indents) {
            this.builder.append(indent);
        }
        String line = Arrays.stream(words).map(w -> {
            if (w instanceof Stringish) {
                return ((Stringish)w).quote();
            }
            return w.toString();
        }).collect(Collectors.joining(" ", "", "\n"));
        System.out.println("appending line " + line);
        this.builder.append(line);
    }

    protected void pushIndent() {
        this.indents.push(INDENT);
    }

    protected void popIndent() {
        this.indents.pop();
    }

    protected void appendActionGroup(ActionGroupStep step) {
        ActionGroup group = step.getActionGroup();
        group.getActionsOnSuccess().ifPresent(this::appendActions);
        group.getActionsOnFailure().ifPresent(this::appendActions);
        group.getActionsOnComplete().ifPresent(this::appendActions);
    }

    protected void appendActions(ActionsOnEvent actions) {
        this.popIndent();
        this.appendLine("on", actions.getEvent().getPacKeyword());
        this.pushIndent();
        this.appendStepActions(actions.getActions());
    }

    protected void appendStepActions(List<StepAction> actions) {
        for (StepAction action : actions) {
            if (action instanceof StepActionFinish) {
                this.appendLine("finish");
                continue;
            }
            if (action instanceof StepActionStart) {
                this.appendLine("start", action.getTarget());
                continue;
            }
            throw new RuntimeException("unimplemented action: " + action.getClass().getName());
        }
    }
}

