/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.download;

import java.util.Iterator;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import ucd.pacc.main.ProcessType;
import ucd.pacc.model.ApplicationProcessConfigurations;
import ucd.pacc.model.ComponentProcessConfigurations;
import ucd.pacc.model.GenericProcessConfigurations;
import ucd.pacc.util.ErrorHandler;
import ucd.pacc.util.processconfiguration.ApplicationProcessConfigurationBuilder;
import ucd.pacc.util.processconfiguration.ComponentProcessConfigurationBuilder;
import ucd.pacc.util.processconfiguration.GenericProcessConfigurationBuilder;

public class ProcessDataHandler {
    private final JSONObject processSteps;
    private final String processType;
    private final ProcessType type;
    private final String processName;
    private final String parent;
    private final JSONObject jsonWithMetaData = new JSONObject();
    public static boolean shouldHandleConfiguration = true;

    public ProcessDataHandler(JSONObject processSteps, String processType, String processName, String parent) {
        this.processSteps = processSteps;
        this.processType = processType;
        this.processName = processName;
        this.parent = parent;
        this.type = ProcessType.valueOf(processType);
    }

    protected String addProcessMetaData() {
        try {
            boolean parentExists;
            boolean bl = parentExists = this.type == ProcessType.COMPONENT || this.type == ProcessType.APPLICATION || this.type == ProcessType.COMPONENT_TEMPLATE || this.type == ProcessType.APPLICATION_TEMPLATE;
            if (parentExists) {
                this.jsonWithMetaData.put(this.processType.toLowerCase(), (Object)this.parent);
            }
            this.jsonWithMetaData.put("process-name", (Object)this.processName);
            this.jsonWithMetaData.put("process", (Object)this.processSteps);
            return this.jsonWithMetaData.toString(4);
        }
        catch (JSONException e) {
            throw new RuntimeException("Error adding data to json object ");
        }
    }

    String addProcessConfiguration(String serverJson) {
        if (!shouldHandleConfiguration) {
            return this.addProcessMetaData();
        }
        if (this.type == ProcessType.APPLICATION) {
            ApplicationProcessConfigurations processConfigurations = (ApplicationProcessConfigurations)new ApplicationProcessConfigurationBuilder().generateConfigurations(serverJson);
            this.mergeJson(this.jsonWithMetaData, processConfigurations.toJson());
        } else if (this.type == ProcessType.COMPONENT) {
            ComponentProcessConfigurations processConfigurations = (ComponentProcessConfigurations)new ComponentProcessConfigurationBuilder().generateConfigurations(serverJson);
            this.mergeJson(this.jsonWithMetaData, processConfigurations.toJson());
        } else if (this.type == ProcessType.GENERIC) {
            GenericProcessConfigurations processConfigurations = (GenericProcessConfigurations)new GenericProcessConfigurationBuilder().generateConfigurations(serverJson);
            this.mergeJson(this.jsonWithMetaData, processConfigurations.toJson());
        } else if (this.type == ProcessType.APPLICATION_TEMPLATE || this.type == ProcessType.COMPONENT_TEMPLATE) {
            System.out.println("[INFO] Process configurations are not supported for process templates yet");
        }
        return this.addProcessMetaData();
    }

    private void mergeJson(JSONObject jsonMetaData, JSONObject configJson) {
        Iterator configJsonKeys = configJson.keys();
        while (configJsonKeys.hasNext()) {
            String key = (String)configJsonKeys.next();
            try {
                jsonMetaData.put(key, configJson.get(key));
            }
            catch (JSONException e) {
                ErrorHandler.printErrorAndExit("[ERROR] Unable to build configuration json using key" + key + " from " + configJson);
            }
        }
    }
}

