/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.download;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.json.JsonObject;
import javax.json.JsonStructure;
import ucd.pacc.model.CheckboxPropertyDefinitionOptions;
import ucd.pacc.model.DateTimePropertyDefinitionOptions;
import ucd.pacc.model.MultiSelectPropertyDefinitionOptions;
import ucd.pacc.model.PropertyDefinition;
import ucd.pacc.model.PropertyDefinitionOptions;
import ucd.pacc.model.PropertyDefinitionType;
import ucd.pacc.model.PropertyDescription;
import ucd.pacc.model.PropertyExpression;
import ucd.pacc.model.PropertyLabel;
import ucd.pacc.model.PropertyName;
import ucd.pacc.model.PropertyPattern;
import ucd.pacc.model.SecurePropertyDefinitionOptions;
import ucd.pacc.model.SelectPropertyDefinitionOptions;
import ucd.pacc.model.SelectPropertyValue;
import ucd.pacc.model.TextAreaPropertyDefinitionOptions;
import ucd.pacc.model.TextPropertyDefinitionOptions;
import ucd.pacc.util.JsonUtil;
import ucd.pacc.util.Util;

public class PropertyDefinitionBuilder {
    JsonObject object;
    JsonUtil jsonUtil;

    public Stream<PropertyDefinition> build(JsonObject obj, JsonUtil util) {
        this.object = obj;
        this.jsonUtil = util;
        return this.findPropertyDefinitions();
    }

    private Stream<PropertyDefinition> findPropertyDefinitions() {
        return Optional.ofNullable(this.object.getJsonArray("propDefs")).map(Collection::stream).orElse(Stream.empty()).flatMap(Util.asInstanceofStream(JsonObject.class)).flatMap(this::extractPropertyDefinition);
    }

    protected Stream<PropertyDefinition> extractPropertyDefinition(JsonObject jsonPropdef) {
        Optional<PropertyName> name = this.getName(jsonPropdef);
        Optional<PropertyDefinitionType> type = this.getType(jsonPropdef);
        if (!name.isPresent() || !type.isPresent()) {
            return Stream.empty();
        }
        PropertyDefinition value = new PropertyDefinition(type.get(), name.get());
        value.setOptions(Optional.of(this.extractPropertyDefinitionOptions(value, jsonPropdef)));
        return Stream.of(value);
    }

    protected PropertyDefinitionOptions extractPropertyDefinitionOptions(PropertyDefinition propdef, JsonObject jsonPropdef) {
        PropertyDefinitionType type = propdef.getType();
        switch (type) {
            case TEXT: {
                return this.extractTextPropertyDefinitionOptions(jsonPropdef);
            }
            case TEXT_AREA: {
                return this.extractTextAreaPropertyDefinitionOptions(jsonPropdef);
            }
            case SECURE: {
                return this.extractSecurePropertyDefinitionOptions(jsonPropdef);
            }
            case CHECKBOX: {
                return this.extractCheckboxPropertyDefinitionOptions(jsonPropdef);
            }
            case DATE_TIME: {
                return this.extractDateTimePropertyDefinitionOptions(jsonPropdef);
            }
            case SELECT: {
                return this.extractSelectPropertyDefinitionOptions(jsonPropdef);
            }
            case MULTI_SELECT: {
                return this.extractMultiSelectPropertyDefinitionOptions(jsonPropdef);
            }
        }
        throw new RuntimeException("unimplemented property definition type: " + type);
    }

    protected TextPropertyDefinitionOptions extractTextPropertyDefinitionOptions(JsonObject jsonPropdef) {
        TextPropertyDefinitionOptions options = new TextPropertyDefinitionOptions();
        this.configureCommonOptions(options, jsonPropdef);
        options.setDefaultValue((Optional)this.getPropertyExpressionDefaultValue(jsonPropdef));
        return options;
    }

    protected TextAreaPropertyDefinitionOptions extractTextAreaPropertyDefinitionOptions(JsonObject jsonPropdef) {
        TextAreaPropertyDefinitionOptions options = new TextAreaPropertyDefinitionOptions();
        this.configureCommonOptions(options, jsonPropdef);
        options.setDefaultValue((Optional)this.getPropertyExpressionDefaultValue(jsonPropdef));
        return options;
    }

    protected SecurePropertyDefinitionOptions extractSecurePropertyDefinitionOptions(JsonObject jsonPropdef) {
        SecurePropertyDefinitionOptions options = new SecurePropertyDefinitionOptions();
        options.setLabel((Optional)this.getLabel(jsonPropdef));
        options.setDescription((Optional)this.getDescription(jsonPropdef));
        options.setRequired(this.getRequired(jsonPropdef));
        options.setDefaultValue((Optional)this.getPropertyExpressionDefaultValue(jsonPropdef));
        return options;
    }

    protected CheckboxPropertyDefinitionOptions extractCheckboxPropertyDefinitionOptions(JsonObject jsonPropdef) {
        CheckboxPropertyDefinitionOptions options = new CheckboxPropertyDefinitionOptions();
        this.configureCommonOptions(options, jsonPropdef);
        options.setDefaultValue(this.getCheckboxDefaultValue(jsonPropdef));
        return options;
    }

    protected DateTimePropertyDefinitionOptions extractDateTimePropertyDefinitionOptions(JsonObject jsonPropdef) {
        DateTimePropertyDefinitionOptions options = new DateTimePropertyDefinitionOptions();
        this.configureCommonOptions(options, jsonPropdef);
        options.setDefaultValue(this.getDateTimeDefaultValue(jsonPropdef));
        return options;
    }

    protected SelectPropertyDefinitionOptions extractSelectPropertyDefinitionOptions(JsonObject jsonPropdef) {
        SelectPropertyDefinitionOptions options = new SelectPropertyDefinitionOptions();
        this.configureCommonOptions(options, jsonPropdef);
        this.findAllowedValues(jsonPropdef).forEach(options::addValue);
        this.configureSelectDefaultValue(options, jsonPropdef);
        return options;
    }

    protected MultiSelectPropertyDefinitionOptions extractMultiSelectPropertyDefinitionOptions(JsonObject jsonPropdef) {
        MultiSelectPropertyDefinitionOptions options = new MultiSelectPropertyDefinitionOptions();
        this.configureCommonOptions(options, jsonPropdef);
        this.findAllowedValues(jsonPropdef).forEach(options::addValue);
        this.configureMultiSelectDefaultValues(options, jsonPropdef);
        return options;
    }

    protected void configureSelectDefaultValue(SelectPropertyDefinitionOptions options, JsonObject jsonPropdef) {
        options.setDefaultValue(this.getSelectPropertyValueValue(jsonPropdef));
    }

    protected void configureMultiSelectDefaultValues(MultiSelectPropertyDefinitionOptions options, JsonObject jsonPropdef) {
        this.getProperty(jsonPropdef, this::splitOnCommas, "value").orElse(Stream.empty()).map(SelectPropertyValue::new).forEach(options::addDefaultValue);
    }

    protected Stream<SelectPropertyValue> findAllowedValues(JsonObject jsonPropdef) {
        Stream<SelectPropertyValue> stream = Optional.ofNullable(jsonPropdef.getJsonArray("allowedValues")).map(Collection::stream).orElse(Stream.empty()).flatMap(Util.asInstanceofStream(JsonObject.class)).flatMap(this::extractSelectPropertyValue);
        return stream;
    }

    protected Stream<SelectPropertyValue> extractSelectPropertyValue(JsonObject selectPropertyValue) {
        Optional<SelectPropertyValue> value = this.getSelectPropertyValueValue(selectPropertyValue);
        Optional<PropertyLabel> label = this.getSelectPropertyValueLabel(selectPropertyValue);
        value.ifPresent(v -> v.setLabel(label));
        return value.map(Stream::of).orElse(Stream.empty());
    }

    protected Optional<PropertyLabel> getSelectPropertyValueLabel(JsonObject propdef) {
        return this.getProperty(propdef, PropertyLabel::new, "label");
    }

    protected Optional<SelectPropertyValue> getSelectPropertyValueValue(JsonObject propdef) {
        return this.getProperty(propdef, SelectPropertyValue::new, "value");
    }

    protected void configureCommonOptions(PropertyDefinitionOptions options, JsonObject jsonPropdef) {
        options.setLabel(this.getLabel(jsonPropdef));
        options.setDescription(this.getDescription(jsonPropdef));
        options.setPattern(this.getPattern(jsonPropdef));
        options.setRequired(this.getRequired(jsonPropdef));
    }

    protected Optional<PropertyExpression> getPropertyExpressionDefaultValue(JsonObject propdef) {
        return this.getProperty(propdef, PropertyExpression::new, "value");
    }

    protected boolean getCheckboxDefaultValue(JsonObject propdef) {
        return this.getProperty(propdef, Boolean::parseBoolean, "value").orElse(false);
    }

    protected Optional<PropertyName> getName(JsonObject propdef) {
        return this.getProperty(propdef, PropertyName::new, "name");
    }

    protected Optional<PropertyDefinitionType> getType(JsonObject propdef) {
        return this.getProperty(propdef, PropertyDefinitionType::getForJsonKeyword, "type");
    }

    protected Optional<PropertyLabel> getLabel(JsonObject propdef) {
        return this.getProperty(propdef, PropertyLabel::new, "label");
    }

    protected Optional<PropertyPattern> getPattern(JsonObject propdef) {
        return this.getProperty(propdef, PropertyPattern::new, "pattern");
    }

    protected Optional<PropertyDescription> getDescription(JsonObject propdef) {
        return this.getProperty(propdef, PropertyDescription::new, "description");
    }

    protected <U> Optional<U> getProperty(JsonObject object, Function<String, U> parser, String fieldName) {
        return this.jsonUtil.findUnique((JsonStructure)object, "$." + fieldName, String.class).filter(Util::isNotEmpty).map(parser);
    }

    protected boolean getRequired(JsonObject propdef) {
        return this.jsonUtil.findUnique((JsonStructure)propdef, "$.required", Boolean.class).orElse(false);
    }

    protected Optional<Instant> getDateTimeDefaultValue(JsonObject propdef) {
        return this.getProperty(propdef, Long::parseLong, "value").map(Instant::ofEpochMilli);
    }

    protected Stream<String> splitOnCommas(String string) {
        return Arrays.stream(string.split(",")).filter(Util::isNotEmpty);
    }
}

