/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.download;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import ucd.pacc.download.DefaultValueSelector;
import ucd.pacc.download.SelectPropertyValueWithSelectedFlag;
import ucd.pacc.model.CheckboxPropertyDefinitionOptions;
import ucd.pacc.model.CommonPropertyDefinitionOptions;
import ucd.pacc.model.DateTimePropertyDefinitionOptions;
import ucd.pacc.model.MultiSelectPropertyDefinitionOptions;
import ucd.pacc.model.MultiValuedPropertyDefinitionOptions;
import ucd.pacc.model.PropertyDefinition;
import ucd.pacc.model.PropertyDefinitionOptions;
import ucd.pacc.model.SecurePropertyDefinitionOptions;
import ucd.pacc.model.SelectPropertyDefinitionOptions;
import ucd.pacc.model.TextAreaPropertyDefinitionOptions;
import ucd.pacc.model.TextPropertyDefinitionOptions;

public class PropertyDefinitionToUserJsonConvertor {
    void addAppropriatePropertyTypeDefinitionToUserJson(PropertyDefinition propdef, PropertyDefinitionOptions options, JSONObject propJson) {
        switch (propdef.getType()) {
            case TEXT: {
                this.processTextPropertyDefinitionOptions(propdef, (TextPropertyDefinitionOptions)options, propJson);
                break;
            }
            case TEXT_AREA: {
                this.processTextAreaPropertyDefinitionOptions(propdef, (TextAreaPropertyDefinitionOptions)options, propJson);
                break;
            }
            case SECURE: {
                this.processSecurePropertyDefinitionOptions(propdef, (SecurePropertyDefinitionOptions)options, propJson);
                break;
            }
            case CHECKBOX: {
                this.processCheckboxPropertyDefinitionOptions(propdef, (CheckboxPropertyDefinitionOptions)options, propJson);
                break;
            }
            case DATE_TIME: {
                this.processDateTimePropertyDefinitionOptions(propdef, (DateTimePropertyDefinitionOptions)options, propJson);
                break;
            }
            case MULTI_SELECT: {
                this.processMultiSelectPropertyDefinitionOptions(propdef, (MultiSelectPropertyDefinitionOptions)options, propJson);
                break;
            }
            case SELECT: {
                this.processSelectPropertyDefinitionOptions(propdef, (SelectPropertyDefinitionOptions)options, propJson);
                break;
            }
            default: {
                throw new RuntimeException("unimplemented propdef type: " + propdef.getType());
            }
        }
    }

    protected void processTextPropertyDefinitionOptions(PropertyDefinition propdef, TextPropertyDefinitionOptions options, JSONObject propJson) {
        options.getCommonOptions().ifPresent(option -> this.processCommonPropertyDefinitionOptions((CommonPropertyDefinitionOptions)option, propJson));
        options.getDefaultValue().ifPresent(value -> this.addKeyValueToJson("default", value.escape(), propJson));
    }

    protected void processTextAreaPropertyDefinitionOptions(PropertyDefinition propdef, TextAreaPropertyDefinitionOptions options, JSONObject propJson) {
        options.getCommonOptions().ifPresent(option -> this.processCommonPropertyDefinitionOptions((CommonPropertyDefinitionOptions)option, propJson));
        options.getDefaultValue().ifPresent(value -> this.addKeyValueToJson("default", value.escape(), propJson));
    }

    protected void processSecurePropertyDefinitionOptions(PropertyDefinition propdef, SecurePropertyDefinitionOptions options, JSONObject propJson) {
        options.getCommonOptions().ifPresent(option -> this.processSecurePropertyDefinitionOptions((CommonPropertyDefinitionOptions)option, propJson));
        options.getDefaultValue().ifPresent(value -> this.addKeyValueToJson("default", value.escape(), propJson));
    }

    protected void processCheckboxPropertyDefinitionOptions(PropertyDefinition propdef, CheckboxPropertyDefinitionOptions options, JSONObject propJson) {
        options.getCommonOptions().ifPresent(option -> this.processCommonPropertyDefinitionOptions((CommonPropertyDefinitionOptions)option, propJson));
        this.addKeyValueToJson("default", options.getDefaultValue(), propJson);
    }

    protected void processDateTimePropertyDefinitionOptions(PropertyDefinition propdef, DateTimePropertyDefinitionOptions options, JSONObject propJson) {
        options.getCommonOptions().ifPresent(option -> this.processCommonPropertyDefinitionOptions((CommonPropertyDefinitionOptions)option, propJson));
        options.getDefaultValue().ifPresent(value -> this.addKeyValueToJson("default", this.getReadableDateTimeFromEpoch((Instant)value), propJson));
    }

    protected String getReadableDateTimeFromEpoch(Instant instant) {
        LocalDateTime dateTime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm");
        return dateTime.format(formatter);
    }

    protected void processSelectPropertyDefinitionOptions(PropertyDefinition propdef, SelectPropertyDefinitionOptions options, JSONObject propJson) {
        DefaultValueSelector selector = new DefaultValueSelector(options.getDefaultValue());
        this.processMultiValuedPropertyDefinitionOptions(options, selector, propJson);
    }

    protected void processMultiSelectPropertyDefinitionOptions(PropertyDefinition propdef, MultiSelectPropertyDefinitionOptions options, JSONObject propJson) {
        DefaultValueSelector selector = new DefaultValueSelector(options.getDefaultValues());
        this.processMultiValuedPropertyDefinitionOptions(options, selector, propJson);
    }

    protected void processMultiValuedPropertyDefinitionOptions(MultiValuedPropertyDefinitionOptions options, DefaultValueSelector selector, JSONObject propJson) {
        JSONArray jsonArray = new JSONArray();
        this.addKeyValueToJson("values", jsonArray, propJson);
        options.getValues().stream().map(SelectPropertyValueWithSelectedFlag::new).map(selector::selectIfDefault).forEach(value -> {
            JSONObject multiValueJson = new JSONObject();
            jsonArray.put((Object)multiValueJson);
            this.processSelectPropertyValueWithSelectedFlag((SelectPropertyValueWithSelectedFlag)value, multiValueJson);
        });
        options.getCommonOptions().ifPresent(commons -> this.processCommonPropertyDefinitionOptions((CommonPropertyDefinitionOptions)commons, propJson));
    }

    protected void processSelectPropertyValueWithSelectedFlag(SelectPropertyValueWithSelectedFlag value, JSONObject propJson) {
        boolean hasLabel = value.getLabel().isPresent();
        boolean isSelected = value.isSelected();
        if (hasLabel) {
            this.addKeyValueToJson("label", value.getLabel().get().escape(), propJson);
        }
        if (isSelected) {
            this.addKeyValueToJson("selected", true, propJson);
        }
        this.addKeyValueToJson("value", value.getValue().escape(), propJson);
    }

    protected void processCommonPropertyDefinitionOptions(CommonPropertyDefinitionOptions options, JSONObject propJson) {
        options.getLabel().ifPresent(label -> this.addKeyValueToJson("label", label.escape(), propJson));
        options.getDescription().ifPresent(description -> this.addKeyValueToJson("description", description.escape(), propJson));
        options.getPattern().ifPresent(pattern -> this.addKeyValueToJson("pattern", pattern.escape(), propJson));
        if (options.isRequired()) {
            this.addKeyValueToJson("required", options.isRequired(), propJson);
        }
    }

    protected void processSecurePropertyDefinitionOptions(CommonPropertyDefinitionOptions options, JSONObject propJson) {
        options.getLabel().ifPresent(label -> this.addKeyValueToJson("label", label.escape(), propJson));
        options.getDescription().ifPresent(description -> this.addKeyValueToJson("description", description.escape(), propJson));
        if (options.isRequired()) {
            this.addKeyValueToJson("required", options.isRequired(), propJson);
        }
    }

    protected void addKeyValueToJson(String key, Object value, JSONObject json) {
        try {
            json.put(key, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

