/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.download;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.Optional;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class ScriptExtractor {
    public static final String SCRIPT_BODY = "scriptBody";
    public static final String PROPERTIES = "properties";
    public static final String SPACE_AS_HEX = "%20";
    public static final String QUOTE_AS_HEX = "%22";
    public static final String SCRIPT_FILE_PREFIX = "scriptFile/";
    private final String processName;
    private final String parentName;

    ScriptExtractor(String processName, String parentName) {
        this.processName = processName;
        this.parentName = parentName.isEmpty() ? "Generic" : parentName;
    }

    public JSONObject extractScriptFilesFromProcessDesignJson(JSONObject processSteps, String dir) {
        Iterator keys = processSteps.keys();
        JSONObject resultJson = new JSONObject();
        while (keys.hasNext()) {
            String stepName = (String)keys.next();
            try {
                Optional<String> scriptBodyInPluginStep;
                JSONObject stepJson = (JSONObject)this.getValueFromJson(stepName, processSteps);
                if (this.isStepPluginType(stepJson) && (scriptBodyInPluginStep = this.getOptionalScriptBody(stepJson)).isPresent() && !scriptBodyInPluginStep.get().trim().isEmpty()) {
                    this.writeScriptBodyToFile(scriptBodyInPluginStep.get(), stepName, dir);
                    this.updateFileNameInStep(dir + File.separator + this.getFileName(stepName), stepJson);
                }
                resultJson.put(stepName, (Object)stepJson);
            }
            catch (JsonProcessingException | JSONException e) {
                throw new RuntimeException(e);
            }
        }
        return resultJson;
    }

    protected void updateFileNameInStep(String fileName, JSONObject stepJson) throws JSONException {
        JSONObject pluginProperties = (JSONObject)this.getValueFromJson(PROPERTIES, stepJson);
        pluginProperties.put(SCRIPT_BODY, (Object)(SCRIPT_FILE_PREFIX + fileName));
        stepJson.put(PROPERTIES, (Object)pluginProperties);
    }

    protected void writeScriptBodyToFile(String scriptBody, String stepName, String dir) {
        File outputDir = new File(dir);
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        String fileName = this.getFileName(stepName);
        String fullOutputPath = Paths.get(dir, fileName).toString();
        try (BufferedReader reader = new BufferedReader(new StringReader(scriptBody));
             FileWriter out = new FileWriter(fullOutputPath);){
            String line;
            while ((line = reader.readLine()) != null) {
                out.write(line);
                out.write("\n");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getFileName(String stepName) {
        return this.replaceSpacesAndQuotes(this.parentName) + "-" + this.replaceSpacesAndQuotes(this.processName) + "-" + this.replaceSpacesAndQuotes(stepName) + ".txt";
    }

    protected Optional<String> getOptionalScriptBody(JSONObject stepJson) throws JSONException, JsonProcessingException {
        JSONObject pluginProperties = (JSONObject)this.getValueFromJson(PROPERTIES, stepJson);
        try {
            String scriptBody = pluginProperties.getString(SCRIPT_BODY);
            return Optional.of(scriptBody);
        }
        catch (JSONException e) {
            return Optional.empty();
        }
    }

    private Optional<Object> getOptionalValueFromJson(String key, JSONObject json) {
        try {
            return Optional.of(this.getValueFromJson(key, json));
        }
        catch (JSONException e) {
            return Optional.empty();
        }
    }

    private Object getValueFromJson(String key, JSONObject json) throws JSONException {
        Object value = json.get(key);
        return value;
    }

    protected boolean isStepPluginType(JSONObject stepJson) {
        return this.getOptionalValueFromJson("plugin", stepJson).isPresent();
    }

    public String replaceSpacesAndQuotes(String input) {
        if (input == null) {
            return null;
        }
        return input.replace(" ", SPACE_AS_HEX).replace("\"", QUOTE_AS_HEX);
    }
}

