/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.model;

import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import ucd.pacc.model.ProcessConfigurations;
import ucd.pacc.util.ErrorHandler;

public class ComponentProcessConfigurations
extends ProcessConfigurations {
    private String status;
    private ConfigActionType configActionType;
    private InventoryActionType inventoryActionType;
    private boolean takesVersion;
    private boolean active = true;
    private boolean deleted;
    private String defaultWorkingDir;
    private String path;
    private JSONArray requiredRoles;

    public JSONArray getRequiredRoles() {
        return this.requiredRoles;
    }

    public void setRequiredRoles(JSONArray requiredRoles) {
        this.requiredRoles = requiredRoles;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public ConfigActionType getConfigActionType() {
        return this.configActionType;
    }

    public void setConfigActionType(ConfigActionType configActionType) {
        this.configActionType = configActionType;
    }

    public InventoryActionType getInventoryActionType() {
        return this.inventoryActionType;
    }

    public void setInventoryActionType(InventoryActionType inventoryActionType) {
        this.inventoryActionType = inventoryActionType;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public String getDefaultWorkingDir() {
        return this.defaultWorkingDir;
    }

    public void setDefaultWorkingDir(String defaultWorkingDir) {
        this.defaultWorkingDir = defaultWorkingDir;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setTakesVersion(boolean takeVersion) {
        this.takesVersion = takeVersion;
    }

    public boolean isTakesVersion() {
        return this.takesVersion;
    }

    public void setActive(boolean isActive) {
        this.active = isActive;
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public JSONObject toJson() {
        JSONObject json = new JSONObject();
        try {
            if (this.getDescription() != null && !this.getDescription().isEmpty()) {
                json.put(ProcessConfigurations.DESCRIPTION, (Object)this.getDescription());
            }
            json.put("defaultWorkingDir", (Object)this.getDefaultWorkingDir());
            json.put("takesVersion", this.isTakesVersion());
            if (this.inventoryActionType != null) {
                if (this.status == null || this.status.isEmpty()) {
                    ErrorHandler.printErrorAndExit(" status is a mandatory parameter with a valid status value\n\t for deployment type component process; use default Active if not custom status available ");
                }
                if (this.inventoryActionType == InventoryActionType.ADD) {
                    json.put("inventoryActionType", (Object)this.inventoryActionType.toString());
                    json.put("configActionType", (Object)ConfigActionType.ADD.toString());
                } else {
                    json.put("inventoryActionType", (Object)InventoryActionType.REMOVE);
                }
                json.put("status", (Object)this.getStatus());
            } else if (this.configActionType == ConfigActionType.ADD) {
                json.put("configActionType", (Object)ConfigActionType.ADD.toString());
            }
            JSONArray props = new JSONArray(this.getJsonForPropDefs());
            json.put("propDefs", (Object)props);
            if (this.getRequiredRoles() != null && this.getRequiredRoles().length() > 0) {
                json.put("requiredRoleNames", (Object)this.requiredRoles);
            }
            json.put("active", this.active);
        }
        catch (JSONException e) {
            ErrorHandler.printErrorAndExit(" Unable to construct json data for Component Process Configuration ");
        }
        return json;
    }

    static class ComponentProcessConfigurationsKeywords {
        static final String DEFAULT_WORKING_DIR = "defaultWorkingDir";
        static final String TAKES_VERSION = "takesVersion";
        static final String STATUS = "status";
        static final String CONFIG_ACTION_TYPE = "configActionType";
        static final String PROP_DEFS = "propDefs";
        static final String INVENTORY_ACTION_TYPE = "inventoryActionType";
        static final String REQUIRED_ROLE_NAMES = "requiredRoleNames";
        static final String ACTIVE = "active";

        ComponentProcessConfigurationsKeywords() {
        }
    }

    public static enum InventoryActionType {
        ADD,
        REMOVE;

    }

    public static enum ConfigActionType {
        ADD;

    }
}

