/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.upload;

import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import ucd.pacc.model.CheckboxPropertyDefinitionOptions;
import ucd.pacc.model.DateTimePropertyDefinitionOptions;
import ucd.pacc.model.MultiSelectPropertyDefinitionOptions;
import ucd.pacc.model.PropertyDefinition;
import ucd.pacc.model.PropertyDefinitionOptions;
import ucd.pacc.model.PropertyExpressionPropertyDefinitionOptions;
import ucd.pacc.model.SecurePropertyDefinitionOptions;
import ucd.pacc.model.SelectPropertyDefinitionOptions;
import ucd.pacc.model.SelectPropertyValue;
import ucd.pacc.model.Stringish;
import ucd.pacc.model.TextAreaPropertyDefinitionOptions;
import ucd.pacc.model.TextPropertyDefinitionOptions;
import ucd.pacc.util.Util;

public class PropertyDefinitionToJsonBuilder {
    private int index;

    public JsonObject createPropertyDefinition(PropertyDefinition propdef) {
        Optional<PropertyDefinitionOptions> options = propdef.getOptions();
        switch (propdef.getType()) {
            case TEXT: {
                return this.createTextPropertyDefinition(propdef, options.map(TextPropertyDefinitionOptions.class::cast));
            }
            case TEXT_AREA: {
                return this.createTextAreaPropertyDefinition(propdef, options.map(TextAreaPropertyDefinitionOptions.class::cast));
            }
            case SECURE: {
                return this.createSecurePropertyDefinition(propdef, options.map(SecurePropertyDefinitionOptions.class::cast));
            }
            case CHECKBOX: {
                return this.createCheckboxPropertyDefinition(propdef, options.map(CheckboxPropertyDefinitionOptions.class::cast));
            }
            case DATE_TIME: {
                return this.createDateTimePropertyDefinition(propdef, options.map(DateTimePropertyDefinitionOptions.class::cast));
            }
            case MULTI_SELECT: {
                return this.createMultiSelectPropertyDefinition(propdef, (MultiSelectPropertyDefinitionOptions)options.get());
            }
            case SELECT: {
                return this.createSelectPropertyDefinition(propdef, (SelectPropertyDefinitionOptions)options.get());
            }
        }
        throw new RuntimeException("unimplemented propdef type: " + propdef.getType());
    }

    protected JsonObject createTextPropertyDefinition(PropertyDefinition propdef, Optional<TextPropertyDefinitionOptions> options) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        this.configureCommonPropertyDefinitionSettings(propdef, options, builder);
        this.configurePropertyExpressionDefinitionSettings(options, builder);
        return builder.build();
    }

    protected JsonObject createTextAreaPropertyDefinition(PropertyDefinition propdef, Optional<TextAreaPropertyDefinitionOptions> options) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        this.configureCommonPropertyDefinitionSettings(propdef, options, builder);
        this.configurePropertyExpressionDefinitionSettings(options, builder);
        return builder.build();
    }

    protected JsonObject createSecurePropertyDefinition(PropertyDefinition propdef, Optional<SecurePropertyDefinitionOptions> options) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        this.configurePropertyDefinitionSettings(propdef, options, builder);
        this.configurePropertyExpressionDefinitionSettings(options, builder);
        return builder.build();
    }

    protected JsonObject createCheckboxPropertyDefinition(PropertyDefinition propdef, Optional<CheckboxPropertyDefinitionOptions> options) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        this.configureCommonPropertyDefinitionSettings(propdef, options, builder);
        builder.add("value", options.map(CheckboxPropertyDefinitionOptions::getDefaultValue).map(String::valueOf).orElse("false"));
        return builder.build();
    }

    protected JsonObject createDateTimePropertyDefinition(PropertyDefinition propdef, Optional<DateTimePropertyDefinitionOptions> options) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        this.configureCommonPropertyDefinitionSettings(propdef, options, builder);
        builder.add("value", options.flatMap(DateTimePropertyDefinitionOptions::getDefaultValue).map(Instant::toEpochMilli).map(String::valueOf).orElse(""));
        return builder.build();
    }

    protected JsonObject createSelectPropertyDefinition(PropertyDefinition propdef, SelectPropertyDefinitionOptions options) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        this.configureCommonPropertyDefinitionSettings(propdef, Optional.of(options), builder);
        builder.add("allowedValues", (JsonValue)this.createAllowedValues(options.getValues()));
        builder.add("value", options.getDefaultValue().map(Stringish::getValue).orElse(""));
        return builder.build();
    }

    protected JsonObject createMultiSelectPropertyDefinition(PropertyDefinition propdef, MultiSelectPropertyDefinitionOptions options) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        this.configureCommonPropertyDefinitionSettings(propdef, Optional.of(options), builder);
        builder.add("allowedValues", (JsonValue)this.createAllowedValues(options.getValues()));
        builder.add("value", options.getDefaultValues().stream().map(Stringish::getValue).collect(Collectors.joining(",")));
        return builder.build();
    }

    protected void configureCommonPropertyDefinitionSettings(PropertyDefinition propdef, Optional<? extends PropertyDefinitionOptions> options, JsonObjectBuilder builder) {
        this.configurePropertyDefinitionSettings(propdef, options, builder);
        builder.add("pattern", options.flatMap(PropertyDefinitionOptions::getPattern).map(Stringish::getValue).orElse(""));
    }

    private void configurePropertyDefinitionSettings(PropertyDefinition propdef, Optional<? extends PropertyDefinitionOptions> options, JsonObjectBuilder builder) {
        builder.add("index", this.index++);
        builder.add("name", propdef.getName().getValue());
        builder.add("type", propdef.getJsonKeyword());
        builder.add("inherited", false);
        builder.add("isHidden", false);
        builder.add("required", options.map(PropertyDefinitionOptions::isRequired).orElse(false).booleanValue());
        builder.add("label", options.flatMap(PropertyDefinitionOptions::getLabel).map(Stringish::getValue).orElse(propdef.getName().getValue()));
        builder.add("description", options.flatMap(PropertyDefinitionOptions::getDescription).map(Stringish::getValue).orElse(""));
    }

    protected void configurePropertyExpressionDefinitionSettings(Optional<? extends PropertyExpressionPropertyDefinitionOptions> options, JsonObjectBuilder builder) {
        builder.add("value", options.flatMap(PropertyExpressionPropertyDefinitionOptions::getDefaultValue).map(Stringish::getValue).orElse(""));
    }

    private JsonArray createAllowedValues(List<SelectPropertyValue> values) {
        JsonArrayBuilder builder = Json.createArrayBuilder();
        values.stream().map(this::createSelectPropertyValue).forEach(arg_0 -> ((JsonArrayBuilder)builder).add(arg_0));
        return builder.build();
    }

    protected JsonObject createSelectPropertyValue(SelectPropertyValue selectPropertyValue) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        String value = selectPropertyValue.getValue();
        builder.add("value", value);
        Util.ifPresentOrElse(selectPropertyValue.getLabel(), label -> builder.add("label", label.getValue()), () -> builder.add("label", value));
        return builder.build();
    }
}

