/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.util.processconfiguration;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import ucd.pacc.model.ApplicationProcessConfigurations;
import ucd.pacc.model.ProcessConfigurations;
import ucd.pacc.model.VersionPresets;
import ucd.pacc.util.ErrorHandler;
import ucd.pacc.util.JsonDataFinder;
import ucd.pacc.util.processconfiguration.ProcessConfigurationBuilder;

public class ApplicationProcessConfigurationBuilder
extends ProcessConfigurationBuilder {
    @Override
    ProcessConfigurations build() {
        ApplicationProcessConfigurations processConfigurations = new ApplicationProcessConfigurations();
        this.getInventoryManagementTypeFromJson().ifPresent(processConfigurations::setInvMgmtType);
        this.getOfflineHandling().ifPresent(processConfigurations::setOfflineAgentHandling);
        this.getRequiredRoleNameFromJson().ifPresent(processConfigurations::setRequiredRoleNames);
        processConfigurations.setVersionPresets(this.getVersionPresetsFromJson());
        this.getDisableSnapshotFromJson().ifPresent(processConfigurations::setDisableSnapshots);
        return processConfigurations;
    }

    Optional<ApplicationProcessConfigurations.InventoryManagement> getInventoryManagementTypeFromJson() {
        Optional<Object> data = JsonDataFinder.findDataInJson(this.json, "$.inventoryManagementType");
        return data.map(o -> (String)o).map(String::toUpperCase).filter(ApplicationProcessConfigurationBuilder.isInventoryManagementInputValid()).map(ApplicationProcessConfigurations.InventoryManagement::valueOf);
    }

    Optional<ApplicationProcessConfigurations.OfflineHandling> getOfflineHandling() {
        Optional<Object> data = JsonDataFinder.findDataInJson(this.json, "$.offlineAgentHandling");
        return data.map(o -> (String)o).map(String::toUpperCase).filter(ApplicationProcessConfigurationBuilder.isOfflineHandlingInputValid()).map(ApplicationProcessConfigurations.OfflineHandling::valueOf);
    }

    private static Predicate<String> isOfflineHandlingInputValid() {
        return o -> {
            for (ApplicationProcessConfigurations.OfflineHandling handling : ApplicationProcessConfigurations.OfflineHandling.values()) {
                if (!handling.name().equals(o)) continue;
                return true;
            }
            return false;
        };
    }

    private static Predicate<String> isInventoryManagementInputValid() {
        return o -> {
            for (ApplicationProcessConfigurations.InventoryManagement inventoryManagement : ApplicationProcessConfigurations.InventoryManagement.values()) {
                if (!inventoryManagement.name().equals(o)) continue;
                return true;
            }
            return false;
        };
    }

    Optional<JSONArray> getRequiredRoleNameFromJson() {
        Optional<Object> data = JsonDataFinder.findDataInJson(this.json, "$.requiredRoleNames");
        return data.map(o -> (JSONArray)o);
    }

    Optional<Boolean> getDisableSnapshotFromJson() {
        Optional<Object> data = JsonDataFinder.findDataInJson(this.json, "$.disableSnapshots");
        return data.map(o -> (Boolean)o);
    }

    Optional<VersionPresets> getVersionPresetsFromJson() {
        Optional<Object> data = JsonDataFinder.findDataInJson(this.json, "$.versionPresets");
        if (data.isPresent()) {
            try {
                if (data.get() instanceof List) {
                    return Optional.of(this.getVersionPresetForProcess(new JSONArray((Collection)((List)data.get()))));
                }
                if (data.get() instanceof JSONArray) {
                    JSONArray array = (JSONArray)data.get();
                    if (array.length() > 0) {
                        return Optional.of(this.getVersionPresetForProcess(array));
                    }
                    return Optional.empty();
                }
                String stringData = (String)data.get();
                return Optional.of(this.getVersionPresetForProcess(new JSONArray(stringData)));
            }
            catch (JSONException e) {
                ErrorHandler.printErrorAndExit("Versions preset in Application Process should be a LIST, exiting with error, but is " + data);
            }
        }
        return Optional.empty();
    }

    public VersionPresets getVersionPresetForProcess(JSONArray input) throws JSONException {
        Object versionPresetObj;
        if (input.length() > 1) {
            ErrorHandler.printErrorAndExit("There cannot be more than 1 version Preset configuration for a application process");
        }
        JSONObject versionPresetJson = (versionPresetObj = input.get(0)) instanceof JSONObject ? (JSONObject)versionPresetObj : new JSONObject(String.valueOf(versionPresetObj));
        Object compObj = versionPresetJson.get("component");
        String componentName = compObj instanceof String ? (String)compObj : ((JSONObject)compObj).getString("name");
        String selector_cum_status = (String)versionPresetJson.get("selector");
        return new VersionPresets(componentName, selector_cum_status);
    }
}

