/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.util.processconfiguration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import ucd.pacc.model.GenericProcessConfigurations;
import ucd.pacc.model.GenericProcessProperty;
import ucd.pacc.model.ProcessConfigurations;
import ucd.pacc.model.Team;
import ucd.pacc.model.Webhook;
import ucd.pacc.util.ErrorHandler;
import ucd.pacc.util.JsonDataFinder;
import ucd.pacc.util.processconfiguration.ProcessConfigurationBuilder;
import ucd.pacc.util.processconfiguration.TeamConfigFactory;
import ucd.pacc.util.processconfiguration.WebhookFactory;

public class GenericProcessConfigurationBuilder
extends ProcessConfigurationBuilder {
    @Override
    ProcessConfigurations build() {
        GenericProcessConfigurations processConfigurations = new GenericProcessConfigurations();
        processConfigurations.setProperties(this.getPropertiesFromJson());
        processConfigurations.setTeams(this.getTeamsFromJson());
        processConfigurations.setWebhooks(this.getWebhooksFromJson());
        return processConfigurations;
    }

    List<GenericProcessProperty> getPropertiesFromJson() {
        Optional<Object> data = JsonDataFinder.findDataInJson(this.json, "$.properties");
        boolean isDefaultWorkingDirPresent = false;
        ArrayList<GenericProcessProperty> props = new ArrayList<GenericProcessProperty>();
        if (data.isPresent()) {
            if (data.get() instanceof JSONArray) {
                JSONArray array = (JSONArray)data.get();
                for (int i = 0; i < array.length(); ++i) {
                    JSONObject propJson = JsonDataFinder.getJsonFromJsonArray(array, i);
                    Optional<GenericProcessProperty> property = this.buildProperties(propJson);
                    property.ifPresent(props::add);
                    if (property.get().getName() != GenericProcessProperty.PropertyName.WORKING_DIR) continue;
                    isDefaultWorkingDirPresent = true;
                }
                if (!isDefaultWorkingDirPresent) {
                    ErrorHandler.printErrorAndExit(" DefaultWorkingDirectory is mandatory property configuration property type in generic process ");
                }
                if (props.size() > 2) {
                    ErrorHandler.printErrorAndExit(" DefaultResourceId and workingDirectory are the only allowed configuration property types in generic process ");
                }
            }
            return props;
        }
        return props;
    }

    private Optional<GenericProcessProperty> buildProperties(JSONObject propJson) {
        Optional<Object> name = JsonDataFinder.findDataInJson(propJson.toString(), "$.name");
        if (!name.isPresent()) {
            return Optional.empty();
        }
        Optional<Object> value = JsonDataFinder.findDataInJson(propJson.toString(), "$.value");
        Optional<Object> description = JsonDataFinder.findDataInJson(propJson.toString(), "$.description");
        Optional<Object> secure = JsonDataFinder.findDataInJson(propJson.toString(), "$.secure");
        GenericProcessProperty properties = new GenericProcessProperty();
        name.ifPresent(o -> properties.setName((String)o));
        value.ifPresent(o -> properties.setValue((String)o));
        description.ifPresent(o -> properties.setDescription((String)o));
        secure.ifPresent(o -> properties.setSecure(false));
        return Optional.of(properties);
    }

    Set<Team> getTeamsFromJson() {
        Optional<Object> data = JsonDataFinder.findDataInJson(this.json, "$.teamMappings");
        if (data.isPresent()) {
            if (data.get() instanceof List) {
                return this.generateTeamsFromJsonArray(this.getJsonArrayFromList(data.get()));
            }
            if (data.get() instanceof JSONArray) {
                return this.generateTeamsFromJsonArray((JSONArray)data.get());
            }
        }
        return new HashSet<Team>();
    }

    Set<Webhook> getWebhooksFromJson() {
        Optional<Object> data = JsonDataFinder.findDataInJson(this.json, "$.webhooks");
        if (data.isPresent()) {
            if (data.get() instanceof List) {
                return this.generateWebhooksFromJsonArray(this.getJsonArrayFromList(data.get()));
            }
            if (data.get() instanceof JSONArray) {
                return this.generateWebhooksFromJsonArray((JSONArray)data.get());
            }
            ErrorHandler.printErrorAndExit(" Webhooks should be a JsonArray that is defined as [element1, element2], exiting the process");
        }
        return new HashSet<Webhook>();
    }

    private Set<Webhook> generateWebhooksFromJsonArray(JSONArray webhooksInProcess) {
        HashSet<Webhook> webhooks = new HashSet<Webhook>();
        for (int i = 0; i < webhooksInProcess.length(); ++i) {
            JSONObject webhookJson = (JSONObject)this.getIndexDataFromJson(webhooksInProcess, i);
            Webhook webhook = WebhookFactory.buildWebhookFromJson(webhookJson);
            webhooks.add(webhook);
        }
        return webhooks;
    }

    private Set<Team> generateTeamsFromJsonArray(JSONArray teams) {
        HashSet<Team> teamsInProcess = new HashSet<Team>();
        for (int i = 0; i < teams.length(); ++i) {
            JSONObject teamJson = (JSONObject)this.getIndexDataFromJson(teams, i);
            Team team = TeamConfigFactory.buildFromJson(teamJson);
            teamsInProcess.add(team);
        }
        return teamsInProcess;
    }

    Object getIndexDataFromJson(JSONArray array, int index) {
        try {
            return array.get(index);
        }
        catch (JSONException e) {
            ErrorHandler.printErrorAndExit("Unable to get value at index " + index + " in " + array + " , exiting the process.");
            return null;
        }
    }

    JSONArray getJsonArrayFromList(Object data) {
        try {
            return new JSONArray((Collection)((List)data));
        }
        catch (Exception e) {
            ErrorHandler.printErrorAndExit("Unable to get JSONArray using data " + data);
            return null;
        }
    }
}

