/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.main;

import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.function.Consumer;
import ucd.pacc.main.ConsoleWrapper;
import ucd.pacc.main.Environment;
import ucd.pacc.main.ProgramInfo;
import ucd.pacc.main.SystemProperties;

class GlobalProcessState {
    private final SystemProperties systemProperties;
    private final Environment environment;
    private final InputStream stdin;
    private final PrintStream stdout;
    private final PrintStream stderr;
    private final Optional<ConsoleWrapper> console;
    private final Consumer<Integer> exiter;
    private final String[] arguments;
    private final Path workingDirectory;
    private final ProgramInfo programInfo;

    GlobalProcessState(String[] arguments) {
        this(new SystemProperties(System.getProperties()), new Environment(System.getenv()), System.in, System.out, System.err, Optional.ofNullable(System.console()).map(ConsoleWrapper::new), System::exit, arguments, Optional.ofNullable(GlobalProcessState.class.getPackage().getImplementationVersion()).orElse(System.getProperty("test.pacc.version")), Paths.get(".", new String[0]).toAbsolutePath().normalize());
    }

    GlobalProcessState(SystemProperties systemProperties, Environment environment, InputStream stdin, PrintStream stdout, PrintStream stderr, Optional<ConsoleWrapper> console, Consumer<Integer> exiter, String[] arguments, Path workingDirectory, ProgramInfo programInfo) {
        this.systemProperties = systemProperties;
        this.systemProperties.getClass();
        this.environment = environment;
        this.environment.getClass();
        this.stdin = stdin;
        this.stdin.getClass();
        this.stdout = stdout;
        this.stdout.getClass();
        this.stderr = stderr;
        this.stderr.getClass();
        this.console = console;
        this.console.getClass();
        this.exiter = exiter;
        this.exiter.getClass();
        this.arguments = arguments;
        arguments.getClass();
        this.workingDirectory = workingDirectory;
        this.workingDirectory.getClass();
        this.programInfo = programInfo;
        this.programInfo.getClass();
    }

    private GlobalProcessState(SystemProperties systemProperties, Environment environment, InputStream stdin, PrintStream stdout, PrintStream stderr, Optional<ConsoleWrapper> console, Consumer<Integer> exiter, String[] arguments, String programVersion, Path workingDirectory) {
        this(systemProperties, environment, stdin, stdout, stderr, console, exiter, arguments, workingDirectory, new ProgramInfo(systemProperties.getProgramName(), programVersion, systemProperties.getProgramLocation()));
    }

    public SystemProperties getSystemProperties() {
        return this.systemProperties;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public InputStream getStdin() {
        return this.stdin;
    }

    public PrintStream getStdout() {
        return this.stdout;
    }

    public PrintStream getStderr() {
        return this.stderr;
    }

    public Optional<ConsoleWrapper> getConsole() {
        return this.console;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public Path getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void exit(int status) {
        this.exiter.accept(status);
    }

    public ProgramInfo getProgramInfo() {
        return this.programInfo;
    }
}

