/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.main;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;

public class ServerDataGetter {
    private static ServerDataGetter dataGetter;
    private final String url;
    private final String user;
    private final String password;

    private ServerDataGetter(String user, String password, String url) {
        this.user = user;
        this.password = password;
        this.url = url;
    }

    public static ServerDataGetter getServerDataGetter(String user, String password, String url) {
        if (dataGetter == null) {
            dataGetter = new ServerDataGetter(user, password, url);
        }
        return dataGetter;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getDataFromServer(String path) throws MissingDataException {
        String urlPre1 = this.url + path;
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials(this.user, this.password);
        provider.setCredentials(AuthScope.ANY, (Credentials)creds);
        SSLContextBuilder sslContextBuilder = new SSLContextBuilder();
        try (CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)this.getSslSocketFactory()).setDefaultCredentialsProvider((CredentialsProvider)provider).build();){
            HttpGet httpGet = new HttpGet(urlPre1);
            httpGet.addHeader("Content-Type", "text");
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            if (response.getStatusLine().getStatusCode() == 204) throw new MissingDataException("");
            if (response.getStatusLine().getStatusCode() == 404) {
                throw new MissingDataException("");
            }
            if (response.getStatusLine().getStatusCode() < 210) {
                String string = ServerDataGetter.getResponseBody(response);
                return string;
            }
            throw new RuntimeException(" Unable to get data from server " + response.getStatusLine().getStatusCode());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getResponseBody(CloseableHttpResponse response) {
        try {
            StringBuilder responseBody;
            if (response.getEntity() == null) {
                throw new RuntimeException("Response from the server is null.");
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));){
                String line;
                responseBody = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    responseBody.append(line);
                }
            }
            return responseBody.toString();
        }
        catch (IOException e) {
            System.out.println("Unable to read response body.");
            e.printStackTrace();
            throw new RuntimeException("Unable to read response body CloseableHttpResponse.");
        }
    }

    private SSLConnectionSocketFactory getSslSocketFactory() {
        SSLContextBuilder sslContextBuilder = new SSLContextBuilder();
        try {
            sslContextBuilder.loadTrustMaterial((TrustStrategy)new TrustSelfSignedStrategy());
            return new SSLConnectionSocketFactory(sslContextBuilder.build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    public static ServerDataGetter getDataGetter() {
        return dataGetter;
    }

    public static class MissingDataException
    extends Throwable {
        MissingDataException(String msg) {
            super(msg);
        }
    }
}

