/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.main;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonValue;
import javax.json.spi.JsonProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import ucd.pacc.http.DeployProcessApi;
import ucd.pacc.http.DeployProcessApiFactory;
import ucd.pacc.http.HttpClientFactory;
import ucd.pacc.main.AbstractProcessCommand;
import ucd.pacc.main.BadArgumentException;
import ucd.pacc.main.GlobalProcessState;
import ucd.pacc.main.ProcessDataGetter;
import ucd.pacc.main.ProcessMetaData;
import ucd.pacc.main.ProcessNameToIdConvertor;
import ucd.pacc.main.ProcessType;
import ucd.pacc.main.Processhandler;
import ucd.pacc.main.ScriptInjector;
import ucd.pacc.main.ServerDataGetter;
import ucd.pacc.model.ApplicationProcessConfigurations;
import ucd.pacc.model.ComponentProcessConfigurations;
import ucd.pacc.model.ParseSinkName;
import ucd.pacc.model.ParseSourceName;
import ucd.pacc.model.ProcessConfigurations;
import ucd.pacc.parser.ParseException;
import ucd.pacc.parser.ParseSink;
import ucd.pacc.parser.ReaderParseSource;
import ucd.pacc.upload.Translator;
import ucd.pacc.upload.TranslatorOptions;
import ucd.pacc.upload.UploaderFactory;
import ucd.pacc.upload.UploaderOptions;
import ucd.pacc.util.ErrorHandler;
import ucd.pacc.util.FileTypeConverter;
import ucd.pacc.util.IOFactory;
import ucd.pacc.util.processconfiguration.ApplicationProcessConfigurationBuilder;
import ucd.pacc.util.processconfiguration.ComponentProcessConfigurationBuilder;
import ucd.pacc.util.processconfiguration.GenericProcessConfigurationBuilder;

class UploadProcessCommand
extends AbstractProcessCommand {
    private final UploadMethod uploadMethod;
    private ProcessMetaData processMetaData;
    private ServerDataGetter dataGetter;
    private Optional<Arguments> arguments;

    UploadProcessCommand(GlobalProcessState globalProcessState, IOFactory ioUtil, HttpClientFactory httpClientFactory, DeployProcessApiFactory deployProcessApiFactory, JsonProvider jsonProvider, UploaderFactory uploaderFactory, UploadMethod uploadMethod) {
        super(globalProcessState, ioUtil, httpClientFactory, deployProcessApiFactory, jsonProvider, uploaderFactory);
        this.uploadMethod = uploadMethod;
        this.uploadMethod.getClass();
        this.arguments = Optional.empty();
    }

    @Override
    protected void parseArguments() throws BadArgumentException {
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(this.getGlobalProcessState().getArguments()));
        this.validateArguments(args);
        Optional<String> comment = args.size() == 5 && !((String)args.get(4)).isEmpty() ? Optional.of(args.get(4)) : Optional.empty();
        String user = (String)args.get(0);
        String pwd = (String)args.get(1);
        String url = (String)args.get(2);
        String inputProcessFileName = (String)args.get(3);
        this.processMetaData = new ProcessDataGetter(inputProcessFileName).getProcessMetaData();
        this.dataGetter = ServerDataGetter.getServerDataGetter(user, pwd, url);
        ProcessNameToIdConvertor processNameToIdConvertor = new ProcessNameToIdConvertor(this.processMetaData, this.dataGetter);
        UUID processId = this.parseProcessId(processNameToIdConvertor.getProcessId());
        int processVersion = this.processMetaData.getProcessType() == ProcessType.GENERIC ? processNameToIdConvertor.getProcessVersion() + 1 : -1;
        this.arguments = Optional.of(new Arguments(user, url, processId, processVersion, Paths.get(inputProcessFileName, new String[0]), comment, pwd));
    }

    public void validateArguments(List<String> args) throws BadArgumentException {
        if (args.size() < 4 || args.size() > 5) {
            throw new BadArgumentException(String.format("some arguments may be missing or not required. Usage: %s <user-name> <password> <server-url> inputProcessFile.json/yaml", this.getGlobalProcessState().getProgramInfo().getName()));
        }
        if (!ErrorHandler.isValidUrl(args.get(2))) {
            throw new BadArgumentException(String.format("The Server Url provided is invalid. Please verify the URL", this.getGlobalProcessState().getProgramInfo().getName()));
        }
        if (!ErrorHandler.isValidOperationFileType(args.get(3))) {
            throw new BadArgumentException(String.format("Invalid input file type provided, Please provide any of these: json/yaml/yml", this.getGlobalProcessState().getProgramInfo().getName()));
        }
        if (!Files.exists(Paths.get(args.get(3), new String[0]), new LinkOption[0])) {
            throw new BadArgumentException(String.format("Input file " + args.get(3) + " does not exists. Please verify if the file exists", this.getGlobalProcessState().getProgramInfo().getName()));
        }
    }

    @Override
    protected void doProcessCommand() throws ParseException, IOException, GeneralSecurityException {
        Arguments arguments = this.getArguments().get();
        String password = arguments.getPassword();
        UUID prId = arguments.getProcessId();
        String userInputData = arguments.getInputFile().toString().contains("yml") || arguments.getInputFile().toString().contains("yaml") ? FileTypeConverter.yamlToJson(new String(Files.readAllBytes(arguments.getInputFile()))) : new String(Files.readAllBytes(arguments.getInputFile()));
        ProcessConfigurations processConfigurations = null;
        if (this.getUploadMethod().getClass().getName().contains("GenericProcess")) {
            processConfigurations = new GenericProcessConfigurationBuilder().generateConfigurations(userInputData);
        } else if (this.getUploadMethod().getClass().getName().contains("ComponentProcess")) {
            processConfigurations = new ComponentProcessConfigurationBuilder().generateConfigurations(userInputData);
        } else if (this.getUploadMethod().getClass().getName().contains("ApplicationProcess")) {
            processConfigurations = new ApplicationProcessConfigurationBuilder().generateConfigurations(userInputData);
        }
        JSONObject processJsonWithInjectedScripts = UploadProcessCommand.injectScriptsFromFileInUserJson(userInputData);
        String transformedJson = processJsonWithInjectedScripts.toString();
        StringWriter stringWriter = new StringWriter();
        Translator translator = this.getTranslatorFactory().create(new ReaderParseSource(this.createParseSourceName(), new BufferedReader(new StringReader(transformedJson))), new ParseSink(this.createParseSinkName(), stringWriter), this.getTranslatorOptions());
        translator.translate();
        String translatedJson = stringWriter.toString();
        if (arguments.getProcessId() == null) {
            prId = this.createNewProcess(arguments, translatedJson, password);
        }
        try (CloseableHttpClient httpclient = this.getHttpClientFactory().create(arguments.getUser(), password);
             StringReader stringReader = new StringReader(translatedJson);
             JsonReader jsonReader = this.getJsonProvider().createReader((Reader)stringReader);){
            JsonObject processStepDesign = jsonReader.readObject();
            JsonObject process = this.getProcessAfterAddingConfigurations(processConfigurations, processStepDesign);
            DeployProcessApi api = this.getDeployProcessApiFactory().create(httpclient, arguments.getUrl());
            this.getUploadMethod().upload(api, prId, arguments.getProcessVersion(), process);
        }
    }

    private JsonObject getProcessAfterAddingConfigurations(ProcessConfigurations processConfigurations, JsonObject processStepDesign) {
        JsonObject process;
        JsonObjectBuilder builder = Json.createObjectBuilder();
        if (processConfigurations != null && processConfigurations.toJson().length() > 0) {
            JsonObject processConfigurationsJson = this.getJsonProvider().createReader((Reader)new StringReader(processConfigurations.toJson().toString())).readObject();
            builder.add("name", this.processMetaData.getProcessName());
            if (processConfigurations instanceof ComponentProcessConfigurations) {
                builder.add("component", this.processMetaData.getParentName());
            } else if (processConfigurations instanceof ApplicationProcessConfigurations) {
                builder.add("application", this.processMetaData.getParentName());
            }
            for (String key : processConfigurationsJson.keySet()) {
                builder.add(key, (JsonValue)processConfigurationsJson.get((Object)key));
            }
            builder.add("rootActivity", (JsonValue)processStepDesign);
            process = builder.build();
        } else {
            process = processStepDesign;
        }
        return process;
    }

    private UUID createNewProcess(Arguments arguments, String processedJson, String password) {
        UUID prId;
        try {
            Processhandler Processhandler2 = new Processhandler(arguments.getUrl(), this.getUploadMethod().toString(), processedJson, arguments.getUser(), password);
            prId = this.parseProcessId(Processhandler2.createNewProcessAndGetId());
        }
        catch (BadArgumentException e) {
            throw new RuntimeException(e);
        }
        return prId;
    }

    private static JSONObject injectScriptsFromFileInUserJson(String jsonText1) {
        try {
            JSONObject inputProcessJson = new JSONObject(jsonText1);
            JSONObject processSteps = (JSONObject)inputProcessJson.get("process");
            return new ScriptInjector().injectScriptFilesIntoProcessDesignJson(processSteps);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    protected Optional<Arguments> getArguments() {
        return this.arguments;
    }

    protected UploadMethod getUploadMethod() {
        return this.uploadMethod;
    }

    protected ParseSourceName createParseSourceName() {
        return new ParseSourceName(this.getArguments().get().getInputFile().toString());
    }

    protected ParseSinkName createParseSinkName() {
        Arguments arguments = this.getArguments().get();
        UUID processId = arguments.getProcessId();
        int processVersion = arguments.getProcessVersion();
        return new ParseSinkName(processId + ":" + processVersion);
    }

    protected TranslatorOptions getTranslatorOptions() {
        UploaderOptions options = new UploaderOptions();
        options.setComment(this.getArguments().flatMap(Arguments::getComment));
        options.setPassword(this.getArguments().get().getPassword());
        options.setUsername(this.getArguments().get().getUser());
        options.setUrl(this.getArguments().get().getUrl());
        return options;
    }

    protected static class Arguments {
        private final String user;
        private final String url;
        private final UUID processId;
        private final int processVersion;
        private final Path inputFile;
        private final Optional<String> comment;
        private final String password;

        Arguments(String user, String url, UUID processId, int processVersion, Path inputFile, Optional<String> comment, String password) {
            this.user = user;
            this.user.getClass();
            this.url = url;
            this.url.getClass();
            this.processId = processId;
            this.processId.getClass();
            this.processVersion = processVersion;
            this.inputFile = inputFile;
            this.inputFile.getClass();
            this.comment = comment;
            this.comment.getClass();
            this.password = password;
            this.password.getClass();
        }

        protected String getUser() {
            return this.user;
        }

        protected String getUrl() {
            return this.url;
        }

        protected UUID getProcessId() {
            return this.processId;
        }

        protected int getProcessVersion() {
            return this.processVersion;
        }

        protected Path getInputFile() {
            return this.inputFile;
        }

        protected Optional<String> getComment() {
            return this.comment;
        }

        protected String getPassword() {
            return this.password;
        }
    }

    static interface UploadMethod {
        public void upload(DeployProcessApi var1, UUID var2, int var3, JsonObject var4) throws IOException;
    }
}

