/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.model;

import java.util.List;
import java.util.Optional;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import ucd.pacc.model.ProcessConfigurations;
import ucd.pacc.model.VersionPresets;
import ucd.pacc.util.ErrorHandler;

public class ApplicationProcessConfigurations
extends ProcessConfigurations {
    private InventoryManagement invMgmtType;
    private OfflineHandling agentHandling;
    private boolean disableSnapshots = false;
    private JSONArray requiredRoleNames;
    private VersionPresets versionPresets;

    public Optional<VersionPresets> getVersionPresets() {
        if (this.versionPresets == null) {
            return Optional.empty();
        }
        return Optional.of(this.versionPresets);
    }

    public void setVersionPresets(Optional<VersionPresets> versionPreset) {
        versionPreset.ifPresent(o -> {
            this.versionPresets = o;
        });
    }

    public JSONArray getRequiredRoleNames() {
        return this.requiredRoleNames;
    }

    public void setRequiredRoleNames(JSONArray requiredRoleNames) {
        this.requiredRoleNames = requiredRoleNames;
    }

    public boolean isDisableSnapshots() {
        return this.disableSnapshots;
    }

    public InventoryManagement getInvMgmtType() {
        return this.invMgmtType;
    }

    public OfflineHandling getAgentHandling() {
        return this.agentHandling;
    }

    public void setDisableSnapshots(boolean disableSnapshots) {
        this.disableSnapshots = disableSnapshots;
    }

    public void setInvMgmtType(InventoryManagement type) {
        this.invMgmtType = type;
    }

    public void setOfflineAgentHandling(OfflineHandling handling) {
        this.agentHandling = handling;
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonConfiguration = new JSONObject();
        try {
            if (this.invMgmtType == null) {
                jsonConfiguration.put("inventoryManagementType", (Object)InventoryManagement.AUTOMATIC.toString());
            } else {
                jsonConfiguration.put("inventoryManagementType", (Object)this.invMgmtType.toString());
            }
            if (this.getAgentHandling() == null) {
                jsonConfiguration.put("offlineAgentHandling", (Object)OfflineHandling.PRE_EXECUTION_CHECK);
            } else {
                jsonConfiguration.put("offlineAgentHandling", (Object)this.getAgentHandling().toString());
            }
            if (this.getDescription() != null && !this.getDescription().isEmpty()) {
                jsonConfiguration.put(ProcessConfigurations.DESCRIPTION, (Object)this.getDescription());
            }
            jsonConfiguration.put("disableSnapshots", this.isDisableSnapshots());
            List<JSONObject> propDefs = this.getJsonForPropDefs();
            if (!propDefs.isEmpty()) {
                JSONArray propertyDefs = new JSONArray(propDefs);
                jsonConfiguration.put("propDefs", (Object)propertyDefs);
            }
            if (this.requiredRoleNames != null && this.requiredRoleNames.length() != 0) {
                jsonConfiguration.put("requiredRoleNames", (Object)this.requiredRoleNames);
            }
            if (this.getVersionPresets().isPresent()) {
                jsonConfiguration.put("versionPresets", (Object)this.versionPresets.toJson());
            }
        }
        catch (JSONException e) {
            ErrorHandler.printErrorAndExit("Unable to construct json data for Application Process Configuration ");
        }
        return jsonConfiguration;
    }

    static class ApplicationProcessConfigurationKeywords {
        static final String INVENTORY_MANAGEMENT_TYPE = "inventoryManagementType";
        static final String REQUIRED_ROLE_NAMES = "requiredRoleNames";
        static final String OFFLINE_AGENT_HANDLING = "offlineAgentHandling";
        static final String DISABLE_SNAPSHOTS = "disableSnapshots";
        static final String PROP_DEFS = "propDefs";
        static final String VERSION_PRESETS = "versionPresets";

        ApplicationProcessConfigurationKeywords() {
        }
    }

    public static enum OfflineHandling {
        PRE_EXECUTION_CHECK,
        FAIL_BUT_CONTINUE,
        ALLOW_OFFLINE;

    }

    public static enum InventoryManagement {
        ADVANCED,
        AUTOMATIC;

    }
}

