/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.model;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import ucd.pacc.model.GenericProcessProperty;
import ucd.pacc.model.ProcessConfigurations;
import ucd.pacc.model.Team;
import ucd.pacc.model.Webhook;

public class GenericProcessConfigurations
extends ProcessConfigurations {
    private Set<Team> teams;
    private Set<Webhook> webhooks;
    private List<GenericProcessProperty> properties;

    public List<GenericProcessProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(List<GenericProcessProperty> properties) {
        this.properties = properties;
    }

    public Set<Team> getTeams() {
        return this.teams;
    }

    public void setTeams(Set<Team> teams) {
        this.teams = teams;
    }

    public Set<Webhook> getWebhooks() {
        return this.webhooks;
    }

    public void setWebhooks(Set<Webhook> webhooks) {
        this.webhooks = webhooks;
    }

    @Override
    public JSONObject toJson() {
        JSONObject json = new JSONObject();
        try {
            List teams;
            List webhooks;
            List properties;
            if (this.getProperties() != null && !(properties = this.getProperties().stream().map(GenericProcessProperty::toJson).collect(Collectors.toList())).isEmpty()) {
                JSONArray props = new JSONArray(properties);
                json.put("properties", (Object)props);
            }
            List<JSONObject> propDefs = this.getJsonForPropDefs();
            if (this.getDescription() != null && !this.getDescription().isEmpty()) {
                json.put(ProcessConfigurations.DESCRIPTION, (Object)this.getDescription());
            }
            if (!propDefs.isEmpty()) {
                JSONArray propertyDefs = new JSONArray(propDefs);
                json.put("propDefs", (Object)propertyDefs);
            }
            if (!(webhooks = this.getWebhooks().stream().map(Webhook::toJson).collect(Collectors.toList())).isEmpty()) {
                JSONArray webhook = new JSONArray(webhooks);
                json.put("webhooks", (Object)webhook);
            }
            if (!(teams = this.getTeams().stream().map(Team::toJson).collect(Collectors.toList())).isEmpty()) {
                JSONArray team = new JSONArray(teams);
                json.put("teamMappings", (Object)team);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return json;
    }

    static class GenericProcessConfigKeywords {
        static final String PROCESS_PROPERTIES = "properties";
        static final String PROP_DEFS = "propDefs";
        static final String TEAM_MAPPINGS = "teamMappings";
        static final String WEBHOOKS = "webhooks";

        GenericProcessConfigKeywords() {
        }
    }
}

