/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.model;

import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import ucd.pacc.model.ComponentName;
import ucd.pacc.util.ErrorHandler;

public class VersionPresets {
    private final VersionPresetSelector selectorType;
    private final ComponentName componentName;
    private final String selectorCumStatus;
    private String versionName;
    private String status;

    public VersionPresets(String componentName, String selector_cum_status) {
        this.selectorCumStatus = selector_cum_status;
        this.componentName = new ComponentName(componentName);
        String[] selectorAndStatus = this.selectorCumStatus.split("/");
        String selector = selectorAndStatus[0];
        this.selectorType = VersionPresetSelector.fromCamelCase(selector);
        if (this.selectorType == VersionPresetSelector.SPECIFIC_VERSION) {
            this.setVersionName(selectorAndStatus);
        }
        this.setStatus(selectorAndStatus);
    }

    public VersionPresetSelector getSelectorType() {
        return this.selectorType;
    }

    private void setVersionName(String[] selectorAndStatus) {
        if (selectorAndStatus.length == 1) {
            ErrorHandler.printErrorAndExit(" Version name cannot be empty in Application Process Configuration when version preselector is SPECIFIC_VERSION");
        }
        this.versionName = selectorAndStatus[1];
    }

    private void setStatus(String[] selectorAndStatus) {
        if (this.selectorType != VersionPresetSelector.NONE && this.selectorType != VersionPresetSelector.LATEST_VERSION && this.selectorType != VersionPresetSelector.SPECIFIC_VERSION) {
            if (selectorAndStatus.length == 1) {
                ErrorHandler.printErrorAndExit(" Status cannot be empty in Application Process Configuration when version pre-selector is NOT one of 'NONE', 'LATEST_VERSION', 'SPECIFIC_VERSION'");
            }
            this.status = selectorAndStatus[1];
        }
    }

    public String getVersionName() {
        return this.versionName;
    }

    public String getStatus() {
        return this.status;
    }

    public ComponentName getComponentName() {
        return this.componentName;
    }

    public JSONArray toJson() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("component", (Object)this.getComponentName().getValue());
        json.put("selector", (Object)this.selectorCumStatus);
        return new JSONArray().put((Object)json);
    }

    public static enum VersionPresetSelector {
        LATEST_WITH_STATUS,
        SPECIFIC_VERSION,
        LATEST_VERSION,
        NONE,
        ALL_WITH_STATUS,
        ALL_IN_ENVIRONMENT,
        REVERSE_ALL_IN_ENVIRONMENT;


        public static VersionPresetSelector fromCamelCase(String value) {
            String snakeCase = value.replaceAll("([a-z])([A-Z])", "$1_$2").toUpperCase();
            return VersionPresetSelector.valueOf(snakeCase);
        }
    }
}

