/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.model;

import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import ucd.pacc.util.ErrorHandler;

public class Webhook {
    private String url;
    private String proxyHost;
    private String proxyPort;
    private WebhookTemplate webhookTemplate;

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public WebhookTemplate getWebhookTemplate() {
        return this.webhookTemplate;
    }

    public void setWebhookTemplate(WebhookTemplate webhookTemplate) {
        this.webhookTemplate = webhookTemplate;
    }

    public JSONObject toJson() {
        JSONObject json = new JSONObject();
        try {
            json.put("url", (Object)this.url);
            if (this.proxyHost != null) {
                json.put("proxyHost", (Object)this.proxyHost);
            }
            if (this.proxyPort != null) {
                json.put("proxyPort", (Object)this.proxyPort);
            }
            JSONObject template = new JSONObject();
            template.put("name", (Object)this.webhookTemplate.getName());
            template.put("description", (Object)this.webhookTemplate.getDescription());
            template.put("body", (Object)this.webhookTemplate.getBody());
            template.put("type", (Object)this.webhookTemplate.getType().toString());
            json.put("webhookTemplate", (Object)template);
        }
        catch (JSONException e) {
            ErrorHandler.printErrorAndExit("[ERROR] Unable to build Webhook json for Generic process configuration");
        }
        return json;
    }

    public static class WebhookTemplate {
        private String name;
        private String description;
        private String body;
        private EventType type;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getBody() {
            return this.body;
        }

        public void setBody(String body) {
            this.body = body;
        }

        public EventType getType() {
            return this.type;
        }

        public void setType(EventType type) {
            this.type = type;
        }

        public static enum EventType {
            PROCESS_SUCCESS,
            PROCESS_FAILURE,
            PROCESS_STARTED,
            TASK_CREATED;

        }
    }
}

