/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.upload;

import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonValue;
import ucd.pacc.main.ServerDataGetter;
import ucd.pacc.model.AbstractManualTaskStep;
import ucd.pacc.model.AcquireLockStep;
import ucd.pacc.model.ActionGroup;
import ucd.pacc.model.ActionGroupStep;
import ucd.pacc.model.ActionsOnEvent;
import ucd.pacc.model.AddInventoryStatusStep;
import ucd.pacc.model.AddProcessWarningStep;
import ucd.pacc.model.AppComponentStep;
import ucd.pacc.model.AppMultiComponentInventoryStep;
import ucd.pacc.model.AppRemovalProcessStep;
import ucd.pacc.model.ApplicationRunComponentProcessStep;
import ucd.pacc.model.ChangedComponentResourceListSelection;
import ucd.pacc.model.ChangedComponentResourceTagSelection;
import ucd.pacc.model.ComponentRunComponentProcessStep;
import ucd.pacc.model.DeployingUserTaskApprovalRestriction;
import ucd.pacc.model.FinishStep;
import ucd.pacc.model.ForEachAgentStep;
import ucd.pacc.model.ForEachResourceTagStep;
import ucd.pacc.model.GenericManualTaskStep;
import ucd.pacc.model.IdentityBasedTaskApprovalRestriction;
import ucd.pacc.model.InventoryStep;
import ucd.pacc.model.JoinStep;
import ucd.pacc.model.JsonSpecialActivityStep;
import ucd.pacc.model.PluginStep;
import ucd.pacc.model.Property;
import ucd.pacc.model.PropertyContainer;
import ucd.pacc.model.PropertyDefinition;
import ucd.pacc.model.ReleaseLockStep;
import ucd.pacc.model.RemoveInventoryStatusStep;
import ucd.pacc.model.ResourceTagName;
import ucd.pacc.model.RoleBasedTaskApprovalRestriction;
import ucd.pacc.model.RoleRestriction;
import ucd.pacc.model.RunGenericProcessForEachAffectedResourceStep;
import ucd.pacc.model.RunGenericProcessStep;
import ucd.pacc.model.RunOnFirstOnlineResourceOnlyStep;
import ucd.pacc.model.RunOperationalProcessForMultipleComponentsStep;
import ucd.pacc.model.SetFinalProcessStatusStep;
import ucd.pacc.model.StartStep;
import ucd.pacc.model.Step;
import ucd.pacc.model.StepAction;
import ucd.pacc.model.StepGraph;
import ucd.pacc.model.StepGraphContainer;
import ucd.pacc.model.StepName;
import ucd.pacc.model.Stringish;
import ucd.pacc.model.SwitchStep;
import ucd.pacc.model.TaskApprovalRestriction;
import ucd.pacc.parser.ParseException;
import ucd.pacc.upload.PropertyDefinitionToJsonBuilder;
import ucd.pacc.util.ErrorHandler;
import ucd.pacc.util.StepGraphProcessor;

public class GraphJsonBuilder
extends StepGraphProcessor<GraphJsonBuilder> {
    private StepGraph rootGraph;
    private JsonObjectBuilder graphBuilder;
    private JsonObject json;
    private boolean visitedRootStepList;
    private Optional<String> comment = Optional.empty();
    private JsonArray componentTags = null;

    public JsonObject getJson() {
        this.checkExecuted();
        return this.getJsonInternal();
    }

    public void setComment(Optional<String> comment) {
        comment.getClass();
        this.comment = comment;
    }

    protected JsonObject getJsonInternal() {
        return this.json;
    }

    @Override
    protected GraphJsonBuilder createNestedInstance() {
        return new GraphJsonBuilder();
    }

    @Override
    protected void processStep(Step step) {
    }

    @Override
    protected void processStepGraphStart(StepGraph graph) throws ParseException {
        graph.getClass();
        if (!this.visitedRootStepList) {
            this.visitedRootStepList = true;
            this.rootGraph = graph;
            this.json = null;
            this.graphBuilder = Json.createObjectBuilder();
            this.graphBuilder.add("type", "graph");
            this.graphBuilder.add("layoutMode", "auto");
            this.graphBuilder.add("creator", this.getCreator());
            this.comment.ifPresent(c -> this.graphBuilder.add("comment", c));
            ChildrenBuilder childrenBuilder = new ChildrenBuilder();
            childrenBuilder.process(graph);
            childrenBuilder.attachChildren();
            EdgeBuilder edgeBuilder = new EdgeBuilder();
            edgeBuilder.process(graph);
            edgeBuilder.attachEdges();
            OffsetBuilder offsetBuilder = new OffsetBuilder();
            offsetBuilder.process(graph);
            offsetBuilder.attachOffsets();
            this.json = this.graphBuilder.build();
        }
    }

    private String getCreator() {
        return "pacc-" + this.getClass().getPackage().getImplementationVersion();
    }

    private String resolveTarget(StepName name) {
        Map<StepName, Step> stepByNameMap = this.rootGraph.getStepByNameMap().get();
        Step step = stepByNameMap.get(name);
        if (step == null) {
            throw new RuntimeException("no such step: name=" + name.quote());
        }
        return step.getAnchor().getValue();
    }

    private class OffsetBuilder
    extends StepGraphProcessor<GraphJsonBuilder> {
        private final int height;
        private final int width;
        private int x;
        private int y;
        private JsonArrayBuilder builder = Json.createArrayBuilder();

        OffsetBuilder() {
            this.height = 80;
            this.width = 120;
        }

        @Override
        protected GraphJsonBuilder createNestedInstance() {
            throw new RuntimeException("unused");
        }

        @Override
        protected void processStepAsStepGraphContainer(StepGraphContainer container) {
        }

        @Override
        protected void processStep(Step step) {
            if (step instanceof StartStep) {
                return;
            }
            String anchor = step.getAnchor().getValue();
            JsonObjectBuilder builder = Json.createObjectBuilder();
            builder.add("name", anchor);
            builder.add("x", this.x);
            builder.add("y", this.y);
            builder.add("h", this.height);
            builder.add("w", this.width);
            this.x += this.width;
            this.y += this.height;
            this.builder.add((JsonValue)builder.build());
        }

        void attachOffsets() {
            GraphJsonBuilder.this.graphBuilder.add("offsets", (JsonValue)this.builder.build());
        }
    }

    private class EdgeBuilder
    extends StepGraphProcessor<GraphJsonBuilder> {
        private JsonArrayBuilder builder = Json.createArrayBuilder();

        EdgeBuilder() {
        }

        @Override
        protected GraphJsonBuilder createNestedInstance() {
            throw new RuntimeException("unused");
        }

        @Override
        protected void processStepAsStepGraphContainer(StepGraphContainer container) {
        }

        @Override
        protected void processStep(Step step) {
            if (step instanceof ActionGroupStep) {
                this.processActionGroupStep((ActionGroupStep)step);
            } else if (step instanceof SwitchStep) {
                this.processSwitchStep((SwitchStep)step);
            } else if (step instanceof JoinStep) {
                this.processJoinStep((JoinStep)step);
            } else if (step instanceof StartStep) {
                this.processStartStep((StartStep)step);
            } else if (step instanceof FinishStep) {
                this.processFinishStep((FinishStep)step);
            } else {
                throw new RuntimeException("unimplemented step: " + step.getClass().getName());
            }
        }

        protected void processActionGroupStep(ActionGroupStep step) {
            String from = step.getAnchor().getValue();
            Consumer<ActionsOnEvent> eventEdgeBuilder = event -> event.getActions().forEach(action -> {
                JsonObjectBuilder b = Json.createObjectBuilder();
                b.add("from", from);
                b.add("to", GraphJsonBuilder.this.resolveTarget(action.getTarget()));
                b.add("type", event.getEvent().getJsonKeyword());
                this.builder.add((JsonValue)b.build());
            });
            ActionGroup actionGroup = step.getActionGroup();
            actionGroup.getActionsOnSuccess().ifPresent(eventEdgeBuilder);
            actionGroup.getActionsOnFailure().ifPresent(eventEdgeBuilder);
            actionGroup.getActionsOnComplete().ifPresent(eventEdgeBuilder);
        }

        protected void processSwitchStep(SwitchStep step) {
            String from = step.getAnchor().getValue();
            Consumer<SwitchStep.SwitchStepCase> caseEdgeBuilder = kase -> {
                for (StepAction action : kase.getActions()) {
                    JsonObjectBuilder b = Json.createObjectBuilder();
                    b.add("from", from);
                    b.add("to", GraphJsonBuilder.this.resolveTarget(action.getTarget()));
                    b.add("type", "VALUE");
                    if (kase instanceof SwitchStep.SwitchStepMatchCase) {
                        b.add("value", ((SwitchStep.SwitchStepMatchCase)kase).getMatch().getValue());
                    }
                    this.builder.add((JsonValue)b.build());
                }
            };
            step.getMatchCases().forEach(caseEdgeBuilder);
            step.getDefaultCase().ifPresent(caseEdgeBuilder);
        }

        protected void processJoinStep(JoinStep step) {
            String from = step.getAnchor().getValue();
            step.getActions().forEach(action -> {
                JsonObjectBuilder b = Json.createObjectBuilder();
                b.add("from", from);
                b.add("to", GraphJsonBuilder.this.resolveTarget(action.getTarget()));
                b.add("type", ActionsOnEvent.Event.SUCCESS.getJsonKeyword());
                this.builder.add((JsonValue)b.build());
            });
        }

        protected void processFinishStep(FinishStep step) {
        }

        protected void processStartStep(StartStep step) {
            step.getActions().forEach(action -> {
                JsonObjectBuilder b = Json.createObjectBuilder();
                b.add("to", GraphJsonBuilder.this.resolveTarget(action.getTarget()));
                b.add("type", ActionsOnEvent.Event.COMPLETE.getJsonKeyword());
                this.builder.add((JsonValue)b.build());
            });
        }

        void attachEdges() {
            GraphJsonBuilder.this.graphBuilder.add("edges", (JsonValue)this.builder.build());
        }
    }

    private class ChildrenBuilder
    extends StepGraphProcessor<GraphJsonBuilder> {
        private JsonArrayBuilder childrenBuilder = Json.createArrayBuilder();
        private JsonObjectBuilder stepBuilder;

        ChildrenBuilder() {
        }

        @Override
        protected GraphJsonBuilder createNestedInstance() {
            return GraphJsonBuilder.this.createNestedInstance();
        }

        @Override
        protected void processStepStart(Step step) {
            this.stepBuilder = Json.createObjectBuilder();
        }

        @Override
        protected void processStep(Step step) {
            if (step instanceof ForEachResourceTagStep) {
                this.processForEachResourceTagStep((ForEachResourceTagStep)step);
            } else if (step instanceof ForEachAgentStep) {
                this.processForEachAgentStep((ForEachAgentStep)step);
            } else if (step instanceof PluginStep) {
                this.processPluginStep((PluginStep)step);
            } else if (step instanceof AcquireLockStep) {
                this.processAcquireLockStep((AcquireLockStep)step);
            } else if (step instanceof ReleaseLockStep) {
                this.processReleaseLockStep((ReleaseLockStep)step);
            } else if (step instanceof SetFinalProcessStatusStep) {
                this.processSetFinalStatusStep((SetFinalProcessStatusStep)step);
            } else if (step instanceof AddInventoryStatusStep) {
                this.processAddInventoryStatusStep((AddInventoryStatusStep)step);
            } else if (step instanceof RemoveInventoryStatusStep) {
                this.processRemoveInventoryStatusStep((RemoveInventoryStatusStep)step);
            } else if (step instanceof AddProcessWarningStep) {
                this.processAddProcessWarningStep((AddProcessWarningStep)step);
            } else if (step instanceof GenericManualTaskStep) {
                this.processGenericManualTaskStep((GenericManualTaskStep)step);
            } else if (step instanceof AbstractManualTaskStep) {
                this.processAbstractManualTaskStep((AbstractManualTaskStep)step);
            } else if (step instanceof RunGenericProcessStep) {
                this.processRunGenericProcessStep((RunGenericProcessStep)step);
            } else if (step instanceof ApplicationRunComponentProcessStep) {
                this.processApplicationRunComponentProcessStep((ApplicationRunComponentProcessStep)step);
            } else if (step instanceof RunOperationalProcessForMultipleComponentsStep) {
                this.processRunOperationalProcessForMultipleComponentsStep((RunOperationalProcessForMultipleComponentsStep)step);
            } else if (step instanceof RunGenericProcessForEachAffectedResourceStep) {
                this.processRunGenericProcessForEachAffectedResourceStep((RunGenericProcessForEachAffectedResourceStep)step);
            } else if (step instanceof SwitchStep) {
                this.processSwitchStep((SwitchStep)step);
            } else if (step instanceof JoinStep) {
                this.processJoinStep((JoinStep)step);
            } else if (step instanceof FinishStep) {
                this.processFinishStep((FinishStep)step);
            } else if (step instanceof StartStep) {
                this.processStartStep((StartStep)step);
            } else if (step instanceof AppComponentStep) {
                this.processAppComponentStep((AppComponentStep)step);
            } else if (step instanceof AppMultiComponentInventoryStep) {
                this.processAppMultiComponentInventoryStep((AppMultiComponentInventoryStep)step);
            } else if (step instanceof ComponentRunComponentProcessStep) {
                this.processComponentRunComponentProcessStep((ComponentRunComponentProcessStep)step);
            } else {
                throw new RuntimeException("unimplemented step: " + step.getClass().getName());
            }
        }

        @Override
        protected void processStepEnd(Step step) {
            if (!(step instanceof StartStep)) {
                this.childrenBuilder.add((JsonValue)this.stepBuilder.build());
            }
            this.stepBuilder = null;
        }

        @Override
        protected void processStepGraphContainerEnd(GraphJsonBuilder nestedInstance, StepGraphContainer container) {
            JsonArrayBuilder nestedChildrenBuilder = Json.createArrayBuilder();
            nestedChildrenBuilder.add((JsonValue)nestedInstance.getJsonInternal());
            this.stepBuilder.add("children", (JsonValue)nestedChildrenBuilder.build());
        }

        protected void processForEachResourceTagStep(ForEachResourceTagStep step) {
            this.stepBuilder.add("type", "eachTagIterator");
            this.stepBuilder.add("name", step.getName().getValue());
            JsonArrayBuilder tagsBuilder = Json.createArrayBuilder();
            for (ResourceTagName tag : step.getTags()) {
                JsonObjectBuilder tagBuilder = Json.createObjectBuilder();
                tagBuilder.add("id", tag.getValue());
                tagsBuilder.add((JsonValue)tagBuilder.build());
            }
            this.stepBuilder.add("tags", (JsonValue)tagsBuilder.build());
            this.stepBuilder.add("maxIteration", String.valueOf(step.getMaxConcurrentTags().getValue()));
        }

        protected void processForEachAgentStep(ForEachAgentStep step) {
            this.stepBuilder.add("type", "eachAgentIterator");
            this.stepBuilder.add("name", step.getName().getValue());
            JsonArrayBuilder tagIdsBuilder = Json.createArrayBuilder();
            for (ResourceTagName tag : step.getTags()) {
                tagIdsBuilder.add(tag.getValue());
            }
            this.stepBuilder.add("tagIds", (JsonValue)tagIdsBuilder.build());
            this.stepBuilder.add("maxIteration", String.valueOf(step.getMaxConcurrentAgents().getValue()));
        }

        protected void processAppComponentStep(AppComponentStep step) {
            String stepName = step.getName().getValue();
            String anchorPrefix = step.getJsonNamePrefix() + "-" + stepName;
            String anchor = anchorPrefix + "-1-" + UUID.randomUUID();
            step.setAnchor(new StepName(anchor));
            JsonObjectBuilder ceiBuilder = this.stepBuilder;
            ceiBuilder.add("type", "componentEnvironmentIterator");
            ceiBuilder.add("name", anchor);
            ceiBuilder.add("failFast", step.isFailFast());
            ceiBuilder.add("maxIteration", String.valueOf(step.getMaxConcurrentProcesses().getValue()));
            step.getPreconditionScript().ifPresent(script -> ceiBuilder.add("preconditionScript", script.getValue()));
            step.getByResourceTag().ifPresent(tag -> ceiBuilder.add("tagId", tag.getValue()));
            if (step instanceof RunOnFirstOnlineResourceOnlyStep) {
                RunOnFirstOnlineResourceOnlyStep firstOnlineStep = (RunOnFirstOnlineResourceOnlyStep)((Object)step);
                ceiBuilder.add("runOnlyOnFirst", firstOnlineStep.isRunOnFirstOnlineResourceOnly());
            }
            JsonObjectBuilder cpBuilder = Json.createObjectBuilder();
            cpBuilder.add("type", "componentProcess");
            cpBuilder.add("name", stepName);
            cpBuilder.add("componentProcessName", step.getProcess().getValue());
            cpBuilder.add("properties", (JsonValue)this.createProperties(step));
            String componentName = step.getComponent().getValue();
            ceiBuilder.add("componentName", componentName);
            cpBuilder.add("componentName", componentName);
            boolean isIgnoreChildWarnings = step.isIgnoreChildWarnings();
            ceiBuilder.add("isIgnoreChildWarnings", isIgnoreChildWarnings);
            cpBuilder.add("isIgnoreChildWarnings", isIgnoreChildWarnings);
            if (step instanceof JsonSpecialActivityStep) {
                JsonSpecialActivityStep specialStep = (JsonSpecialActivityStep)((Object)step);
                JsonObjectBuilder saBuilder = Json.createObjectBuilder();
                saBuilder.add("type", specialStep.getJsonSpecialActivityKeyword());
                saBuilder.add("name", anchorPrefix + "-2-" + stepName + "-" + UUID.randomUUID());
                saBuilder.add("isIgnoreChildWarnings", isIgnoreChildWarnings);
                if (specialStep.isComponentRequired()) {
                    saBuilder.add("componentName", componentName);
                }
                if (specialStep instanceof InventoryStep) {
                    InventoryStep inventoryStep = (InventoryStep)specialStep;
                    saBuilder.add("status", inventoryStep.getTargetInventoryStatus().getValue());
                }
                if (specialStep instanceof AppRemovalProcessStep) {
                    AppRemovalProcessStep removalStep = (AppRemovalProcessStep)specialStep;
                    saBuilder.add("selectionType", removalStep.getRemovalType().getJsonKeyword());
                }
                saBuilder.add("children", (JsonValue)Json.createArrayBuilder().add((JsonValue)cpBuilder.build()).build());
                ceiBuilder.add("children", (JsonValue)Json.createArrayBuilder().add((JsonValue)saBuilder.build()).build());
            } else {
                ceiBuilder.add("children", (JsonValue)Json.createArrayBuilder().add((JsonValue)cpBuilder.build()).build());
            }
        }

        protected void processAppMultiComponentInventoryStep(AppMultiComponentInventoryStep step) {
            String stepName = step.getName().getValue();
            String anchorPrefix = step.getJsonNamePrefix() + "-" + stepName;
            String anchor = anchorPrefix + "-1-" + UUID.randomUUID();
            step.setAnchor(new StepName(anchor));
            JsonObjectBuilder mceiBuilder = this.stepBuilder;
            mceiBuilder.add("type", "multiComponentEnvironmentIterator");
            mceiBuilder.add("name", anchor);
            mceiBuilder.add("failFast", step.isFailFast());
            mceiBuilder.add("maxIteration", String.valueOf(step.getMaxConcurrentProcesses().getValue()));
            mceiBuilder.add("maxCompIteration", String.valueOf(step.getMaxConcurrentComponents().getValue()));
            step.getPreconditionScript().ifPresent(script -> mceiBuilder.add("preconditionScript", script.getValue()));
            step.getByComponentTag().ifPresent(tag -> mceiBuilder.add("componentTagId", tag.getValue()));
            step.getByComponentTag().ifPresent(tag -> mceiBuilder.add("componentTag", (JsonValue)this.getComponentTagSubJson(tag.getValue())));
            JsonObjectBuilder ceiBuilder = Json.createObjectBuilder();
            ceiBuilder.add("type", "componentEnvironmentIterator");
            ceiBuilder.add("name", anchorPrefix + "-2-" + UUID.randomUUID());
            step.getByResourceTag().ifPresent(tag -> ceiBuilder.add("tagId", tag.getValue()));
            JsonObjectBuilder viBuilder = Json.createObjectBuilder();
            viBuilder.add("type", step.getJsonSpecialActivityKeyword());
            viBuilder.add("name", anchorPrefix + "-3-" + UUID.randomUUID());
            viBuilder.add("status", step.getTargetInventoryStatus().getValue());
            if (step instanceof AppRemovalProcessStep) {
                AppRemovalProcessStep removalStep = (AppRemovalProcessStep)((Object)step);
                viBuilder.add("selectionType", removalStep.getRemovalType().getJsonKeyword());
            }
            JsonObjectBuilder cpBuilder = Json.createObjectBuilder();
            cpBuilder.add("type", "componentProcess");
            cpBuilder.add("name", stepName);
            cpBuilder.add("properties", (JsonValue)Json.createObjectBuilder().build());
            String componentProcessName = step.getProcess().getValue();
            cpBuilder.add("componentProcessName", componentProcessName);
            mceiBuilder.add("componentProcessName", componentProcessName);
            boolean isIgnoreChildWarnings = step.isIgnoreChildWarnings();
            mceiBuilder.add("isIgnoreChildWarnings", isIgnoreChildWarnings);
            ceiBuilder.add("isIgnoreChildWarnings", isIgnoreChildWarnings);
            viBuilder.add("isIgnoreChildWarnings", isIgnoreChildWarnings);
            cpBuilder.add("isIgnoreChildWarnings", isIgnoreChildWarnings);
            viBuilder.add("children", (JsonValue)Json.createArrayBuilder().add((JsonValue)cpBuilder.build()).build());
            ceiBuilder.add("children", (JsonValue)Json.createArrayBuilder().add((JsonValue)viBuilder.build()).build());
            mceiBuilder.add("children", (JsonValue)Json.createArrayBuilder().add((JsonValue)ceiBuilder.build()).build());
        }

        protected void processPluginStep(PluginStep step) {
            this.stepBuilder.add("type", "plugin");
            this.stepBuilder.add("name", step.getName().getValue());
            this.stepBuilder.add("commandName", step.getCommand().getValue());
            this.stepBuilder.add("pluginName", step.getPlugin().getValue());
            this.stepBuilder.add("useImpersonation", false);
            this.stepBuilder.add("impersonationGroup", "");
            this.stepBuilder.add("impersonationPassword", "");
            this.stepBuilder.add("impersonationUseSudo", false);
            step.getWorkingDirectory().ifPresent(w -> this.stepBuilder.add("workingDir", w.getValue()));
            step.getPreconditionScript().ifPresent(p -> this.stepBuilder.add("preconditionScript", p.getValue()));
            if (!step.getPostProcessingProperty().isEmpty()) {
                this.stepBuilder.add("postProcessingScript", (JsonValue)this.createPostProcessingProperties(step));
            }
            this.stepBuilder.add("authTokenRestriction", "20000001-0001-0001-0001-000000000000");
            this.stepBuilder.add("properties", (JsonValue)this.createProperties(step));
        }

        protected void processAcquireLockStep(AcquireLockStep step) {
            this.stepBuilder.add("type", "acquireLock");
            this.stepBuilder.add("name", step.getName().getValue());
            this.stepBuilder.add("lockName", step.getLock().getValue());
        }

        protected void processReleaseLockStep(ReleaseLockStep step) {
            this.stepBuilder.add("type", "releaseLock");
            this.stepBuilder.add("name", step.getName().getValue());
            this.stepBuilder.add("lockName", step.getLock().getValue());
        }

        protected void processAddInventoryStatusStep(AddInventoryStatusStep step) {
            this.stepBuilder.add("type", "addResourceInventory");
            this.stepBuilder.add("name", step.getName().getValue());
            this.stepBuilder.add("status", step.getStatus().getValue());
        }

        protected void processRemoveInventoryStatusStep(RemoveInventoryStatusStep step) {
            this.stepBuilder.add("type", "removeResourceInventory");
            this.stepBuilder.add("name", step.getName().getValue());
            this.stepBuilder.add("status", step.getStatus().getValue());
        }

        protected void processSwitchStep(SwitchStep step) {
            this.stepBuilder.add("type", "switch");
            this.stepBuilder.add("name", step.getName().getValue());
            this.stepBuilder.add("propertyName", step.getExpression().getValue());
        }

        protected void processJoinStep(JoinStep step) {
            this.stepBuilder.add("type", "join");
            this.stepBuilder.add("name", step.getName().getValue());
        }

        protected void processSetFinalStatusStep(SetFinalProcessStatusStep step) {
            this.stepBuilder.add("type", "setStatus");
            this.stepBuilder.add("name", step.getName().getValue());
            this.stepBuilder.add("status", step.getStatus().getJsonKeyword());
        }

        protected void processAddProcessWarningStep(AddProcessWarningStep step) {
            this.stepBuilder.add("type", "addWarning");
            this.stepBuilder.add("name", step.getName().getValue());
            this.stepBuilder.add("warningMessage", step.getWarning().getValue());
        }

        protected void processRunGenericProcessStep(RunGenericProcessStep step) {
            this.stepBuilder.add("type", "runProcess");
            this.stepBuilder.add("name", step.getName().getValue());
            this.stepBuilder.add("processName", step.getProcess().getValue());
            this.stepBuilder.add("resourcePath", step.getResourcePath().map(Stringish::getValue).orElse(""));
            this.stepBuilder.add("isIgnoreChildWarnings", step.isIgnoreChildWarnings());
            this.stepBuilder.add("properties", (JsonValue)this.createProperties(step));
        }

        protected void processApplicationRunComponentProcessStep(ApplicationRunComponentProcessStep step) {
            JsonObjectBuilder cpContainerBuilder = this.stepBuilder;
            JsonObjectBuilder cpBuilder = Json.createObjectBuilder();
            String stepName = step.getName().getValue();
            String anchor = step.getJsonNamePrefix() + "-" + stepName + "-" + UUID.randomUUID();
            step.setAnchor(new StepName(anchor));
            if (step.getByChangedComponent().isPresent()) {
                ChangedComponentResourceListSelection byChangedComponent = step.getByChangedComponent().get();
                cpContainerBuilder.add("type", "changedResourceIterator");
                cpContainerBuilder.add("resourceSelectionMode", byChangedComponent.getMode().getJsonKeyword());
                JsonArrayBuilder cidListBuilder = Json.createArrayBuilder();
                byChangedComponent.getComponents().stream().map(Stringish::getValue).forEach(arg_0 -> ((JsonArrayBuilder)cidListBuilder).add(arg_0));
                cpContainerBuilder.add("componentIds", (JsonValue)cidListBuilder.build());
            } else {
                cpContainerBuilder.add("type", "componentEnvironmentIterator");
            }
            cpContainerBuilder.add("name", anchor);
            cpContainerBuilder.add("runOnlyOnFirst", step.isRunOnFirstOnlineResourceOnly());
            cpContainerBuilder.add("failFast", step.isFailFast());
            cpContainerBuilder.add("maxIteration", String.valueOf(step.getMaxConcurrentProcesses().getValue()));
            step.getPreconditionScript().ifPresent(script -> cpContainerBuilder.add("preconditionScript", script.getValue()));
            step.getByResourceTag().ifPresent(tag -> cpContainerBuilder.add("tagId", tag.getValue()));
            boolean isIgnoreChildWarnings = step.isIgnoreChildWarnings();
            cpContainerBuilder.add("isIgnoreChildWarnings", isIgnoreChildWarnings);
            cpBuilder.add("isIgnoreChildWarnings", isIgnoreChildWarnings);
            String component = step.getComponent().getValue();
            cpContainerBuilder.add("componentName", component);
            cpBuilder.add("componentName", component);
            cpBuilder.add("type", "componentProcess");
            cpBuilder.add("name", step.getName().getValue());
            cpBuilder.add("componentProcessName", step.getProcess().getValue());
            cpBuilder.add("allowFailure", false);
            cpBuilder.add("properties", (JsonValue)this.createProperties(step));
            cpContainerBuilder.add("children", (JsonValue)Json.createArrayBuilder().add((JsonValue)cpBuilder.build()).build());
        }

        protected void processComponentRunComponentProcessStep(ComponentRunComponentProcessStep step) {
            this.stepBuilder.add("type", "componentProcess");
            this.stepBuilder.add("name", step.getName().getValue());
            this.stepBuilder.add("componentProcessName", step.getProcess().getValue());
            this.stepBuilder.add("properties", (JsonValue)this.createProperties(step));
        }

        protected void processRunOperationalProcessForMultipleComponentsStep(RunOperationalProcessForMultipleComponentsStep step) {
            String stepName = step.getName().getValue();
            String anchorPrefix = step.getJsonNamePrefix() + "-" + stepName;
            String anchor = anchorPrefix + "-1-" + UUID.randomUUID();
            step.setAnchor(new StepName(anchor));
            JsonObjectBuilder mceiBuilder = this.stepBuilder;
            JsonObjectBuilder opfContainerBuilder = Json.createObjectBuilder();
            JsonObjectBuilder opfBuilder = Json.createObjectBuilder();
            JsonObjectBuilder cpBuilder = Json.createObjectBuilder();
            mceiBuilder.add("type", "multiComponentEnvironmentIterator");
            mceiBuilder.add("name", anchor);
            mceiBuilder.add("failFast", step.isFailFast());
            mceiBuilder.add("maxIteration", String.valueOf(step.getMaxConcurrentProcesses().getValue()));
            mceiBuilder.add("maxCompIteration", String.valueOf(step.getMaxConcurrentComponents().getValue()));
            step.getPreconditionScript().ifPresent(script -> mceiBuilder.add("preconditionScript", script.getValue()));
            step.getByComponentTag().ifPresent(tag -> mceiBuilder.add("componentTagId", tag.getValue()));
            step.getByComponentTag().ifPresent(tag -> mceiBuilder.add("componentTag", (JsonValue)this.getComponentTagSubJson(tag.getValue())));
            opfContainerBuilder.add("name", anchorPrefix + "-2-" + UUID.randomUUID());
            if (step.getByChangedComponent().isPresent()) {
                ChangedComponentResourceTagSelection byChangedComponent = step.getByChangedComponent().get();
                opfContainerBuilder.add("type", "changedResourceIterator");
                opfContainerBuilder.add("resourceSelectionMode", byChangedComponent.getMode().getJsonKeyword());
                byChangedComponent.getByComponentTag().ifPresent(tag -> opfContainerBuilder.add("monitorTag", tag.getValue()));
            } else {
                opfContainerBuilder.add("type", "componentEnvironmentIterator");
                opfContainerBuilder.add("failFast", false);
            }
            step.getByResourceTag().ifPresent(tag -> opfContainerBuilder.add("tagId", tag.getValue()));
            opfBuilder.add("name", anchorPrefix + "-3-" + UUID.randomUUID());
            opfBuilder.add("type", "operationalProcessFilter");
            cpBuilder.add("type", "componentProcess");
            cpBuilder.add("name", step.getName().getValue());
            cpBuilder.add("allowFailure", false);
            String process = step.getProcess().getValue();
            mceiBuilder.add("componentProcessName", process);
            cpBuilder.add("componentProcessName", process);
            boolean isIgnoreChildWarnings = step.isIgnoreChildWarnings();
            mceiBuilder.add("isIgnoreChildWarnings", isIgnoreChildWarnings);
            if (!step.getByChangedComponent().isPresent()) {
                opfContainerBuilder.add("isIgnoreChildWarnings", isIgnoreChildWarnings);
            }
            cpBuilder.add("isIgnoreChildWarnings", isIgnoreChildWarnings);
            boolean runOnFirstOnlineResourceOnly = step.isRunOnFirstOnlineResourceOnly();
            mceiBuilder.add("runOnlyOnFirst", runOnFirstOnlineResourceOnly);
            opfContainerBuilder.add("runOnlyOnFirst", runOnFirstOnlineResourceOnly);
            opfBuilder.add("children", (JsonValue)Json.createArrayBuilder().add((JsonValue)cpBuilder.build()).build());
            opfContainerBuilder.add("children", (JsonValue)Json.createArrayBuilder().add((JsonValue)opfBuilder.build()).build());
            mceiBuilder.add("children", (JsonValue)Json.createArrayBuilder().add((JsonValue)opfContainerBuilder.build()).build());
        }

        private JsonObject getComponentTagSubJson(String tagId) {
            JsonObjectBuilder componentTagJson = Json.createObjectBuilder();
            try {
                JsonArray componentTags = this.getTagInfoFromServer();
                for (int i = 0; i < componentTags.size(); ++i) {
                    JsonObject tagJson = componentTags.getJsonObject(i);
                    if (!tagJson.getString("id").equals(tagId)) continue;
                    componentTagJson.add("name", tagJson.getString("name"));
                    componentTagJson.add("color", tagJson.getString("color"));
                    componentTagJson.add("description", tagJson.getString("description"));
                    componentTagJson.add("objectType", tagJson.getString("objectType"));
                }
            }
            catch (ServerDataGetter.MissingDataException e) {
                ErrorHandler.printErrorAndExit("Unable to extract component tag information during upload processing");
            }
            return componentTagJson.build();
        }

        private JsonArray getTagInfoFromServer() throws ServerDataGetter.MissingDataException {
            if (GraphJsonBuilder.this.componentTags == null) {
                ServerDataGetter dataGetter = ServerDataGetter.getDataGetter();
                String serverData = dataGetter.getDataFromServer("/cli/tags?objectType=Component");
                JsonReader jsonReader = Json.createReader((Reader)new StringReader(serverData));
                GraphJsonBuilder.this.componentTags = jsonReader.readArray();
            }
            return GraphJsonBuilder.this.componentTags;
        }

        protected void processRunGenericProcessForEachAffectedResourceStep(RunGenericProcessForEachAffectedResourceStep step) {
            JsonObjectBuilder trBuilder = this.stepBuilder;
            JsonObjectBuilder rpBuilder = Json.createObjectBuilder();
            String stepName = step.getName().getValue();
            String anchor = step.getJsonNamePrefix() + "-" + stepName + "-" + UUID.randomUUID();
            step.setAnchor(new StepName(anchor));
            trBuilder.add("type", "touchedResourceIterator");
            trBuilder.add("name", anchor);
            trBuilder.add("failFast", step.isFailFast());
            trBuilder.add("maxIteration", String.valueOf(step.getMaxConcurrentProcesses().getValue()));
            step.getPreconditionScript().ifPresent(script -> trBuilder.add("preconditionScript", script.getValue()));
            trBuilder.add("properties", (JsonValue)this.createProperties(step));
            boolean isIgnoreChildWarnings = step.isIgnoreChildWarnings();
            trBuilder.add("isIgnoreChildWarnings", isIgnoreChildWarnings);
            rpBuilder.add("isIgnoreChildWarnings", isIgnoreChildWarnings);
            rpBuilder.add("type", "runProcess");
            rpBuilder.add("name", step.getName().getValue());
            rpBuilder.add("processName", step.getProcess().getValue());
            trBuilder.add("children", (JsonValue)Json.createArrayBuilder().add((JsonValue)rpBuilder.build()).build());
        }

        protected void processGenericManualTaskStep(GenericManualTaskStep step) {
            this.stepBuilder.add("type", step.getJsonKeyword());
            this.stepBuilder.add("name", step.getName().getValue());
            this.stepBuilder.add("children", (JsonValue)Json.createArrayBuilder().build());
            this.stepBuilder.add("templateName", step.getNotificationTemplate().map(Stringish::getValue).orElse(""));
            this.stepBuilder.add("commentRequired", step.isCommentRequired());
            this.stepBuilder.add("commentPrompt", step.getCommentPrompt().map(Stringish::getValue).orElse(""));
            TaskApprovalRestriction approvalRestriction = step.getApprovalRestriction();
            this.stepBuilder.add("deployingUserOnly", approvalRestriction instanceof DeployingUserTaskApprovalRestriction);
            if (approvalRestriction instanceof DeployingUserTaskApprovalRestriction) {
                this.stepBuilder.add("deployingUserOnly", true);
                this.stepBuilder.add("userNames", "");
                this.stepBuilder.add("groupNames", "");
            } else if (approvalRestriction instanceof IdentityBasedTaskApprovalRestriction) {
                IdentityBasedTaskApprovalRestriction identityRestriction = (IdentityBasedTaskApprovalRestriction)approvalRestriction;
                this.stepBuilder.add("deployingUserOnly", false);
                this.stepBuilder.add("userNames", identityRestriction.getUsers().stream().map(Stringish::getValue).collect(Collectors.joining(",")));
                this.stepBuilder.add("groupNames", identityRestriction.getGroups().stream().map(Stringish::getValue).collect(Collectors.joining(",")));
            } else {
                throw new RuntimeException("unimplemented task restriction type: " + approvalRestriction.getClass().getName());
            }
            this.stepBuilder.add("propDefs", (JsonValue)this.createPropertyDefinitions(step.getPropertyDefinitions()));
        }

        protected void processAbstractManualTaskStep(AbstractManualTaskStep step) {
            this.stepBuilder.add("type", step.getJsonKeyword());
            this.stepBuilder.add("name", step.getName().getValue());
            this.stepBuilder.add("children", (JsonValue)Json.createArrayBuilder().build());
            this.stepBuilder.add("templateName", step.getNotificationTemplate().map(Stringish::getValue).orElse(""));
            this.stepBuilder.add("deployingUserOnly", step.getApprovalRestriction() instanceof DeployingUserTaskApprovalRestriction);
            this.stepBuilder.add("roleRestrictionData", (JsonValue)this.createRoleRestrictionData(step.getApprovalRestriction()));
            this.stepBuilder.add("propDefs", (JsonValue)this.createPropertyDefinitions(step.getPropertyDefinitions()));
        }

        protected JsonObject createRoleRestrictionData(TaskApprovalRestriction approvalRestriction) {
            JsonObjectBuilder restrictionDataBuilder = Json.createObjectBuilder();
            JsonArrayBuilder roleRestrictionsBuilder = Json.createArrayBuilder();
            if (approvalRestriction instanceof RoleBasedTaskApprovalRestriction) {
                RoleBasedTaskApprovalRestriction roleApprovalRestriction = (RoleBasedTaskApprovalRestriction)approvalRestriction;
                restrictionDataBuilder.add("contextType", roleApprovalRestriction.getJsonKeyword());
                roleApprovalRestriction.getRestrictions().stream().map(this::createRoleRestriction).forEach(arg_0 -> ((JsonArrayBuilder)roleRestrictionsBuilder).add(arg_0));
            }
            restrictionDataBuilder.add("roleRestrictions", (JsonValue)roleRestrictionsBuilder.build());
            return restrictionDataBuilder.build();
        }

        protected JsonArray createPropertyDefinitions(List<PropertyDefinition> propdefs) {
            JsonArrayBuilder builder = Json.createArrayBuilder();
            PropertyDefinitionToJsonBuilder propdefBuilder = new PropertyDefinitionToJsonBuilder();
            propdefs.stream().map(propdefBuilder::createPropertyDefinition).forEach(arg_0 -> ((JsonArrayBuilder)builder).add(arg_0));
            return builder.build();
        }

        protected JsonObject createRoleRestriction(RoleRestriction restriction) {
            JsonObjectBuilder builder = Json.createObjectBuilder();
            builder.add("roleId", restriction.getRole().getValue());
            restriction.getResourceType().ifPresent(t -> builder.add("resourceRoleId", t.getValue()));
            return builder.build();
        }

        protected void processStartStep(StartStep step) {
        }

        protected void processFinishStep(FinishStep step) {
            FinishStep finishStep = GraphJsonBuilder.this.rootGraph.getFinishStep();
            this.stepBuilder.add("type", "finish");
            this.stepBuilder.add("name", finishStep.getName().getValue());
        }

        protected JsonObject createProperties(PropertyContainer container) {
            JsonObjectBuilder propsBuilder = Json.createObjectBuilder();
            for (Property property : container.getProperties()) {
                propsBuilder.add(property.getName().getValue(), property.getExpression().getValue());
            }
            return propsBuilder.build();
        }

        JsonObject createPostProcessingProperties(PluginStep step) {
            JsonObjectBuilder propsBuilder = Json.createObjectBuilder();
            for (Property property : step.getPostProcessingProperty()) {
                propsBuilder.add(property.getName().getValue(), property.getExpression().getValue());
            }
            return propsBuilder.build();
        }

        void attachChildren() {
            GraphJsonBuilder.this.graphBuilder.add("children", (JsonValue)this.childrenBuilder.build());
        }
    }
}

