/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.upload;

import java.io.Reader;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.MissingFormatArgumentException;
import java.util.Optional;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import ucd.pacc.main.ScriptInjector;
import ucd.pacc.main.ServerDataGetter;
import ucd.pacc.model.AbstractPropertyDefinitionOptions;
import ucd.pacc.model.AcquireLockStep;
import ucd.pacc.model.ActionGroup;
import ucd.pacc.model.ActionGroupStep;
import ucd.pacc.model.ActionsOnEvent;
import ucd.pacc.model.AddInventoryStatusStep;
import ucd.pacc.model.AddProcessWarningStep;
import ucd.pacc.model.AnyUserTaskApprovalRestriction;
import ucd.pacc.model.AppMultiComponentStep;
import ucd.pacc.model.AppProcessResourceStep;
import ucd.pacc.model.ApplicationManualTaskStep;
import ucd.pacc.model.ApplicationRunComponentProcessStep;
import ucd.pacc.model.ApplyConfigurationStep;
import ucd.pacc.model.CaseMatch;
import ucd.pacc.model.ChangedComponentResourceListSelection;
import ucd.pacc.model.ChangedComponentResourceSelectionMode;
import ucd.pacc.model.ChangedComponentResourceTagSelection;
import ucd.pacc.model.CheckboxPropertyDefinitionOptions;
import ucd.pacc.model.CommonPropertyDefinitionOptions;
import ucd.pacc.model.ComponentName;
import ucd.pacc.model.ComponentRunComponentProcessStep;
import ucd.pacc.model.ComponentTagName;
import ucd.pacc.model.Concurrency;
import ucd.pacc.model.DateTimePropertyDefinitionOptions;
import ucd.pacc.model.DeployingUserTaskApprovalRestriction;
import ucd.pacc.model.FinalStatus;
import ucd.pacc.model.ForEachAgentStep;
import ucd.pacc.model.ForEachResourceTagStep;
import ucd.pacc.model.GenericManualTaskStep;
import ucd.pacc.model.GroupName;
import ucd.pacc.model.IdentityBasedTaskApprovalRestriction;
import ucd.pacc.model.InstallComponentStep;
import ucd.pacc.model.InstallMultipleComponentsStep;
import ucd.pacc.model.InventoryStatusName;
import ucd.pacc.model.JoinStep;
import ucd.pacc.model.LockExpression;
import ucd.pacc.model.MultiSelectPropertyDefinitionOptions;
import ucd.pacc.model.MultiValuedPropertyDefinitionOptions;
import ucd.pacc.model.NotificationTemplateName;
import ucd.pacc.model.ParseSourceName;
import ucd.pacc.model.ParseSourcePosition;
import ucd.pacc.model.PluginCommandName;
import ucd.pacc.model.PluginName;
import ucd.pacc.model.PluginStep;
import ucd.pacc.model.ProcessName;
import ucd.pacc.model.Property;
import ucd.pacc.model.PropertyContainer;
import ucd.pacc.model.PropertyDefinition;
import ucd.pacc.model.PropertyDefinitionType;
import ucd.pacc.model.PropertyDescription;
import ucd.pacc.model.PropertyExpression;
import ucd.pacc.model.PropertyExpressionPropertyDefinitionOptions;
import ucd.pacc.model.PropertyLabel;
import ucd.pacc.model.PropertyName;
import ucd.pacc.model.PropertyNameOrExpression;
import ucd.pacc.model.PropertyPattern;
import ucd.pacc.model.ReleaseLockStep;
import ucd.pacc.model.RemoveInventoryStatusStep;
import ucd.pacc.model.ResourcePath;
import ucd.pacc.model.ResourceTagName;
import ucd.pacc.model.RoleBasedTaskApprovalRestriction;
import ucd.pacc.model.RoleBasedTaskApprovalType;
import ucd.pacc.model.RoleName;
import ucd.pacc.model.RoleRestriction;
import ucd.pacc.model.RollbackComponentStep;
import ucd.pacc.model.RollbackMultipleComponentsStep;
import ucd.pacc.model.RollbackRemovalType;
import ucd.pacc.model.RunGenericProcessStep;
import ucd.pacc.model.RunOperationalProcessForMultipleComponentsStep;
import ucd.pacc.model.RunProcessForEachVersionStep;
import ucd.pacc.model.SecurePropertyDefinitionOptions;
import ucd.pacc.model.SelectPropertyDefinitionOptions;
import ucd.pacc.model.SelectPropertyValue;
import ucd.pacc.model.SetFinalProcessStatusStep;
import ucd.pacc.model.StepActionFinish;
import ucd.pacc.model.StepActionStart;
import ucd.pacc.model.StepGraph;
import ucd.pacc.model.StepName;
import ucd.pacc.model.SwitchStep;
import ucd.pacc.model.TaskApprovalRestriction;
import ucd.pacc.model.TextAreaPropertyDefinitionOptions;
import ucd.pacc.model.TextPropertyDefinitionOptions;
import ucd.pacc.model.UninstallComponentStep;
import ucd.pacc.model.UninstallMultipleComponentsStep;
import ucd.pacc.model.UninstallRemovalType;
import ucd.pacc.model.UserName;
import ucd.pacc.model.Warning;
import ucd.pacc.parser.ParseException;
import ucd.pacc.parser.ParseSource;
import ucd.pacc.parser.analysis.CheckMissingActionTargetProcessor;
import ucd.pacc.parser.analysis.CheckNoCyclesProcessor;
import ucd.pacc.parser.analysis.CheckNoOrphansProcessor;
import ucd.pacc.parser.analysis.CheckPropertyDefinitionDefaultsAgainstPatternsProcessor;
import ucd.pacc.parser.analysis.CheckPropertyDefinitionNameUniquenessProcessor;
import ucd.pacc.parser.analysis.CheckPropertyNameUniquenessProcessor;
import ucd.pacc.parser.analysis.CheckStepAnchorUniquenessProcessor;
import ucd.pacc.parser.analysis.CheckStepNameUniquenessProcessor;
import ucd.pacc.parser.analysis.PopulateStepByAnchorMapProcessor;
import ucd.pacc.parser.analysis.PopulateStepByNameMapProcessor;
import ucd.pacc.util.ErrorHandler;
import ucd.pacc.util.Util;

public class StepGraphBuilder {
    public static final String VALUES = "values";
    public static final String BODY = "body";
    public static final String SCRIPT_FILE = "scriptFile";
    public static final int FILENAME_BEGIN_INDEX = "scriptFile".length() + 1;
    StepGraph stepGraph;
    JSONObject userJson;
    ParseSourceName name;
    ParseSourcePosition sourcePosition;

    private StepGraphBuilder(JSONObject userJson) {
        this.userJson = userJson;
        this.stepGraph = new StepGraph();
        this.name = new ParseSourceName("TEXT");
        this.sourcePosition = new ParseSourcePosition(this.name, 1, 1);
    }

    StepGraphBuilder(ParseSource source) {
        Reader reader = source.getReader();
        StringBuilder sb = new StringBuilder();
        this.name = new ParseSourceName("TEXT");
        this.sourcePosition = new ParseSourcePosition(this.name, 1, 1);
        try {
            int i;
            while ((i = reader.read()) != -1) {
                sb.append((char)i);
            }
            this.userJson = new JSONObject(sb.toString());
            this.stepGraph = new StepGraph();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get JSONObject from source " + source.getName());
        }
    }

    public StepGraphBuilder() {
        this.name = new ParseSourceName("TEXT");
        this.sourcePosition = new ParseSourcePosition(this.name, 1, 1);
        this.stepGraph = new StepGraph();
    }

    public StepGraph buildStepGraphFromUserJsonFormat() throws ParseException {
        Iterator keys = this.userJson.keys();
        while (keys.hasNext()) {
            String stepName = (String)keys.next();
            JSONObject stepJson = this.getStepDataFor(stepName);
            this.buildStepFromJson(stepName, stepJson);
        }
        this.validations();
        return this.stepGraph;
    }

    private void buildStepFromJson(String stepName, JSONObject stepJson) {
        String type = (String)this.getValueFromJson("type", stepJson);
        if (type.equals("plugin")) {
            this.stepGraph.addStep(this.createPluginStep(stepName, stepJson));
        }
        if (type.equalsIgnoreCase("start")) {
            this.createStartStep(stepJson);
        }
        if (type.equalsIgnoreCase("application-run-component-process")) {
            this.stepGraph.addStep(this.createApplicationRunComponentStep(stepName, stepJson));
        }
        if (type.equalsIgnoreCase("component-run-component-process")) {
            this.stepGraph.addStep(this.createComponentRunComponentProcessStep(stepName, stepJson));
        }
        if (type.equalsIgnoreCase("run-generic-process")) {
            this.stepGraph.addStep(this.createGenericProcessStep(stepName, stepJson));
        }
        if (type.equalsIgnoreCase("acquire-lock")) {
            this.stepGraph.addStep(this.createAcquireLockStep(stepName, stepJson));
        }
        if (type.equalsIgnoreCase("release-lock")) {
            this.stepGraph.addStep(this.createReleaseLockStep(stepName, stepJson));
        }
        if (type.equalsIgnoreCase("switch")) {
            this.stepGraph.addStep(this.createSwitchStep(stepName, stepJson));
        }
        if (type.equalsIgnoreCase("join")) {
            this.stepGraph.addStep(this.createJoinStep(stepName, stepJson));
        }
        if (type.equalsIgnoreCase("add-inventory-status")) {
            this.stepGraph.addStep(this.createAddInventoryStatusStep(stepName, stepJson));
        }
        if (type.equalsIgnoreCase("add-process-warning")) {
            this.stepGraph.addStep(this.createAddProcessWarningStep(stepName, stepJson));
        }
        if (type.equalsIgnoreCase("remove-inventory-status")) {
            this.stepGraph.addStep(this.createRemoveInventoryStatusStep(stepName, stepJson));
        }
        if (type.equalsIgnoreCase("application-manual-task")) {
            this.stepGraph.addStep(this.createApplicationManualTaskStep(stepName, stepJson));
        }
        if (type.equalsIgnoreCase("run-operational-process-for-multiple-components")) {
            this.createOperationProcessForMultipleComponentsStep(stepName, stepJson);
        }
        if (type.equalsIgnoreCase("rollback-multiple-components")) {
            this.createRollbackMultipleComponentsStep(stepName, stepJson);
        }
        if (type.equalsIgnoreCase("rollback-component")) {
            this.createRollbackComponentStep(stepName, stepJson);
        }
        if (type.equalsIgnoreCase("uninstall-component")) {
            this.createUninstallComponentStep(stepName, stepJson);
        }
        if (type.equalsIgnoreCase("uninstall-multiple-components")) {
            this.createUninstallMultipleComponentsStep(stepName, stepJson);
        }
        if (type.equalsIgnoreCase("install-component")) {
            this.createInstallComponentStep(stepName, stepJson);
        }
        if (type.equalsIgnoreCase("install-multiple-components")) {
            this.createInstallMultipleComponentsStep(stepName, stepJson);
        }
        if (type.equalsIgnoreCase("run-process-for-each-version")) {
            this.createRunProcessForEachVersion(stepName, stepJson);
        }
        if (type.equalsIgnoreCase("for-each-agent")) {
            this.createForEachAgentStep(stepName, stepJson);
        }
        if (type.equalsIgnoreCase("apply-configuration")) {
            this.createApplyConfigurationStep(stepName, stepJson);
        }
        if (type.equalsIgnoreCase("for-each-resource-tag")) {
            this.createForEachResourceTagStep(stepName, stepJson);
        }
        if (type.equalsIgnoreCase("set-final-process-status")) {
            this.createSetFinalProcessStatusStep(stepName, stepJson);
        }
        if (type.equalsIgnoreCase("generic-manual-task")) {
            this.createGenericManualTaskStep(stepName, stepJson);
        }
    }

    public ApplicationRunComponentProcessStep createApplicationRunComponentStep(String stepName, JSONObject stepJson) {
        ProcessName processName = new ProcessName((String)this.getMandatoryValueFromJson("process", stepJson));
        ComponentName componentName = new ComponentName((String)this.getMandatoryValueFromJson("component", stepJson));
        ApplicationRunComponentProcessStep step = new ApplicationRunComponentProcessStep(this.sourcePosition, new StepName(stepName), componentName, processName);
        this.processByChangedComponent(stepJson, step);
        Optional<Object> byResourceTagOptional = this.getOptionalValueFromJson("select-resources-by-tag", stepJson);
        if (byResourceTagOptional.isPresent()) {
            if (byResourceTagOptional.get().toString().length() == 36) {
                step.setByResourceTag(Optional.of(new ResourceTagName((String)byResourceTagOptional.get())));
            } else {
                String tagId = this.getTagId("/cli/tags?objectType=Resource", byResourceTagOptional.get().toString());
                step.setByResourceTag(Optional.of(new ResourceTagName(tagId)));
            }
        } else {
            step.setByResourceTag(Optional.empty());
        }
        this.addActionGroup(stepJson, step);
        this.addProperties(stepJson, step);
        this.setMiscellaneousSettingsForAppProcess(stepJson, step);
        return step;
    }

    private void processByChangedComponent(JSONObject stepJson, ApplicationRunComponentProcessStep step) {
        Optional<Object> changedByComponent = this.getOptionalValueFromJson("select-resources-by-changed-component-list", stepJson);
        if (changedByComponent.isPresent()) {
            JSONArray componentList = (JSONArray)this.getMandatoryValueFromJson("components", (JSONObject)changedByComponent.get());
            if (componentList.length() < 1) {
                throw new MissingFormatArgumentException("Should have at least one component when selecting 'select-resources-by-changed-component-list'.");
            }
            String selectResources = (String)this.getMandatoryValueFromJson("select-resources", (JSONObject)changedByComponent.get());
            if (!selectResources.equalsIgnoreCase("all") && !selectResources.equalsIgnoreCase("with-changed-component")) {
                throw new IllegalArgumentException("Accepted values for select-resources are all and with-changed-component");
            }
            ChangedComponentResourceListSelection componentResourceListSelection = selectResources.equalsIgnoreCase("all") ? new ChangedComponentResourceListSelection(ChangedComponentResourceSelectionMode.ALL) : new ChangedComponentResourceListSelection(ChangedComponentResourceSelectionMode.WITH_CHANGED_COMPONENT);
            for (int i = 0; i < componentList.length(); ++i) {
                componentResourceListSelection.addComponent(new ComponentName((String)this.getValueFromJsonArray(i, componentList)));
            }
            step.setByChangedComponent(Optional.of(componentResourceListSelection));
        }
    }

    private void createSetFinalProcessStatusStep(String stepName, JSONObject stepJson) {
        String status = (String)this.getValueFromJson("status", stepJson);
        SetFinalProcessStatusStep step = new SetFinalProcessStatusStep(this.sourcePosition, new StepName(stepName), FinalStatus.getForJsonKeyword(status.toUpperCase()));
        step.setActionGroup(this.getActionGroupFromJson((JSONObject)this.getValueFromJson("on", stepJson)));
        this.stepGraph.addStep(step);
    }

    private void createForEachResourceTagStep(String stepName, JSONObject stepJson) {
        ForEachResourceTagStep step = new ForEachResourceTagStep(this.sourcePosition, new StepName(stepName));
        StepGraph childProcess = this.getStepGraphForChildProcess((JSONObject)this.getValueFromJson("child-process", stepJson));
        step.setGraph(childProcess);
        step.setMaxConcurrentTags(this.getMaxConcurrentTags(stepJson));
        JSONArray tags = (JSONArray)this.getValueFromJson("tag", stepJson);
        for (int i = 0; i < tags.length(); ++i) {
            String tag = (String)this.getValueFromJsonArray(i, tags);
            if (tag.length() == 36) {
                step.addTag(new ResourceTagName(Util.escape((String)this.getValueFromJsonArray(i, tags))));
                continue;
            }
            String tagId = this.getTagId("/cli/tags?objectType=Resource", tag);
            step.addTag(new ResourceTagName(Util.escape(tagId)));
        }
        step.setActionGroup(this.getActionGroupFromJson((JSONObject)this.getMandatoryValueFromJson("on", stepJson)));
        this.stepGraph.addStep(step);
    }

    private void createApplyConfigurationStep(String stepName, JSONObject stepJson) {
        String componentName = (String)this.getValueFromJson("component", stepJson);
        String processName = (String)this.getValueFromJson("process", stepJson);
        ApplyConfigurationStep step = new ApplyConfigurationStep(this.sourcePosition, new StepName(stepName), new ComponentName(componentName), new ProcessName(processName));
        this.setMiscellaneousSettingsForAppProcess(stepJson, step);
        this.addActionGroup(stepJson, step);
        this.addProperties(stepJson, step);
        this.stepGraph.addStep(step);
    }

    private void createForEachAgentStep(String stepName, JSONObject stepJson) {
        ForEachAgentStep step = new ForEachAgentStep(this.sourcePosition, new StepName(stepName));
        StepGraph childProcess = this.getStepGraphForChildProcess((JSONObject)this.getValueFromJson("child-process", stepJson));
        step.setGraph(childProcess);
        step.setMaxConcurrentAgents(this.getMaxConcurrentAgents(stepJson));
        JSONArray tags = (JSONArray)this.getValueFromJson("tag", stepJson);
        for (int i = 0; i < tags.length(); ++i) {
            String tag = (String)this.getValueFromJsonArray(i, tags);
            if (tag.length() == 36) {
                step.addTag(new ResourceTagName(Util.escape((String)this.getValueFromJsonArray(i, tags))));
                continue;
            }
            String tagId = this.getTagId("/cli/tags?objectType=Resource", tag);
            step.addTag(new ResourceTagName(Util.escape(tagId)));
        }
        this.addActionGroup(stepJson, step);
        this.stepGraph.addStep(step);
    }

    private StepGraph getStepGraphForChildProcess(JSONObject jsonProcess) {
        try {
            StepGraphBuilder builder = new StepGraphBuilder(jsonProcess);
            return builder.buildStepGraphFromUserJsonFormat();
        }
        catch (ParseException e) {
            throw new RuntimeException("Error building child Process in For-each step");
        }
    }

    private void createRunProcessForEachVersion(String stepName, JSONObject stepJson) {
        String componentName = (String)this.getValueFromJson("component", stepJson);
        String processName = (String)this.getValueFromJson("process", stepJson);
        RunProcessForEachVersionStep step = new RunProcessForEachVersionStep(this.sourcePosition, new StepName(stepName), new ComponentName(componentName), new ProcessName(processName));
        this.setMiscellaneousSettingsForAppProcess(stepJson, step);
        boolean runOnFirstOnlineResource = (Boolean)this.getValueFromJson("run-on-first-online-resource-only", stepJson);
        step.setRunOnFirstOnlineResourceOnly(runOnFirstOnlineResource);
        this.addActionGroup(stepJson, step);
        this.addProperties(stepJson, step);
        this.stepGraph.addStep(step);
    }

    private void createInstallMultipleComponentsStep(String stepName, JSONObject stepJson) {
        ProcessName processName = new ProcessName((String)this.getValueFromJson("process", stepJson));
        String invStatus = (String)this.getValueFromJson("select-versions-without-inventory-status", stepJson);
        InventoryStatusName inventoryStatusName = new InventoryStatusName(invStatus);
        InstallMultipleComponentsStep step = new InstallMultipleComponentsStep(this.sourcePosition, new StepName(stepName), processName, inventoryStatusName);
        this.setMiscellaneousSettingsForAppMultiComp(stepJson, step);
        Optional<Object> byComponentTagOptional = this.getOptionalValueFromJson("select-components-by-tag", stepJson);
        if (byComponentTagOptional.isPresent()) {
            if (byComponentTagOptional.get().toString().length() == 36) {
                step.setByComponentTag(Optional.of(new ComponentTagName((String)byComponentTagOptional.get())));
            } else {
                String tagId = this.getTagId("/cli/tags?objectType=Component", byComponentTagOptional.get().toString());
                step.setByComponentTag(Optional.of(new ComponentTagName(tagId)));
            }
        } else {
            step.setByComponentTag(Optional.empty());
        }
        Optional<Object> byResourceTagOptional = this.getOptionalValueFromJson("select-resources-by-tag", stepJson);
        if (byResourceTagOptional.isPresent()) {
            if (byResourceTagOptional.get().toString().length() == 36) {
                step.setByResourceTag(Optional.of(new ResourceTagName((String)byResourceTagOptional.get())));
            } else {
                String tagId = this.getTagId("/cli/tags?objectType=Resource", byResourceTagOptional.get().toString());
                step.setByResourceTag(Optional.of(new ResourceTagName(tagId)));
            }
        } else {
            step.setByResourceTag(Optional.empty());
        }
        this.addActionGroup(stepJson, step);
        this.stepGraph.addStep(step);
    }

    private void createInstallComponentStep(String stepName, JSONObject stepJson) {
        ComponentName componentName = new ComponentName((String)this.getValueFromJson("component", stepJson));
        ProcessName processName = new ProcessName((String)this.getValueFromJson("process", stepJson));
        String invStatus = (String)this.getValueFromJson("select-versions-without-inventory-status", stepJson);
        InventoryStatusName inventoryStatusName = new InventoryStatusName(invStatus);
        InstallComponentStep step = new InstallComponentStep(this.sourcePosition, new StepName(stepName), componentName, processName, inventoryStatusName);
        Optional<Object> byResourceTagOptional = this.getOptionalValueFromJson("select-resources-by-tag", stepJson);
        if (byResourceTagOptional.isPresent()) {
            if (byResourceTagOptional.get().toString().length() == 36) {
                step.setByResourceTag(Optional.of(new ResourceTagName((String)byResourceTagOptional.get())));
            } else {
                String tagId = this.getTagId("/cli/tags?objectType=Resource", byResourceTagOptional.get().toString());
                step.setByResourceTag(Optional.of(new ResourceTagName(tagId)));
            }
        } else {
            step.setByResourceTag(Optional.empty());
        }
        this.setMiscellaneousSettingsForAppProcess(stepJson, step);
        this.addActionGroup(stepJson, step);
        this.addProperties(stepJson, step);
        this.stepGraph.addStep(step);
    }

    private void createUninstallMultipleComponentsStep(String stepName, JSONObject stepJson) {
        ProcessName processName = new ProcessName((String)this.getValueFromJson("process", stepJson));
        String uninstallVersionsType = this.getUninstallVersionType(stepJson);
        UninstallRemovalType uninstallRemovalType = UninstallRemovalType.getForJsonKeyword(uninstallVersionsType.toUpperCase());
        String invStatus = (String)this.getValueFromJson("select-versions-with-inventory-status", stepJson);
        InventoryStatusName inventoryStatusName = new InventoryStatusName(invStatus);
        UninstallMultipleComponentsStep step = new UninstallMultipleComponentsStep(this.sourcePosition, new StepName(stepName), processName, uninstallRemovalType, inventoryStatusName);
        String componentsByTag = (String)this.getValueFromJson("select-components-by-tag", stepJson);
        if (componentsByTag.length() == 36) {
            step.setByComponentTag(Optional.of(new ComponentTagName(componentsByTag)));
        } else {
            String tagId = this.getTagId("/cli/tags?objectType=Component", componentsByTag);
            step.setByComponentTag(Optional.of(new ComponentTagName(tagId)));
        }
        Optional<Object> byResourceTagOptional = this.getOptionalValueFromJson("select-resources-by-tag", stepJson);
        if (byResourceTagOptional.isPresent()) {
            if (byResourceTagOptional.get().toString().length() == 36) {
                step.setByResourceTag(Optional.of(new ResourceTagName((String)byResourceTagOptional.get())));
            } else {
                String tagId = this.getTagId("/cli/tags?objectType=Resource", byResourceTagOptional.get().toString());
                step.setByResourceTag(Optional.of(new ResourceTagName(tagId)));
            }
        } else {
            step.setByResourceTag(Optional.empty());
        }
        this.setMiscellaneousSettingsForAppMultiComp(stepJson, step);
        this.addActionGroup(stepJson, step);
        this.stepGraph.addStep(step);
    }

    private void createUninstallComponentStep(String stepName, JSONObject stepJson) {
        ComponentName componentName = new ComponentName((String)this.getValueFromJson("component", stepJson));
        ProcessName processName = new ProcessName((String)this.getValueFromJson("process", stepJson));
        String uninstallVersionsType = this.getUninstallVersionType(stepJson);
        UninstallRemovalType uninstallRemovalType = UninstallRemovalType.getForJsonKeyword(uninstallVersionsType.toUpperCase());
        String invStatus = (String)this.getValueFromJson("select-versions-with-inventory-status", stepJson);
        InventoryStatusName inventoryStatusName = new InventoryStatusName(invStatus);
        UninstallComponentStep step = new UninstallComponentStep(this.sourcePosition, new StepName(stepName), componentName, processName, uninstallRemovalType, inventoryStatusName);
        Optional<Object> byResourceTagOptional = this.getOptionalValueFromJson("select-resources-by-tag", stepJson);
        if (byResourceTagOptional.isPresent()) {
            if (byResourceTagOptional.get().toString().length() == 36) {
                step.setByResourceTag(Optional.of(new ResourceTagName((String)byResourceTagOptional.get())));
            } else {
                String tagId = this.getTagId("/cli/tags?objectType=Resource", byResourceTagOptional.get().toString());
                step.setByResourceTag(Optional.of(new ResourceTagName(tagId)));
            }
        } else {
            step.setByResourceTag(Optional.empty());
        }
        this.setMiscellaneousSettingsForAppProcess(stepJson, step);
        step.setActionGroup(this.getActionGroupFromJson((JSONObject)this.getMandatoryValueFromJson("on", stepJson)));
        Optional<Object> optionalProperties = this.getOptionalValueFromJson("properties", stepJson);
        optionalProperties.ifPresent(o -> this.addPropertiesToStep(step, (JSONObject)o));
        this.stepGraph.addStep(step);
    }

    private void createRollbackComponentStep(String stepName, JSONObject stepJson) {
        ComponentName componentName = new ComponentName((String)this.getValueFromJson("component", stepJson));
        String rollbackTypeString = this.getRollbackTypeString(stepJson);
        ProcessName processName = new ProcessName((String)this.getValueFromJson("process", stepJson));
        RollbackRemovalType rollbackType = RollbackRemovalType.getForJsonKeyword(rollbackTypeString.toUpperCase());
        String invStatus = (String)this.getValueFromJson("select-versions-with-inventory-status", stepJson);
        InventoryStatusName inventoryStatusName = new InventoryStatusName(invStatus);
        RollbackComponentStep step = new RollbackComponentStep(this.sourcePosition, new StepName(stepName), componentName, processName, rollbackType, inventoryStatusName);
        Optional<Object> byResourceTagOptional = this.getOptionalValueFromJson("select-resources-by-tag", stepJson);
        if (byResourceTagOptional.isPresent()) {
            if (byResourceTagOptional.get().toString().length() == 36) {
                step.setByResourceTag(Optional.of(new ResourceTagName((String)byResourceTagOptional.get())));
            } else {
                String tagId = this.getTagId("/cli/tags?objectType=Resource", byResourceTagOptional.get().toString());
                step.setByResourceTag(Optional.of(new ResourceTagName(tagId)));
            }
        } else {
            step.setByResourceTag(Optional.empty());
        }
        this.setMiscellaneousSettingsForAppProcess(stepJson, step);
        step.setActionGroup(this.getActionGroupFromJson((JSONObject)this.getMandatoryValueFromJson("on", stepJson)));
        Optional<Object> optionalProperties = this.getOptionalValueFromJson("properties", stepJson);
        optionalProperties.ifPresent(o -> this.addPropertiesToStep(step, (JSONObject)o));
        this.stepGraph.addStep(step);
    }

    private void createRollbackMultipleComponentsStep(String stepName, JSONObject stepJson) {
        ProcessName processName = new ProcessName((String)this.getValueFromJson("process", stepJson));
        String rollbackTypeString = this.getRollbackTypeString(stepJson);
        RollbackRemovalType rollbackType = RollbackRemovalType.getForJsonKeyword(rollbackTypeString.toUpperCase());
        String invStatus = (String)this.getValueFromJson("select-versions-with-inventory-status", stepJson);
        InventoryStatusName inventoryStatusName = new InventoryStatusName(invStatus);
        RollbackMultipleComponentsStep step = new RollbackMultipleComponentsStep(this.sourcePosition, new StepName(stepName), processName, rollbackType, inventoryStatusName);
        String componentsByTag = (String)this.getValueFromJson("select-components-by-tag", stepJson);
        if (componentsByTag.length() == 36) {
            step.setByComponentTag(Optional.of(new ComponentTagName(componentsByTag)));
        } else {
            String tagId = this.getTagId("/cli/tags?objectType=Component", componentsByTag);
            step.setByComponentTag(Optional.of(new ComponentTagName(tagId)));
        }
        Optional<Object> byResourceTagOptional = this.getOptionalValueFromJson("select-resources-by-tag", stepJson);
        if (byResourceTagOptional.isPresent()) {
            if (byResourceTagOptional.get().toString().length() == 36) {
                step.setByResourceTag(Optional.of(new ResourceTagName((String)byResourceTagOptional.get())));
            } else {
                String tagId = this.getTagId("/cli/tags?objectType=Resource", byResourceTagOptional.get().toString());
                step.setByResourceTag(Optional.of(new ResourceTagName(tagId)));
            }
        } else {
            step.setByResourceTag(Optional.empty());
        }
        this.setMiscellaneousSettingsForAppMultiComp(stepJson, step);
        JSONObject stepTerminationEvents = (JSONObject)this.getMandatoryValueFromJson("on", stepJson);
        step.setActionGroup(this.getActionGroupFromJson(stepTerminationEvents));
        this.stepGraph.addStep(step);
    }

    private void createOperationProcessForMultipleComponentsStep(String stepName, JSONObject stepJson) {
        ProcessName processName = new ProcessName((String)this.getValueFromJson("process", stepJson));
        RunOperationalProcessForMultipleComponentsStep step = new RunOperationalProcessForMultipleComponentsStep(this.sourcePosition, new StepName(stepName), processName);
        String componentsByTag = (String)this.getValueFromJson("select-components-by-tag", stepJson);
        if (componentsByTag == null || componentsByTag.isEmpty()) {
            ErrorHandler.printErrorAndExit("Component tag is a mandatory field when working with 'Multi component steps'\n, the format is \"select-components-by-tag\":\"uuid\"");
        }
        if (componentsByTag.length() == 36) {
            step.setByComponentTag(Optional.of(new ComponentTagName(componentsByTag)));
        } else {
            String tagId = this.getTagId("/cli/tags?objectType=Component", componentsByTag);
            step.setByComponentTag(Optional.of(new ComponentTagName(tagId)));
        }
        Optional<Object> byResourcesByTagOptional = this.getOptionalValueFromJson("select-resources-by-tag", stepJson);
        if (byResourcesByTagOptional.isPresent()) {
            String resourcesByTag = (String)byResourcesByTagOptional.get();
            if (resourcesByTag.length() == 36) {
                step.setByResourceTag(Optional.of(new ResourceTagName(resourcesByTag)));
            } else {
                String tagId = this.getTagId("/cli/tags?objectType=Resource", resourcesByTag);
                step.setByResourceTag(Optional.of(new ResourceTagName(tagId)));
            }
        } else {
            step.setByResourceTag(Optional.empty());
        }
        Optional<Object> componentResourceTagSelectionOptional = this.getOptionalValueFromJson("select-resources-by-tag", stepJson);
        if (componentResourceTagSelectionOptional.isPresent()) {
            ChangedComponentResourceTagSelection componentResourceTagSelection;
            JSONObject getByChangedComponent = (JSONObject)this.getValueFromJson("select-resources-by-changed-component-tag", stepJson);
            String selectResources = (String)this.getValueFromJson("select-resources", getByChangedComponent);
            if (selectResources.equalsIgnoreCase("all")) {
                componentResourceTagSelection = new ChangedComponentResourceTagSelection(ChangedComponentResourceSelectionMode.ALL);
            } else {
                componentResourceTagSelection = new ChangedComponentResourceTagSelection(ChangedComponentResourceSelectionMode.WITH_CHANGED_COMPONENT);
                Optional<Object> componentTagOptional = this.getOptionalValueFromJson("select-components-by-tag", getByChangedComponent);
                componentTagOptional.ifPresent(o -> {
                    if (o.toString().length() == 36) {
                        step.setByComponentTag(Optional.of(new ComponentTagName((String)o)));
                    } else {
                        String tagId = this.getTagId("/cli/tags?objectType=Component", o.toString());
                        step.setByComponentTag(Optional.of(new ComponentTagName(tagId)));
                    }
                });
            }
            step.setByChangedComponent(Optional.of(componentResourceTagSelection));
        }
        boolean runOnFirstOnlineResource = (Boolean)this.getValueFromJson("run-on-first-online-resource-only", stepJson);
        step.setRunOnFirstOnlineResourceOnly(runOnFirstOnlineResource);
        this.setMiscellaneousSettingsForAppMultiComp(stepJson, step);
        JSONObject stepTerminationEvents = (JSONObject)this.getMandatoryValueFromJson("on", stepJson);
        step.setActionGroup(this.getActionGroupFromJson(stepTerminationEvents));
        this.stepGraph.addStep(step);
    }

    protected ApplicationManualTaskStep createApplicationManualTaskStep(String stepName, JSONObject stepJson) {
        ApplicationManualTaskStep step = new ApplicationManualTaskStep(this.sourcePosition, new StepName(stepName));
        TaskApprovalRestriction approvalRestriction = this.getApprovalRestriction(stepJson);
        step.setApprovalRestriction(approvalRestriction);
        NotificationTemplateName templateName = new NotificationTemplateName((String)this.getValueFromJson("notification-template", stepJson));
        step.setNotificationTemplate(Optional.of(templateName));
        ActionGroup stepActionGroup = this.getActionGroupFromJson((JSONObject)this.getMandatoryValueFromJson("on", stepJson));
        step.setActionGroup(stepActionGroup);
        this.getPropertyDefinitionFromStepJson(stepJson).ifPresent(list -> list.forEach(step::addPropertyDefinition));
        return step;
    }

    private void createGenericManualTaskStep(String stepName, JSONObject stepJson) {
        GenericManualTaskStep step = new GenericManualTaskStep(this.sourcePosition, new StepName(stepName));
        TaskApprovalRestriction approvalRestriction = this.getApprovalRestrictionForGenericProcess(stepJson);
        step.setApprovalRestriction(approvalRestriction);
        NotificationTemplateName templateName = new NotificationTemplateName((String)this.getValueFromJson("notification-template", stepJson));
        step.setNotificationTemplate(Optional.of(templateName));
        ActionGroup stepActionGroup = this.getActionGroupFromJson((JSONObject)this.getMandatoryValueFromJson("on", stepJson));
        step.setActionGroup(stepActionGroup);
        this.getPropertyDefinitionFromStepJson(stepJson).ifPresent(object -> {
            ArrayList list = object;
            list.forEach(step::addPropertyDefinition);
        });
        this.stepGraph.addStep(step);
    }

    private TaskApprovalRestriction getApprovalRestrictionForGenericProcess(JSONObject stepJson) {
        IdentityBasedTaskApprovalRestriction identityRestriction = null;
        Optional<Object> restriction = this.getOptionalValueFromJson("restrict-approval-to", stepJson);
        if (!restriction.isPresent()) {
            throw new RuntimeException("Missing Restriction data for Generic Step");
        }
        JSONObject restrictionData = (JSONObject)restriction.get();
        if (this.getOptionalValueFromJson("deploying-user", restrictionData).isPresent()) {
            return new DeployingUserTaskApprovalRestriction();
        }
        if (this.getOptionalValueFromJson("identities", restrictionData).isPresent()) {
            Optional<Object> groups;
            JSONObject identities = (JSONObject)this.getOptionalValueFromJson("identities", restrictionData).get();
            identityRestriction = new IdentityBasedTaskApprovalRestriction();
            Optional<Object> users = this.getOptionalValueFromJson("users", identities);
            if (users.isPresent()) {
                JSONArray usersArray = (JSONArray)users.get();
                for (int i = 0; i < usersArray.length(); ++i) {
                    identityRestriction.addUser(new UserName((String)this.getValueFromJsonArray(i, usersArray)));
                }
            }
            if ((groups = this.getOptionalValueFromJson("groups", identities)).isPresent()) {
                JSONArray groupArray = (JSONArray)groups.get();
                for (int i = 0; i < groupArray.length(); ++i) {
                    identityRestriction.addGroup(new GroupName((String)this.getValueFromJsonArray(i, groupArray)));
                }
            }
        }
        return identityRestriction;
    }

    private Optional<ArrayList<PropertyDefinition>> getPropertyDefinitionFromStepJson(JSONObject stepJson) {
        Optional<Object> propertyDefinitionOptional = this.getOptionalValueFromJson("property-definition", stepJson);
        if (propertyDefinitionOptional.isPresent()) {
            ArrayList<PropertyDefinition> propertyDefinitions = new ArrayList<PropertyDefinition>();
            JSONArray propertyDefinitionArray = (JSONArray)propertyDefinitionOptional.get();
            for (int i = 0; i < propertyDefinitionArray.length(); ++i) {
                JSONObject propDef = (JSONObject)this.getValueFromJsonArray(i, propertyDefinitionArray);
                PropertyDefinition propertyDefinition = this.buildPropertyDefinition(propDef);
                propertyDefinitions.add(propertyDefinition);
            }
            return Optional.of(propertyDefinitions);
        }
        return Optional.empty();
    }

    protected PropertyDefinition buildPropertyDefinition(JSONObject propDef) {
        String propType = (String)this.getMandatoryValueFromJson("property-type", propDef);
        PropertyDefinitionType propDefinitionType = PropertyDefinitionType.getForPacKeyword(propType.toLowerCase());
        String propName = (String)this.getMandatoryValueFromJson("property-name", propDef);
        AbstractPropertyDefinitionOptions propertyDefinitionOptions = null;
        switch (propDefinitionType) {
            case TEXT: {
                propertyDefinitionOptions = new TextPropertyDefinitionOptions();
                this.setPropertyDefaultValue(propDef, (PropertyExpressionPropertyDefinitionOptions)((Object)propertyDefinitionOptions));
                break;
            }
            case TEXT_AREA: {
                propertyDefinitionOptions = new TextAreaPropertyDefinitionOptions();
                this.setPropertyDefaultValue(propDef, (TextAreaPropertyDefinitionOptions)propertyDefinitionOptions);
                break;
            }
            case SECURE: {
                propertyDefinitionOptions = new SecurePropertyDefinitionOptions();
                this.setPropertyDefaultValue(propDef, (PropertyExpressionPropertyDefinitionOptions)((Object)propertyDefinitionOptions));
                break;
            }
            case SELECT: {
                propertyDefinitionOptions = new SelectPropertyDefinitionOptions();
                this.buildSelectPropertyDefinition((MultiValuedPropertyDefinitionOptions)((Object)propertyDefinitionOptions), propDef);
                break;
            }
            case MULTI_SELECT: {
                propertyDefinitionOptions = new MultiSelectPropertyDefinitionOptions();
                this.buildSelectPropertyDefinition((MultiValuedPropertyDefinitionOptions)((Object)propertyDefinitionOptions), propDef);
                break;
            }
            case CHECKBOX: {
                propertyDefinitionOptions = new CheckboxPropertyDefinitionOptions();
                Optional<Object> defaultValue = this.getOptionalValueFromJson("default", propDef);
                if (!defaultValue.isPresent()) break;
                ((CheckboxPropertyDefinitionOptions)propertyDefinitionOptions).setDefaultValue((Boolean)defaultValue.get());
                break;
            }
            case DATE_TIME: {
                propertyDefinitionOptions = new DateTimePropertyDefinitionOptions();
                Optional<Object> epochTime = this.getOptionalValueFromJson("default", propDef);
                if (!epochTime.isPresent()) break;
                Instant instant = this.getInstantFromDateTimeString((String)epochTime.get());
                ((DateTimePropertyDefinitionOptions)propertyDefinitionOptions).setDefaultValue(Optional.of(instant));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported property definition " + this.getValueFromJson("property-type", propDef));
            }
        }
        propertyDefinitionOptions.setCommonOptions(this.getCommonPropertyDefinitions(propDef));
        PropertyDefinition propertyDefinition = new PropertyDefinition(propDefinitionType, new PropertyName(propName));
        propertyDefinition.setOptions(Optional.of(propertyDefinitionOptions));
        return propertyDefinition;
    }

    protected Instant getInstantFromDateTimeString(String dateTime) {
        LocalDateTime localDateTime;
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm");
        try {
            localDateTime = LocalDateTime.parse(dateTime, formatter);
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException("Date/time has to be in format dd/MM/yyyy HH:mm but got " + dateTime);
        }
        return localDateTime.atZone(ZoneId.systemDefault()).toInstant();
    }

    private void setPropertyDefaultValue(JSONObject propDef, PropertyExpressionPropertyDefinitionOptions propertyDefinitionOptions) {
        Optional<Object> defaultValue = this.getOptionalValueFromJson("default", propDef);
        defaultValue.ifPresent(value -> propertyDefinitionOptions.setDefaultValue(Optional.of(new PropertyExpression((String)value))));
    }

    private void buildSelectPropertyDefinition(MultiValuedPropertyDefinitionOptions propertyDefinitionOptions, JSONObject propDef) {
        JSONArray properties = (JSONArray)this.getValueFromJson(VALUES, propDef);
        for (int i = 0; i < properties.length(); ++i) {
            Optional<Object> propValueOptional;
            JSONObject propertyJson = (JSONObject)this.getValueFromJsonArray(i, properties);
            if (propertyJson.names().length() <= 0 || !(propValueOptional = this.getOptionalValueFromJson("value", propertyJson)).isPresent()) continue;
            SelectPropertyValue propertyValue = new SelectPropertyValue((String)propValueOptional.get());
            this.getOptionalValueFromJson("label", propertyJson).ifPresent(o -> propertyValue.setLabel(Optional.of(new PropertyLabel((String)o))));
            if (this.isDefaultValue(propertyJson)) {
                if (propertyDefinitionOptions instanceof SelectPropertyDefinitionOptions) {
                    ((SelectPropertyDefinitionOptions)propertyDefinitionOptions).setDefaultValue(Optional.of(propertyValue));
                    continue;
                }
                if (propertyDefinitionOptions instanceof MultiSelectPropertyDefinitionOptions) {
                    ((MultiSelectPropertyDefinitionOptions)propertyDefinitionOptions).addDefaultValue(propertyValue);
                    continue;
                }
                throw new UnsupportedOperationException("Cannot process property Definition: " + propertyValue.getLabel());
            }
            propertyDefinitionOptions.addValue(propertyValue);
        }
    }

    private boolean isDefaultValue(JSONObject propertyJson) {
        for (int i = 0; i < propertyJson.names().length(); ++i) {
            if (!((String)this.getValueFromJsonArray(i, propertyJson.names())).equalsIgnoreCase("selected") || !((Boolean)this.getValueFromJson("selected", propertyJson)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private Optional<Object> getOptionalValueFromJsonArray(int i, JSONArray names) {
        try {
            return Optional.of(names.get(i));
        }
        catch (JSONException e) {
            return Optional.empty();
        }
    }

    protected Optional<CommonPropertyDefinitionOptions> getCommonPropertyDefinitions(JSONObject propDef) {
        CommonPropertyDefinitionOptions propertyOptions = new CommonPropertyDefinitionOptions();
        this.getOptionalValueFromJson("description", propDef).ifPresent(o -> propertyOptions.setDescription(Optional.of(new PropertyDescription((String)o))));
        this.getOptionalValueFromJson("label", propDef).ifPresent(o -> propertyOptions.setLabel(Optional.of(new PropertyLabel((String)o))));
        this.getOptionalValueFromJson("pattern", propDef).ifPresent(o -> propertyOptions.setPattern(Optional.of(new PropertyPattern((String)o))));
        this.getOptionalValueFromJson("required", propDef).ifPresent(o -> propertyOptions.setRequired((Boolean)o));
        return Optional.of(propertyOptions);
    }

    private TaskApprovalRestriction getApprovalRestriction(JSONObject stepJson) {
        Optional<Object> contextTypeOptional;
        Optional<Object> deployingUserOnlyOptional = this.getOptionalValueFromJson("deployingUserOnly", stepJson);
        if (deployingUserOnlyOptional.isPresent() && ((Boolean)deployingUserOnlyOptional.get()).booleanValue()) {
            return new DeployingUserTaskApprovalRestriction();
        }
        Optional<Object> roleRestrictionDataOptional = this.getOptionalValueFromJson("roleRestrictionData", stepJson);
        if (roleRestrictionDataOptional.isPresent() && (contextTypeOptional = this.getOptionalValueFromJson("contextType", (JSONObject)roleRestrictionDataOptional.get())).isPresent()) {
            RoleBasedTaskApprovalRestriction restriction = StepGraphBuilder.getRoleBasedTaskApprovalRestriction(contextTypeOptional);
            JSONArray roleRestrictions = (JSONArray)this.getMandatoryValueFromJson("roleRestrictions", (JSONObject)roleRestrictionDataOptional.get());
            for (int i = 0; i < roleRestrictions.length(); ++i) {
                restriction.addRestriction(new RoleRestriction(new RoleName((String)this.getValueFromJsonArray(i, roleRestrictions))));
            }
            return restriction;
        }
        return new AnyUserTaskApprovalRestriction();
    }

    private static RoleBasedTaskApprovalRestriction getRoleBasedTaskApprovalRestriction(Optional<Object> contextTypeOptional) {
        RoleBasedTaskApprovalRestriction restriction;
        String contextType = (String)contextTypeOptional.get();
        if (contextType.equalsIgnoreCase("environment")) {
            restriction = new RoleBasedTaskApprovalRestriction(RoleBasedTaskApprovalType.ENVIRONMENT);
        } else if (contextType.equalsIgnoreCase("application")) {
            restriction = new RoleBasedTaskApprovalRestriction(RoleBasedTaskApprovalType.APPLICATION);
        } else if (contextType.equalsIgnoreCase("component")) {
            restriction = new RoleBasedTaskApprovalRestriction(RoleBasedTaskApprovalType.COMPONENT);
        } else {
            throw new UnsupportedOperationException("Invalid context type for Manual task");
        }
        return restriction;
    }

    protected RemoveInventoryStatusStep createRemoveInventoryStatusStep(String stepName, JSONObject stepJson) {
        InventoryStatusName statusName = this.getInventoryStatusName(stepJson);
        RemoveInventoryStatusStep step = new RemoveInventoryStatusStep(this.sourcePosition, new StepName(stepName), statusName);
        JSONObject stepTerminationEvents = (JSONObject)this.getMandatoryValueFromJson("on", stepJson);
        step.setActionGroup(this.getActionGroupFromJson(stepTerminationEvents));
        return step;
    }

    protected AddProcessWarningStep createAddProcessWarningStep(String stepName, JSONObject stepJson) {
        String warningMessage = (String)this.getMandatoryValueFromJson("message", stepJson);
        if (warningMessage.isEmpty()) {
            throw new MissingStepDataException("Warning message cannot be empty in the Add Warning step");
        }
        AddProcessWarningStep step = new AddProcessWarningStep(this.sourcePosition, new StepName(stepName), new Warning(warningMessage));
        JSONObject stepTerminationEvents = (JSONObject)this.getMandatoryValueFromJson("on", stepJson);
        step.setActionGroup(this.getActionGroupFromJson(stepTerminationEvents));
        return step;
    }

    protected AddInventoryStatusStep createAddInventoryStatusStep(String stepName, JSONObject stepJson) {
        InventoryStatusName status = this.getInventoryStatusName(stepJson);
        AddInventoryStatusStep step = new AddInventoryStatusStep(this.sourcePosition, new StepName(stepName), status);
        this.addActionGroup(stepJson, step);
        return step;
    }

    protected InventoryStatusName getInventoryStatusName(JSONObject stepJson) {
        String statusName = (String)this.getMandatoryValueFromJson("status", stepJson);
        if (statusName.isEmpty()) {
            throw new MissingStepDataException("Status cannot be empty in Add Inventory Step");
        }
        return new InventoryStatusName(statusName);
    }

    protected JoinStep createJoinStep(String stepName, JSONObject stepJson) {
        Optional<Object> startEvents;
        JoinStep step = new JoinStep(this.sourcePosition, new StepName(stepName));
        JSONObject eventJson = (JSONObject)this.getValueFromJson("on", stepJson);
        if (this.getOptionalValueFromJson("finish", eventJson).isPresent()) {
            StepActionFinish finishAction = new StepActionFinish(this.stepGraph.getFinishStep());
            step.addAction(finishAction);
        }
        if ((startEvents = this.getOptionalValueFromJson("start", eventJson)).isPresent()) {
            JSONArray targetSteps = (JSONArray)startEvents.get();
            for (int i = 0; i < targetSteps.length(); ++i) {
                String targetStepName = (String)this.getValueFromJsonArray(i, targetSteps);
                StepActionStart actionStart = new StepActionStart(new StepName(targetStepName));
                step.addAction(actionStart);
            }
        }
        return step;
    }

    public SwitchStep createSwitchStep(String stepName, JSONObject stepJson) {
        String switchCaseExpression = (String)this.getMandatoryValueFromJson("evaluate", stepJson);
        PropertyNameOrExpression switchExpression = PropertyNameOrExpression.create(switchCaseExpression);
        SwitchStep step = new SwitchStep(this.sourcePosition, new StepName(stepName), switchExpression);
        JSONObject switchCases = (JSONObject)this.getMandatoryValueFromJson("case", stepJson);
        if (switchCases.length() == 0) {
            throw new MissingStepDataException("There should be at least 1 case in a Switch Step");
        }
        Iterator kases = switchCases.keys();
        while (kases.hasNext()) {
            String kase = (String)kases.next();
            JSONObject kaseEvents = (JSONObject)this.getValueFromJson(kase, switchCases);
            if (kase.equalsIgnoreCase("default")) {
                SwitchStep.SwitchStepDefaultCase defaultKase = new SwitchStep.SwitchStepDefaultCase();
                step.setDefaultCase(Optional.of(defaultKase));
                this.addTargetsToKaseEvents(kaseEvents, defaultKase);
                continue;
            }
            SwitchStep.SwitchStepMatchCase userDefinedKase = new SwitchStep.SwitchStepMatchCase(new CaseMatch(kase));
            step.addMatchCase(userDefinedKase);
            this.addTargetsToKaseEvents(kaseEvents, userDefinedKase);
        }
        return step;
    }

    private void addTargetsToKaseEvents(JSONObject kaseEvents, SwitchStep.SwitchStepCase theKase) {
        Iterator kaseEventsKeys = kaseEvents.keys();
        while (kaseEventsKeys.hasNext()) {
            String kaseEvent = (String)kaseEventsKeys.next();
            JSONArray targets = (JSONArray)this.getValueFromJson(kaseEvent, kaseEvents);
            if (targets.length() == 0) continue;
            if (kaseEvent.equalsIgnoreCase("start")) {
                for (int i = 0; i < targets.length(); ++i) {
                    String target = (String)this.getValueFromJsonArray(i, targets);
                    StepActionStart startAction = new StepActionStart(new StepName(target));
                    theKase.addAction(startAction);
                }
                continue;
            }
            if (!kaseEvent.equalsIgnoreCase("finish")) continue;
            StepActionFinish stepActionFinish = new StepActionFinish(this.stepGraph.getFinishStep());
            theKase.addAction(stepActionFinish);
        }
    }

    protected ReleaseLockStep createReleaseLockStep(String stepName, JSONObject stepJson) {
        LockExpression lockExpression = this.getLockExpression(stepJson);
        ReleaseLockStep step = new ReleaseLockStep(this.sourcePosition, new StepName(stepName), lockExpression);
        this.addActionGroup(stepJson, step);
        return step;
    }

    protected AcquireLockStep createAcquireLockStep(String stepName, JSONObject stepJson) {
        LockExpression lockExpression = this.getLockExpression(stepJson);
        AcquireLockStep step = new AcquireLockStep(this.sourcePosition, new StepName(stepName), lockExpression);
        this.addActionGroup(stepJson, step);
        return step;
    }

    protected LockExpression getLockExpression(JSONObject stepJson) {
        String lockExpressionValue = (String)this.getMandatoryValueFromJson("lock", stepJson);
        if (lockExpressionValue.isEmpty()) {
            throw new MissingStepDataException("Lock Expression in Lock step cannot be blank");
        }
        return new LockExpression(lockExpressionValue);
    }

    public RunGenericProcessStep createGenericProcessStep(String stepName, JSONObject stepJson) {
        ProcessName processName = new ProcessName((String)this.getValueFromJson("process", stepJson));
        RunGenericProcessStep step = new RunGenericProcessStep(this.sourcePosition, new StepName(stepName), processName);
        Optional<Object> resourcePathOptional = this.getOptionalValueFromJson("resource-path", stepJson);
        String resourceOptional = resourcePathOptional.map(o -> (String)o).orElse("${p:resource.path}");
        step.setResourcePath(Optional.of(new ResourcePath(resourceOptional)));
        Optional<Object> ignoreChildWarningsOptional = this.getOptionalValueFromJson("ignore-child-warnings", stepJson);
        step.setIgnoreChildWarnings(ignoreChildWarningsOptional.map(o -> (boolean)((Boolean)o)).orElse(false));
        this.addActionGroup(stepJson, step);
        this.getOptionalValueFromJson("properties", stepJson).ifPresent(o -> this.addPropertiesToStep(step, (JSONObject)o));
        return step;
    }

    private void createStartStep(JSONObject stepJson) {
        JSONArray targetSteps = (JSONArray)this.getValueFromJson("start", stepJson);
        for (int i = 0; i < targetSteps.length(); ++i) {
            String targetStepName = (String)this.getValueFromJsonArray(i, targetSteps);
            if (!targetStepName.equalsIgnoreCase("finish")) {
                StepActionStart actionStart = new StepActionStart(new StepName(targetStepName));
                this.stepGraph.getStartStep().addAction(actionStart);
                continue;
            }
            StepActionFinish finish = new StepActionFinish(this.stepGraph.getFinishStep());
            this.stepGraph.getStartStep().addAction(finish);
        }
    }

    protected ComponentRunComponentProcessStep createComponentRunComponentProcessStep(String stepName, JSONObject stepJson) {
        ProcessName processName = new ProcessName((String)this.getValueFromJson("process", stepJson));
        ComponentRunComponentProcessStep step = new ComponentRunComponentProcessStep(this.sourcePosition, new StepName(stepName), processName);
        this.addActionGroup(stepJson, step);
        this.addProperties(stepJson, step);
        return step;
    }

    private void addProperties(JSONObject stepJson, PropertyContainer step) {
        Optional<Object> optionalProperties = this.getOptionalValueFromJson("properties", stepJson);
        optionalProperties.ifPresent(o -> this.addPropertiesToStep(step, (JSONObject)o));
    }

    public PluginStep createPluginStep(String stepName, JSONObject stepJson) {
        String pluginName = (String)this.getValueFromJson("plugin", stepJson);
        String commandName = (String)this.getValueFromJson("command", stepJson);
        PluginStep step = new PluginStep(this.sourcePosition, new StepName(stepName), new PluginName(pluginName), new PluginCommandName(commandName));
        JSONObject stepTerminationEvents = (JSONObject)this.getMandatoryValueFromJson("on", stepJson);
        ActionGroup actionGroup = this.getActionGroupFromJson(stepTerminationEvents);
        step.setActionGroup(actionGroup);
        Optional<Object> optionalProperties = this.getOptionalValueFromJson("properties", stepJson);
        if (!optionalProperties.isPresent()) {
            throw new MissingFormatArgumentException("Properties are mandatory for Plugin step as they contain only plugin step information");
        }
        this.addPropertiesToStep(step, (JSONObject)optionalProperties.get());
        this.getOptionalValueFromJson("postProcessingScript", stepJson).ifPresent(pps -> this.addPostProcessingProperties(step, (JSONObject)pps));
        return step;
    }

    private void addPostProcessingProperties(PluginStep step, JSONObject postProcessingProperties) {
        Iterator props = postProcessingProperties.keys();
        while (props.hasNext()) {
            String propName = (String)props.next();
            PropertyName propertyName = new PropertyName(propName);
            Object value = this.getValueFromJson(propName, postProcessingProperties);
            String valueAsString = this.getValueAsString(value, propName);
            PropertyExpression propertyExpression = new PropertyExpression(valueAsString);
            Property property = new Property(propertyName, propertyExpression);
            step.addPostProcessingProperty(property);
        }
    }

    private String getValueAsString(Object value, String propName) {
        String valueAsString;
        if (value instanceof JSONArray) {
            JSONArray array = (JSONArray)value;
            valueAsString = array.toString();
        } else if (value instanceof String) {
            if (!propName.equals(BODY) || !((String)value).startsWith(SCRIPT_FILE)) {
                valueAsString = (String)value;
            } else {
                ScriptInjector scriptInjector = new ScriptInjector();
                valueAsString = String.valueOf(scriptInjector.extractScriptBodyFromFile((String)value));
            }
        } else {
            throw new IllegalArgumentException("Unsupported value type for property: " + propName);
        }
        return valueAsString;
    }

    private void addPropertiesToStep(PropertyContainer step, JSONObject stepProperties) {
        Iterator props = stepProperties.keys();
        while (props.hasNext()) {
            String propName = (String)props.next();
            PropertyName propertyName = new PropertyName(propName);
            String value = (String)this.getValueFromJson(propName, stepProperties);
            PropertyExpression propertyExpression = new PropertyExpression(value);
            Property property = new Property(propertyName, propertyExpression);
            step.addProperty(property);
        }
    }

    private ActionGroup getActionGroupFromJson(JSONObject stepTerminationEvents) {
        Iterator events = stepTerminationEvents.keys();
        ActionGroup actionGroup = new ActionGroup();
        while (events.hasNext()) {
            ActionsOnEvent eventTypeAction;
            String event = (String)events.next();
            if (event.equalsIgnoreCase("success")) {
                eventTypeAction = new ActionsOnEvent(ActionsOnEvent.Event.SUCCESS);
                actionGroup.setActionsOnSuccess(Optional.of(eventTypeAction));
            } else if (event.equalsIgnoreCase("failure")) {
                eventTypeAction = new ActionsOnEvent(ActionsOnEvent.Event.FAILURE);
                actionGroup.setActionsOnFailure(Optional.of(eventTypeAction));
            } else if (event.equalsIgnoreCase("always") || event.equalsIgnoreCase("complete")) {
                eventTypeAction = new ActionsOnEvent(ActionsOnEvent.Event.COMPLETE);
                actionGroup.setActionsOnComplete(Optional.of(eventTypeAction));
            } else {
                throw new RuntimeException("Unsupported event Type " + event);
            }
            this.addStepActionsToEvent(eventTypeAction, (JSONObject)this.getValueFromJson(event, stepTerminationEvents));
        }
        return actionGroup;
    }

    private void addStepActionsToEvent(ActionsOnEvent actionsOnEvent, JSONObject eventActions) {
        Iterator actions = eventActions.keys();
        while (actions.hasNext()) {
            String action = (String)actions.next();
            if (action.equalsIgnoreCase("start")) {
                JSONArray targetSteps = (JSONArray)this.getValueFromJson("start", eventActions);
                for (int i = 0; i < targetSteps.length(); ++i) {
                    actionsOnEvent.addAction(new StepActionStart(new StepName((String)this.getValueFromJsonArray(i, targetSteps))));
                }
                continue;
            }
            if (!action.equalsIgnoreCase("finish")) continue;
            actionsOnEvent.addAction(new StepActionFinish(this.stepGraph.getFinishStep()));
        }
    }

    private JSONObject getStepDataFor(String stepName) {
        try {
            return (JSONObject)this.userJson.get(stepName);
        }
        catch (JSONException e) {
            throw new MissingStepDataException("Unable to find step definition for step " + stepName);
        }
    }

    private void validations() throws ParseException {
        new CheckStepNameUniquenessProcessor().process(this.stepGraph);
        new CheckStepAnchorUniquenessProcessor().process(this.stepGraph);
        new CheckPropertyNameUniquenessProcessor().process(this.stepGraph);
        new CheckPropertyDefinitionNameUniquenessProcessor().process(this.stepGraph);
        new CheckPropertyDefinitionDefaultsAgainstPatternsProcessor().process(this.stepGraph);
        new PopulateStepByNameMapProcessor().process(this.stepGraph);
        new PopulateStepByAnchorMapProcessor().process(this.stepGraph);
        new CheckMissingActionTargetProcessor().process(this.stepGraph);
        new CheckNoOrphansProcessor().process(this.stepGraph);
        new CheckNoCyclesProcessor().process(this.stepGraph);
    }

    Object getValueFromJson(String key, JSONObject json) {
        try {
            return json.get(key);
        }
        catch (JSONException e) {
            if (!e.getMessage().contains("JSONObject[\"start\"] not found")) {
                throw new RuntimeException(e);
            }
            ErrorHandler.printErrorAndExit(e.getMessage() + " Process design is incomplete as there are no plugin steps other than start and finish. Please verify!");
            return null;
        }
    }

    Optional<Object> getOptionalValueFromJson(String key, JSONObject json) {
        try {
            Object obj = json.get(key);
            return Optional.of(obj);
        }
        catch (JSONException e) {
            return Optional.empty();
        }
    }

    Object getValueFromJsonArray(int index, JSONArray array) {
        try {
            return array.get(index);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    Object getMandatoryValueFromJson(String key, JSONObject json) {
        Optional<Object> obj = this.getOptionalValueFromJson(key, json);
        if (obj.isPresent()) {
            return obj.get();
        }
        throw new MissingStepDataException("Missing data for " + key + " in json " + json);
    }

    private String getRollbackTypeString(JSONObject stepJson) {
        String rollbackTypeString = ((String)this.getValueFromJson("rollback-type", stepJson)).equalsIgnoreCase("remove-undesired-incremental-versions") ? "UNDESIRED" : "LAST_DEPLOYED";
        return rollbackTypeString;
    }

    private void setMiscellaneousSettingsForAppMultiComp(JSONObject stepJson, AppMultiComponentStep step) {
        this.setMiscellaneousSettingsForAppProcess(stepJson, step);
        String maxConcurrentComponents = String.valueOf(this.getValueFromJson("max-concurrent-components", stepJson));
        step.setMaxConcurrentComponents(Concurrency.createFromJsonString(maxConcurrentComponents));
    }

    private void setMiscellaneousSettingsForAppProcess(JSONObject stepJson, AppProcessResourceStep step) {
        Optional<Object> failFastOptional = this.getOptionalValueFromJson("fail-fast", stepJson);
        step.setFailFast(failFastOptional.map(o -> (boolean)((Boolean)o)).orElse(false));
        Optional<Object> ignoreChildWarningsOptional = this.getOptionalValueFromJson("ignore-child-warnings", stepJson);
        step.setIgnoreChildWarnings(ignoreChildWarningsOptional.map(o -> (boolean)((Boolean)o)).orElse(false));
        step.setMaxConcurrentProcesses(this.getMaxConcurrentProcesses(stepJson));
    }

    private Concurrency getMaxConcurrentProcesses(JSONObject stepJson) {
        return this.getConcurrency(stepJson, "max-concurrent-processes");
    }

    private Concurrency getMaxConcurrentAgents(JSONObject stepJson) {
        return this.getConcurrency(stepJson, "max-concurrent-agents");
    }

    private Concurrency getMaxConcurrentTags(JSONObject stepJson) {
        return this.getConcurrency(stepJson, "max-concurrent-tags");
    }

    private Concurrency getMaxConcurrentComponents(JSONObject stepJson) {
        return this.getConcurrency(stepJson, "max-concurrent-components");
    }

    private Concurrency getConcurrency(JSONObject stepJson, String concurrencyType) {
        int maxConcurrentProcesses = -1;
        Optional<Object> optionalConcurrencyProcess = this.getOptionalValueFromJson(concurrencyType, stepJson);
        if (optionalConcurrencyProcess.isPresent()) {
            maxConcurrentProcesses = (Integer)optionalConcurrencyProcess.get();
        }
        return Concurrency.createFromJsonString(String.valueOf(maxConcurrentProcesses));
    }

    private String getUninstallVersionType(JSONObject stepJson) {
        String uninstallVersionsType = ((String)this.getValueFromJson("select-versions", stepJson)).equalsIgnoreCase("selected-with-process") ? "selected" : "ALL_EXISTING";
        return uninstallVersionsType;
    }

    private void addActionGroup(JSONObject stepJson, ActionGroupStep step) {
        JSONObject stepTerminationEvents = (JSONObject)this.getMandatoryValueFromJson("on", stepJson);
        ActionGroup actionGroup = this.getActionGroupFromJson(stepTerminationEvents);
        step.setActionGroup(actionGroup);
    }

    private String getTagId(String url, String tagName) {
        String tagId;
        String response;
        ServerDataGetter dataGetter = ServerDataGetter.getDataGetter();
        try {
            response = dataGetter.getDataFromServer(url);
        }
        catch (ServerDataGetter.MissingDataException e) {
            throw new RuntimeException(e);
        }
        try {
            tagId = this.getTagIdFromResponse(response, tagName);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return tagId;
    }

    private String getTagIdFromResponse(String response, String tagName) throws JSONException {
        JSONArray tagArr = new JSONArray(response);
        for (int i = 0; i < tagArr.length(); ++i) {
            JSONObject tagObj = tagArr.getJSONObject(i);
            if (!tagObj.getString("name").equals(tagName)) continue;
            return tagObj.getString("id");
        }
        return null;
    }

    static class InvalidStepDataException
    extends RuntimeException {
        InvalidStepDataException(String message) {
            super(message);
        }
    }

    static class MissingStepDataException
    extends RuntimeException {
        MissingStepDataException(String message) {
            super(message);
        }
    }
}

