/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.upload;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import javax.json.Json;
import javax.json.JsonObject;
import ucd.pacc.main.ServerDataGetter;
import ucd.pacc.model.StepGraph;
import ucd.pacc.parser.ParseException;
import ucd.pacc.parser.ParseSink;
import ucd.pacc.parser.ParseSource;
import ucd.pacc.upload.GraphJsonBuilder;
import ucd.pacc.upload.StepGraphBuilder;
import ucd.pacc.upload.Translator;
import ucd.pacc.upload.TranslatorOptions;
import ucd.pacc.upload.UploaderOptions;

public class Uploader
implements Translator {
    private final ParseSource source;
    private final ParseSink sink;
    private final TranslatorOptions options;

    public Uploader(ParseSource source, ParseSink sink, TranslatorOptions options) {
        this.source = source;
        this.source.getClass();
        this.sink = sink;
        this.sink.getClass();
        this.options = options;
        this.options.getClass();
    }

    @Override
    public void translate() throws IOException, ParseException {
        StepGraphBuilder builder = new StepGraphBuilder(this.source);
        StepGraph graph = builder.buildStepGraphFromUserJsonFormat();
        GraphJsonBuilder graphBuilder = new GraphJsonBuilder();
        if (this.options instanceof UploaderOptions) {
            graphBuilder.setComment(((UploaderOptions)this.options).getComment());
            String url = ((UploaderOptions)this.options).getUrl();
            String password = ((UploaderOptions)this.options).getPassword();
            String username = ((UploaderOptions)this.options).getUsername();
            ServerDataGetter.getServerDataGetter(username, password, url);
        }
        graphBuilder.process(graph);
        JsonObject json = graphBuilder.getJson();
        Writer out = this.sink.getWriter();
        Json.createWriterFactory(Collections.singletonMap("javax.json.stream.JsonGenerator.prettyPrinting", null)).createWriter(out).writeObject(json);
        out.write("\n");
    }
}

