/*
 * Decompiled with CFR 0.152.
 */
package ucd.pacc.util.processconfiguration;

import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonObject;
import ucd.pacc.download.PropertyDefinitionBuilder;
import ucd.pacc.model.ProcessConfigurations;
import ucd.pacc.model.PropertyDefinition;
import ucd.pacc.util.JsonDataFinder;
import ucd.pacc.util.JsonUtil;

public abstract class ProcessConfigurationBuilder {
    JsonObject jsonObject;
    String json;
    private PropertyDefinitionBuilder builder = new PropertyDefinitionBuilder();

    public ProcessConfigurations generateConfigurations(String json) {
        this.json = json;
        ProcessConfigurations config = this.build();
        this.jsonObject = Json.createReader((Reader)new StringReader(json)).readObject();
        config.setPropertyDefinitions(this.getPropertyDefinitionsFromJson());
        this.getDescriptionFromString().ifPresent(config::setDescription);
        return config;
    }

    abstract ProcessConfigurations build();

    List<PropertyDefinition> getPropertyDefinitionsFromJson() {
        JsonUtil util = new JsonUtil();
        return this.builder.build(this.jsonObject, util).collect(Collectors.toList());
    }

    Optional<String> getDescriptionFromString() {
        Optional<Object> data = JsonDataFinder.findDataInJson(this.json, "$.description");
        return data.map(o -> (String)o);
    }
}

