<?php
/****************************************************************
* IBM Confidential
*
* SFA100-Collaboration Source Materials
*
* (C) Copyright IBM Corp. 2015
*
* The source code for this program is not published or otherwise
* divested of its trade secrets, irrespective of what has been
* deposited with the U.S. Copyright Office
*
* **************************************************************/

/**
 * APIs for agent requests via UcdClient
 *
 * @author Felice Geracitano.......feliecege@ie.ibm.com
 *
 */


class AgentUdclientApi extends AbstractApi{
    
    /**
     * Get agent passing Id or Name
     * @param string $agent
     * @return string
     *
     */
    public function getAgent($agent = null) {
        if ($this->return == 'file') {
            $this->destination = " > '{$this->output}/{$agent}.json'";
        }
        $action = "getAgent -agent {$agent}{$this->destination}";
        return $this->exec($action);
    }
    
    /**
     * Get AgentPool passing pool as parameter
     * 
     * @param string        $pool
     * @return string
     *
     */
    public function getAgentPool($pool = null) {
        if ($this->return == 'file') {
            $this->destination = " > '{$this->output}/{$pool}.json'";
        }
        $action = "getAgentPool -pool {$pool}{$this->destination}";
        return $this->exec($action);
    }
    
    /**
     * Get Agents Pool with active or inactive filter
     * @param bool $active
     * @param bool $inactive
     * @return string
     */
    public function getAgentPools($active = null, $inactive = null) {
        if (! is_bool( $active )) {
            $active = true;
        }
        if (! is_bool( $inactive )) {
            $inactive = true;
        }
        $active = ' -active ' . $active;
        $inactive = ' -inactive ' . $inactive;
        
        if ($this->return == 'file') {
            $this->destination = " > '{$this->output}/agentPools.json'";
        }
        $action = "getAgentPools{$active}{$inactive}{$this->destination}";
        return $this->exec( $action );
    }
    
    /**
     * Get agent property passing Agent Id|Name and property name
     * 
     * @param string        $agent
     * @param string        $property
     * @return string
     *
     */
    public function getAgentProperty($agent = null, $property = null) {
        if ($this->return == 'file') {
            $this->destination = " > '{$this->output}/{$agent}.{$property}.json'";
        }
        $action = "getAgentProperty -agent {$agent} -name {$property}{$this->destination}";
        return $this->exec($action);
    }

    /**
     * Get Agent list passing active and inactive filter
     * 
     * @param bool        $active
     * @param bool        $inactive
     * @return string
     *
     */
    public function getAgents($active = null, $inactive = null) {
        if (! is_bool( $active )) {
            $active = true;
        }
        if (! is_bool( $inactive )) {
            $inactive = true;
        }
        $active_str = ($active) ? 'true' : 'false';
        $active = ' -active '.$active_str;
        $inactive_str = ($inactive) ? 'true' : 'false';
        $inactive = ' -active '.$inactive_str;
    
        if ($this->return == 'file') {
            $this->destination = " > '{$this->output}/agents.json'";
        }
        $action = "getAgents{$active}{$inactive}{$this->destination}";
        return $this->exec($action);
    }
}