<?php
/**
 * Set the string to be used to identify if data needs to be cleaned or not.
 * 
 * Values set for 
 *   - application,
 *   - component,
 *   - applicationProcess,
 *   - componentProcess,
 *   - genericProcess,
 *   - postProcessScript
 *  have precendence over 'default' value.
 *  
 * "Exclude" rules have precedence over "Include" rules.
 * 
 * Position can be:
 *   - "start" (string should be at the beginning of the name),
 *   - "end" (string at the end of the name),
 *   - empty (string can be in any part of the name).
 */

/* Include in clean */
$config['clean']['include']['rule'] = 
    array(
        'default' => '.DEV',
        'application' => '',
        'component' => '',
        'applicationProcess' => '',
        'componentProcess' => '',
        'genericProcess' => '',
        'postProcessScript' => ''
);
$config['clean']['include']['position'] = '';

/* Exclude from clean */
$config['clean']['exclude']['rule'] = 
    array(
        'default' => '',
        'application' => '',
        'component' => '',
        'applicationProcess' => '',
        'componentProcess' => '',
        'genericProcess' => '',
        'postProcessScript' => ''
);
$config['clean']['exclude']['position'] = '';