<?php
/****************************************************************
* IBM Confidential
*
* SFA100-Collaboration Source Materials
*
* (C) Copyright IBM Corp. 2015
*
* The source code for this program is not published or otherwise
* divested of its trade secrets, irrespective of what has been
* deposited with the U.S. Copyright Office
*
* **************************************************************/

/**
 * API for component requests via UcdClient
 *
 * @author Felice Geracitano.......feliecege@ie.ibm.com
 */
class ComponentUdclientApi extends AbstractApi{
    
    /**
     * Add a component to an application
     *
     * @param string        $component
     * @param string        $application
     * @return boolean|string
     */
    public function addComponentToApplication ($component = null, $application = null){
        if (empty($application)){
            $application = $this->application;
        }
        $action = "addComponentToApplication -component '{$component}' -application '{$application}'";
        return $this->exec($action);
    }
    
    /**
     *
     * Associate a team to a component
     *
     * @param string $component
     * @param string $team
     * @return boolean|string
     */
    public function addComponentToTeam( $component = null, $team = null ) {
        $action = "addComponentToTeam -component '{$component}' -team '{$team}'";
        return $this->exec($action);
    }
    
    /**
     *
     * Enter description here ...
     *
     * @param string $component
     * @param string $tag
     * @param string $color
     * @param string $description
     */
    public function addTagToComponent($component = null, $tag = null, $color = null, $description = null) {
        $optional = '';
        if (!empty($color)){
            $optional .= " -color {$color}";
        }
        if (!empty($description)) {
            $optional .= " -description {$description}";
        }
    
        $action = "addTagToComponent -component '{$component}' -tag '{$tag}'{$optional}";
        return $this->exec($action);
    }
    
    /**
     * Create a component from a json file
     *
     * @param string     $component
     */
    public function createComponent($component = null) {
        $action = "createComponent '{$component}'";
        return $this->exec($action);
    }
    
    /**
     *
     * Creates a component process from a json file
     *
     * @param string     $component
     * @param string     $process
     * @return boolean|string
     */
    public function createComponentProcess($component = null, $process = null) {
        // Get process content and turn it into an array
        $process_content = json_decode(file_get_contents($process));
        $process_content->component = $component;
        $process_content = json_encode($process_content);
    
        if (Utils::writeToFile($process, $process_content)) {
            $action = "createComponentProcess '{$process}'";
            return $this->exec($action);
        } else {
            return false;
        }
    }
    
    /**
     *
     * Create a new version for the component
     *
     * @param string    $component
     * @param string    $versionName
     * @param string    $description
     * @return boolean|string
     */
    public function createVersion($component = null, $versionName= null, $description = null) {
        if (!empty($description)){
            $description = " -description {$description}";
        } else {
            $description = '';
        }
    
        if ($this->return == 'file') {
            $this->destination = " > {$this->output}/{$component}.{$versionName}.json";
        }
    
        $action = "createVersion -component '{$component}' -name {$versionName}{$description} {$this->destination}";
        return $this->exec($action);
    }
    
    /**
     * @param string    $component
     * @return string
     *
     * Will return false if argument is incorrect
     */
    public function getComponent($component = null){
        if ($this->return == 'file') {
            $this->destination = " > '{$this->output}/{$component}.json'";
        }
        $action = "getComponent -component '{$component}'{$this->destination}";
        return $this->exec($action);
    }
    
    /**
     * @param string        $component
     * @param string        $environment
     * @param string        $application
     * @return string
     *
     * Will return false if argument is incorrect
     */
    public function getComponentEnvironmentProperties($component = null, $environment = null, $application = null){
        if (empty($environment)){
                $environment = $this->environment;
        }
        if (empty($application)){
                $application = $this->application;
        }
        if ($this->return == 'file') {
            $this->destination = " > '{$this->output}/{$environment}.{$component}.properties.json'";
        }
        $action = "getComponentEnvironmentProperties -component '{$component}' -environment '{$environment}' -application {$application}{$this->destination}";
        return $this->exec($action);
    }
    
    /**
     * @param string    $component
     * @param string    $process
     * @return string
     *
     * Will return false if argument is incorrect
     */
    public function getComponentProcess($component = null, $process = null){
        if ($this->return == 'file') {
            $this->destination = " > '{$this->output}/{$component}.{$process}.json'";
        }
        $action = "getComponentProcess -component '{$component}' -componentProcess {$process}{$this->destination}";
        return $this->exec($action);
    }
    
    /**
     * @param string        $component
     * @return string
     *
     * Will return false if argument is incorrect
     */
    public function getComponentProperties($component = null){
        if ($this->return == 'file') {
            $this->destination = " > '{$this->output}/{$environment}.{$component}.properties.json'";
        }
        $action = "getComponentProperties -component '{$component}'{$this->destination}";
        return $this->exec($action);
    }
    
    /**
     * @param string        $component
     * @param string        $property
     * @return string
     *
     * Will return false if argument is incorrect
     */
    public function getComponentProperty($component = null, $property = null){
        if ($this->return == 'file') {
            $this->destination = " > '{$this->output}/{$component}.{$property}.json'";
        }
        $action = "getComponentProperty -component '{$component}' -name {$property}{$this->destination}";
        return $this->exec($action);
    }
    
    /**
     * @return string
     * Will return components
     */
    public function getComponents(){
        if ($this->return == 'file') {
            $this->destination = " > '{$this->output}/components.json'";
        }
        $action = "getComponents{$this->destination}";
        return $this->exec($action);
    }
    
    /**
     * @param string    $application
     * @return string
     *
     * Will return false if argument is incorrect
     */
    public function getComponentsInApplication($application = null){
        if (empty($application)){
            $application = $this->application;
        }
        if ($this->return == 'file') {
            $this->destination = " > '{$this->output}/{$application}.components.json'";
        }
        $action = "getComponentsInApplication -application {$application}{$this->destination}";
        return $this->exec($action);
    }
}
