<?php
/****************************************************************
* IBM Confidential
*
* SFA100-Collaboration Source Materials
*
* (C) Copyright IBM Corp. 2015
*
* The source code for this program is not published or otherwise
* divested of its trade secrets, irrespective of what has been
* deposited with the U.S. Copyright Office
*
* **************************************************************/

/**
 * API for snapsoht requests via UcdClient
 *
 * @author Felice Geracitano.......feliecege@ie.ibm.com
 *
 */
class SnapshotUdclientApi extends AbstractApi {
	
    /**
     *
     * Creates a snapshot using a json file
     *
     * @param string $args
     * @return string
     */
    public function createSnapshot($file = null){
        $action = "createSnapshot '{$file}'";
        return $this->exec($action);
    }
    
    /**
     *
     * Creates a snapshot of an environment with name and description. Udclient call will return a json response.
     *
     * @param string $environment
     * @param string $name
     * @param string $description   optional
     * @param string $application   optional
     * @return string
     */
    public function createSnapshotOfEnvironment($environment = null, $name = null, $description = null, $application = null){
        if (empty($environment)) {
                $environment = $this->environment;
        }
        if (!empty($this->application)) {
                $application = " -application {$this->application}";
        }
    
        $action = "createSnapshotOfEnvironment -environment {$environment} -name {$name}{$description}{$application}";
        return $this->exec($action);
    }
    
    /**
     *
     *
     * Returns a snapshot
     *
     * @param string Application Name
     * @param string Snapshot Name
     * @return boolean string
     */
    public function getSnapshot($applicationName = null, $snapShotName = null) {
        if (empty( $applicationName )) {
                $applicationName = $this->application;
        }
        if ($this->return == 'file') {
            $this->destination = "> '{$this->output}/{$applicationName}.{$snapShotName}.json'";
        }
        $action = "getSnapshot -application {$applicationName} -snapshot {$snapShotName}{$this->destination}";
        return $this->exec( $action );
    }
    
}
