<?php
/****************************************************************
 * IBM Confidential
 *
 * SFA100-Collaboration Source Materials
 *
 * (C) Copyright IBM Corp. 2014
 *
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has been
 * deposited with the U.S. Copyright Office
 *
 ***************************************************************/
/**
 * Layer for rest Apis calls in entryPoint of Ucommand
 *
 * @author Felice Geracitano.......feliecege@ie.ibm.com
 */

require_once ('rest/ApplicationRestApi.php');
require_once ('rest/ComponentRestApi.php');
require_once ('rest/EnvironmentRestApi.php');
require_once ('rest/ProcessRestApi.php');
require_once ('rest/ResourcesRestApi.php');
require_once ('rest/SnapshotRestApi.php');
require_once ('rest/SystemRestApi.php');

class Rest implements ApiInterface {
    protected $alias;
    protected $config;
    protected $dir;
    protected $objects;
    protected $logout;
    protected $return;
    
    public function __construct() {
        $this->objects = array (
            'application' => null,
            'component' => null,
            'environment' => null,
            'process' => null,
            'resource' => null,
            'snapshot' => null,
            'system' => null 
        );
    }
    
    /**
     *  Get Application Rest APIs
     *  @return object
     */
    public function application() {
        if (empty( $this->objects['application'] )) {
            $this->objects['application'] = new ApplicationRestApi();
            $this->set($this->objects['application']);
        }
        return $this->objects['application'];
    }
    
    /**
     *  Get Component Rest APIs
     *  @return object
     */
    public function component() {
        if (empty( $this->objects['component'] )) {
            $this->objects['component'] = new ComponentRestApi();
            $this->set($this->objects['component']);
        }
        return $this->objects['component'];
    }
    
    /**
     *  Get Component Rest APIs
     *  @return object
     */
    public function environment() {
        if (empty( $this->objects['environment'] )) {
            $this->objects['environment'] = new EnvironmentRestApi();
            $this->set($this->objects['environment']);
        }
        return $this->objects['environment'];
    }
    
    /**
     *  Get Component Rest APIs
     *  @return object
     */
    public function process() {
        if (empty( $this->objects['process'] )) {
            $this->objects['process'] = new ProcessRestApi();
            $this->set($this->objects['process']);
        }
        return $this->objects['process'];
    }
    
    /**
     *  Get Component Rest APIs
     *  @return object
     */
    public function resource() {
        if (empty( $this->objects['resource'] )) {
            $this->objects['resource'] = new ResourcesRestApi();
            $this->set($this->objects['resource']);
        }
        return $this->objects['resource'];
    }
    
    /**
     *  Set Api objcet with father paramters if needed
     *  @return object
     */
    public function set($api) {
        if (isset( $this->dir )) {
            $api->setOutput( $this->dir, false );
        }
        if (isset( $this->return )) {
            $api->setReturn( $this->return );
        }
        if (isset( $this->server ) && isset( $this->config )) {
            $api->setupServer( $this->server, $this->config, false, $this->logout );
        }
        // setupAlias set alias parameter in Api object
        // and return a config array unuseful here
        if (isset( $this->alias )) {
            $api->setupAlias( $this->alias );
        }
    }
    
    /**
     *  Set output for all Apis object already created
     *  and set dir value in the layer class
     */
    public function setOutput( $dir, $message = false ) {
        $this->dir = $dir;
        foreach ( $this->objects as $key => $value ) {
            if ( !empty ($this->objects[$key] )) {
            $this->objects[$key]->setOutput($this->dir, $message);
            }
        }
    }
    
    /**
     * Set Return for all Apis object already created
     * and set return value in the layer class
     */
    public function setReturn($type) {
        $this->return = $type;
        foreach ( $this->objects as $key => $value ) {
            if (! empty( $this->objects [$key] )) {
                $this->objects [$key]->setReturn( $this->return );
            }
        }
    }
    
    /**
     * Set Alias for all Apis object already created
     * and set alias value in the layer class
     */
    public function setupAlias($alias) {
        $this->alias = $alias;
        foreach ( $this->objects as $key => $value ) {
            if (! empty( $this->objects [$key] )) {
                // setupAlias set alias parameter in Api object
                // and return a config array unuseful here
                // to connect to alias sever need setupServer
                $this->objects[$key]->setupAlias( $this->alias );
            }
        }
    }
    
    /**
     * Set Server for all Apis object already created
     * and set alias value in the layer class
     */
    public function setupServer($server, $config, $message = false, $logout) {
        $return = null;
        $this->server = $server;
        $this->config = $config;
        $this->logout = $logout;
        foreach ( $this->objects as $key => $value ) {
            if (! empty( $this->objects [$key] )) {
                $return = $this->objects [$key]->setupServer( $this->server, $this->config, $message, $this->logout );
                
            }
        }
        if ($return === null){
        	// create an api to test connection
        	$return = $this->application()->setupServer($this->server, $this->config, $message, $this->logout);
        }
        return $return;
    }
    
    /**
     *  Get Component Rest APIs
     *  @return object
     */
    public function snapshot() {
        if (empty( $this->objects['snapshot'] )) {
            $this->objects['snapshot'] = new SnapshotRestApi();
            $this->set($this->objects['snapshot']);
        }
        return $this->objects['snapshot'];
    }
    
    /**
     *  Get Component Rest APIs
     *  @return object
     */
    public function system() {
        if (empty( $this->objects['system'] )) {
            $this->objects['system'] = new SystemRestApi();
            $this->set($this->objects['system']);
        }
        return $this->objects['system'];
    }
}