<?php
/****************************************************************
* IBM Confidential
*
* SFA100-Collaboration Source Materials
*
* (C) Copyright IBM Corp. 2015
*
* The source code for this program is not published or otherwise
* divested of its trade secrets, irrespective of what has been
* deposited with the U.S. Copyright Office
*
* **************************************************************/

/**
 * API for snapsoht requests via REST
 *
 * @author Felice Geracitano.......feliecege@ie.ibm.com
 */
class SnapshotRestApi extends AbstractApi {
    /**
     *
     * Add snapshot status passing snapshot ID and status
     *
     * @param string snapshot ID
     * @param string status
     * @return string
     */
    public function addSnapshotStatus($snapshotId = null, $status = null){
        $json = '{"status":"'.$status.'"}';
        $action = "-X PUT ";
        $action .= '-H "Content-Type: application/json" ';
        $action .= "{$this->weburl}/rest/deploy/snapshot/{$snapshotId}/status/{$status} -d '{$json}'";
        return $this->execRest($action);
    }
    
    /**
     *
     * Export a snapshot passing snapshot Id and application name,
     * snapshot name is not mandatory to name the output file
     *
     * @param string snapshot ID
     * @param string $application
     * @param string $snapshotName
     * @return string
     */
    
    public function exportSnapshot($snapshot = null, $application = null, $snapshotName = null) {
        if (empty($application)){
                $application = $this->application;
        }
        if (empty($snapshotName)){
            $snapshotName = $snapshot;
        }
        if ($this->return == 'file') {
            $this->destination = " > '{$this->output}/{$application}.{$snapshotName}.zip'";
        }
        $action = "{$this->weburl}/rest/deploy/application/{$application}/exportWithArtifacts?snapshotIds={$snapshot}{$this->destination}";
        return $this->execRest($action);
    }
    
    /**
     *
     * Returns all the snapshots for an application
     *
     * @param unknown $application
     * @return string
     */
    public function getSnapshotsInApplication($application = null) {
        if (empty($application)){
            $application = $this->application;
        }
        if ($this->return == 'file') {
            $this->destination = "> '{$this->output}/{$application}.snapshots.json'";
        }
        $action = $this->weburl . "/rest/deploy/application/{$application}/snapshots/false?sortType=desc {$this->destination}";
        return $this->execRest($action);
    }
    
    /**
     *
     * Import a snapshot using a zip file
     *
     * @param string $application
     * @param string $file
     * @return string
     */
    public function importSnapshot($application = null, $file = null){
        if (empty($application)){
                $application = $this->application;
        }
        $action = "-X POST ";
        $action .= "{$this->weburl}/rest/deploy/snapshot/importWithArtifacts/{$application}";
        $action .= ' -H "Content-Type: multipart/form-data"';
        $action .= " -F file=@'{$file}'";
        // Return
        return $this->execRest($action);
    }
    
    /**
     *
     * Set snapshot name passing json descriptor
     *
     * @param string json description of a snapshot
     * @return boolean
     */
    public function setSnapshotName($snapshotJson = null){
        $action = "-X PUT ";
        $action .= '-H "Content-Type: application/json" ';
        $action .= "{$this->weburl}/rest/deploy/snapshot -d '{$snapshotJson}'";
        return $this->execRest($action);
    }
    
}
