<?php
/****************************************************************
* IBM Confidential
*
* SFA100-Collaboration Source Materials
*
* (C) Copyright IBM Corp. 2015
*
* The source code for this program is not published or otherwise
* divested of its trade secrets, irrespective of what has been
* deposited with the U.S. Copyright Office
*
* **************************************************************/

/**
 * API for application requests via UcdClient
 *
 * @author Felice Geracitano.......feliecege@ie.ibm.com
 */

class ApplicationUdclientApi extends AbstractApi{
    /**
     * Create an application from a json file
     *
     * @param string     $application
     */
    public function createApplication($application = null) {
        $action = "createApplication '{$application}'";
        return $this->exec($action);
    }
    
    public function createApplicationProcess($appProcessFile = null) {
        // @TODO: make sure that the AppProcess backup file, holds CORRECT Application ID
    
        $action = "createApplicationProcess '{$appProcessFile}'";
        return $this->exec($action);
    }
    
    /**
     * @param string    $application
     * @return string
     *
     * Will return false if argument is incorrect
     */
    public function getApplication($application = null){
        if ($this->return == 'file') {
            $this->destination = " > '{$this->output}/{$application}.json'";
        }
        $action = "getApplication -application {$application}{$this->destination}";
        return $this->exec($action);
    }
    
    /**
     * @param string        $application
     * @param string        $process
     * @return string
     *
     * Will return false if argument is incorrect
     */
    public function getApplicationProcess($application = null, $process = null) {
        if ($this->return == 'file') {
            $this->destination = " > '{$this->output}/{$process}.json'";
        }
        $action = "getApplicationProcess -application '{$application}' -applicationProcess '{$process}'{$this->destination}";
        return $this->exec($action);
    }
    
    /**
     * @param string        $processRequest
     * @return string
     *
     * Will return false if argument is incorrect
     */
    public function getApplicationProcessRequestStatus($processRequest = null) {
        if ($this->return == 'file') {
            $this->destination = " > '{$this->output}/{$processRequest}.json'";
        }
        $action = "getApplicationProcessRequestStatus -request {$processRequest}{$this->destination}";
        return $this->exec($action);
    }
    
    /**
     * @param string        $application
     * @return string
     *
     * Will return false if argument is incorrect
     */
    public function getApplicationProperties($application = null) {
        if ($this->return == 'file') {
            $this->destination = " > '{$this->output}/{$application}.properties.json'";
        }
        $action = "getApplicationProperties -application {$application}{$this->destination}";
        return $this->exec($action);
    }
    
    /**
     * @param string        $application
     * @param string        $property
     * @return string
     *
     * Will return false if argument is incorrect
     */
    public function getApplicationProperty($application = null, $property = null) {
        if ($this->return == 'file') {
            $this->destination = " > '{$this->output}/{$application}.{$property}.json'";
        }
        $action = "getApplicationProperty -application {$application} -name {$property}{$this->destination}";
        return $this->exec($action);
    }
    
    /**
     * Gel all application in uDeploy
     */
    public function getApplications(){
        if ($this->return == 'file') {
            $this->destination = " > '{$this->output}/applications.json'";
        }
        $action = "getApplications{$this->destination}";
        return $this->exec($action);
    }
    
    
    /**
     *
     * Run application process
     *
     * @param string $process   Path to template json file
     * @return boolean|string
     */
    public function requestApplicationProcess($process = null){
        if ($this->return == 'file') {
            $this->destination = " > '{$this->output}/{$version}.links.json'";
        }
        $action = "requestApplicationProcess '{$process}'{$this->destination}";
        return $this->exec($action);
    }
}