<?php
/****************************************************************
* IBM Confidential
*
* SFA100-Collaboration Source Materials
*
* (C) Copyright IBM Corp. 2015
*
* The source code for this program is not published or otherwise
* divested of its trade secrets, irrespective of what has been
* deposited with the U.S. Copyright Office
*
* **************************************************************/

/**
 * APIs for system requests via UcdClient
 *
 * @author Felice Geracitano.......feliecege@ie.ibm.com
 *
 */
class SystemUdclientApi extends AbstractApi {
    
    /**
     * @param string        $blueprint
     * @return string
     *
     * Will return false if argument is incorrect
     */
    public function getBlueprintNodePropertiesTemplate($blueprint = null) {
        if (!empty($this->application)){
            $application = ' -application '.$this->application;
        } else {
            $application = '';
        }
        if ($this->return == 'file') {
            $this->destination = " > '{$this->output}/{$blueprint}.json'";
        }
        $action = "getBlueprintNodePropertiesTemplate -blueprint {$blueprint}{$application}{$this->destination}";
        return $this->exec($action);
    }
    
    /**
     * @param string    $status
     * @param string    $type       optional
     * @return string
     *
     * Will return false if argument is incorrect
     */
    public function getStatus($status = null, $type = null){
        $validTypes = array('inventory','version','snapshot');
        if (in_array($type,$validTypes)){
            $type = ' -type ' . $type;
        } else {
            $type = '';
        }
        if ($this->return == 'file') {
            $this->destination = " > '{$this->output}/{$component}.{$status}.json'";
        }
        $action = "getStatus -status {$status}{$type}{$this->destination}";
        return $this->exec($action);
    }
    
    /**
     *
     * @return string
     *
     */
    public function getSystemConfiguration() {
        if ($this->return == 'file') {
            $this->destination = " > '{$this->output}/system.configuration.json'";
        }
        $action = "getSystemConfiguration{$this->destination}";
        return $this->exec( $action );
    }
    
    /**
     * @return string
     *
     */
    public function getSystemProperties(){
        if ($this->return == 'file') {
            $this->destination = " > '{$this->output}/system.properties.json'";
        }
        $action = "getSystemProperties{$this->destination}";
        return $this->exec($action);
    }
    
    /**
     * @param string    $property
     * @return string
     *
     * Will return false if argument is incorrect
     */
    public function getSystemProperty($property = null){
        if ($this->return == 'file') {
            $this->destination = " > '{$this->output}/system.{$property}.json'";
        }
        $action = "getSystemProperty -name {$property}{$this->destination}";
        return $this->exec($action);
    }
    
    /**
     * @param string    $user
     * @return string
     *
     * Will return false if argument is incorrect
     */
    public function getUser($user = null){
        if ($this->return == 'file') {
            $this->destination = " > '{$this->output}/{$user}.json'";
        }
        $action = "getUser -user {$user}{$this->destination}";
        return $this->exec($action);
    }
    
    /**
     * @param string    $version
     * @param string    $link
     * @param string    $component      optional
     * @return string
     *
     * Will return false if argument is incorrect
     */
    public function getVersionLink($version = null, $link = null, $component = null){
        if (!empty($component)){
            $component = " -component '{$component}'";
        } else {
            $component = '';
        }
        if ($this->return == 'file') {
            $this->destination = " > '{$this->output}/{$version}.{$link}.json'";
        }
        $action = "getVersionLink -version {$version} -linkName {$link}{$component}{$this->destination}";
        return $this->exec($action);
    }
    
    /**
     * @param string    $version
     * @param string    $component      optional
     * @return string
     *
     * Will return false if argument is incorrect
     */
    public function getVersionLinks($version = null, $component = null){
        if (!empty($component)){
            $component = " -component '{$component}'";
        } else {
            $component = '';
        }
        if ($this->return == 'file') {
            $this->destination = " > '{$this->output}/{$version}.links.json'";
        }
        $action = "getVersionLinks -version {$version}{$component}{$this->destination}";
        return $this->exec($action);
    }
}
