<?php

/*
 * Explain the structure of $valid_actions array ....
 */
$valid_actions = array(
    'addTeamToApplication' => array(
        'description' => 'Add a team to the given application',
        'require' => array(
            'application' => 'Application name or ID',
            'team' => 'Team label ex: \'Dev-team\', \'Test-Team\'.'
        ),
        'optional' => array()
    ),
    'addTeamToComponent' => array(
        'description' => 'Add a team to one or more components',
        'require' => array(
            'team' => 'Team label ex: \'Dev-team\', \'Test-Team\'.'
        ),
        'optional' => array(
            'component' => 'Component name or ID. If no component is set, team will be added to all components'
        )
    ),
    'addTeamToResource' => array(
        'description' => 'Add a team to one or more resources',
        'require' => array(
            'team' => 'Team label ex: \'Dev-team\', \'Test-Team\'.'
        ),
        'optional' => array(
            'resource' => 'Resource name or ID. If no resource is set, team will be added to all resources'
        )
    ),
    'addTeamToAll' => array(
        'description' => 'Add team to entire UCD configuration',
        'require' => array(
            'team' => 'Team label ex: \'Dev-team\', \'Test-Team\'.'
        ),
        'optional' => array()
    ),
    'addVersionFiles' => array(
        'description' => 'Add files to a component version.',
        'require' => array(
            'component' => 'Component Name/Id.',
            'version' => 'Version name/Id.',
            'base' => 'Folder path containing files to upload.'
        ),
        'optional' => array(
            'include' => 'Comma separated list of file into base directory to be included.',
            'exclude' => 'Comma separated list of file into base directory to be exluded. Overrides includes.'
        )
    ),
    'backup' => array(
        'description' => 'Run a complete back up of uDeploy.',
        'require' => array(),
        'optional' => array()
    ),
    'cleanAll' => array(
        'description' => 'Clean applications, components, processes and post-processing scripts.',
        'require' => array(),
        'optional' => array()
    ),
    'config' => array(
        'description' => 'Config uCommand, setting new alias for default configuration file and promotion.',
        'require' => array(),
        'optional' => array(
            'alias' => 'Alias name to set in ucd.config.php.',
            'destination' => 'Alias name to set as destination in promote.config.php.',
            'origin' => 'Alias name to set as origin in promote.config.php.'
        )
    ),
    'createEnvironment' => array(
        'description' => 'Create a new environment from a JSON file',
        'require' => array(
            'file' => 'Json file path of the Environment.'
        ),
        'optional' => array()
    ),
    'createSnapshot' => array(
        'description' => 'Create an application snapshot based on json file',
        'require' => array(
            'file' => 'Json file path of the Snapshot.'
        ),
        'optional' => array()
    ),
    'createVersion' => array(
        'description' => 'Create a new version for the component',
        'require' => array(
            'component' => 'Component Name/Id.',
            'version' => 'Version Name.'
        ),
        'optional' => array(
            'description' => 'Version description.'
        )
    ),
    'createVersionAddFiles' => array(
        'description' => 'Create a new component version and uploads artifacts in one go.',
        'require' => array(
            'component' => 'Component Name/Id.',
            'version' => 'Version name.',
            'base' => 'Folder path containing files to upload.'
        ),
        'optional' => array(
            'include' => 'An include file pattern for selecting files to add (may be repeated)',
            'exclude' => 'An exclude file pattern for excluding files (may be repeated). Overrides includes.'
        )
    ),
    'createVersionsAndSnapshot' => array(
        'description' => 'First create component versions, then add them into a snapshot',
        'require' => array(
            'file' => 'Json file path of the Snapshot.'
        ),
        'optional' => array(
            'force' => 'Set to true to force snapshot creation even if new component version has not been found.'
        )
    ),
    'exportEnvironmentProperties' => array(
        'description' => 'Export the environment variables of an environment',
        'require' => array(
            'environment' => 'Environment Name/Id. If not provided, will be used the \'environment\' value defined in your server configuration file.',
            'application' => 'Application Name/id. If not provided, will be used the \'application\' value defined in your server configuration file.'
        ),
        'optional' => array()
    ),
    'forkApplication' => array(
        'description' => 'Creates a new copy of the application and it\'s contents replacing the suffix in the copy',
        'require' => array(
            'application' => 'Application Name/Id.',
            'old' => 'Old Suffix - The string at the end of the name to remove e.g. _22',
            'new' => 'New Suffix - The string to add to the end of the name e.g. _30'
        ),
        'optional' => array()
    ),
    'importEnvironmentProperties' => array(
        'description' => 'Import the environment variables of an application',
        'require' => array(
            'file' => 'JSON file of environment properties',
            'environment' => 'Environment Name/Id. If not provided, will be used the \'environment\' value defined in your server configuration file.',
            'application' => 'Application Name/id. If not provided, will be used the \'application\' value defined in your server configuration file.'
        ),
        'optional' => array()
    ),
    'promoteApplication' => array(
        'description' => 'Promote a single application from a uDeploy origin server to a destination uDeploy server',
        'require' => array(
            'application' => 'Application Name/Id.'
        ),
        'optional' => array()
    ),
    'promoteConfig' => array(
        'description' => 'Promote (upgrade) configuration from a uDeploy origin server to a destination uDeploy server',
        'require' => array(),
        'optional' => array(
            'dir' => 'Specify a directory path to promote configurations from an existing backup.',
            'environments' => 'Set true to promote applications environments.'
        )
    ),
    'promoteResourceTemplate' => array(
        'description' => 'Promote a resource template from a uDeploy origin server to a destination uDeploy server',
        'require' => array(
            'template' => 'Resource template Name/Id.'
        ),
        'optional' => array()
    ),
    'promoteSnapshot' => array(
        'description' => 'Promote a snapshot from a uDeploy origin server to a destination uDeploy server',
        'require' => array(
            'snapshot' => 'Snapshot name.'
        ),
        'optional' => array(
            'force' => 'Force snapshot creation even if new component version has not been found.'
        )
    ),
    'requestStatus' => array(
        'description' => 'Get status for a specified request ID',
        'require' => array(
            'process' => 'Application process Id.'
        ),
        'optional' => array()
    ),
    'restore' => array(
        'description' => 'Run a complete restore of uDeploy. Require a backup source path as argument.',
        'require' => array(
            'dir' => 'Backup source path'
        ),
        'optional' => array(
            'environments' => 'Restore applications keeping the environments.'
        )
    ),
    'restoreApplication' => array(
        'description' => 'Restore an application. Require a path to a json file as argument.',
        'require' => array(
            'file' => 'Json path of the Application.'
        ),
        'optional' => array()
    ),
    'restoreComponent' => array(
        'description' => 'Restore a component. Require a path to a json file as argument.',
        'require' => array(
            'file' => 'Json path of the Component.'
        ),
        'optional' => array()
    ),
    'restoreComponentTemplate' => array(
        'description' => 'Restore a ComponentTemplate. Require a path to a json file as argument.',
        'require' => array(
            'file' => 'Json path of the ComponentTemplate.'
        ),
        'optional' => array()
    ),
    'RTCbackup' => array(
        'description' => 'Cleanup RTC directory and backup files',
        'require' => array(),
        'optional' => array()
    ),
    'run' => array(
        'description' => 'Run an application process. Require a path to a json file as argument.',
        'require' => array(
            'file' => 'Json path of the Application Process.'
        ),
        'optional' => array()
    ),
    'runAndWait' => array(
        'description' => 'Run a process and wait for completion',
        'require' => array(
            'file' => 'Json path of the application process.'
        ),
        'optional' => array(
            'timeout' => 'Timeout in minutes. If Timeout is not set, wait for completion.'
        )
    ),
    'setSnapshotStatus' => array(
        'description' => 'Set Snapshot status: SnapshotName Passed|Failed',
        'require' => array(
            'snapshot' => 'Snapshot name.',
            'status' => 'Status: PASSED or FAILED.'
        ),
        'optional' => array()
    ),
    'setup' => array(
        'description' => 'Setup a new server in uCommand.',
        'require' => array(),
        'optional' => array()
    ),
    'upgrade' => array(
        'description' => 'Run a complete upgrade of uDeploy. Require a backup source path as argument',
        'require' => array(
            'dir' => 'Backup source path.'
        ),
        'optional' => array()
    ),
    'upgradeApplication' => array(
        'description' => 'Upgrade an existing application. Require a path to a json file or to a directory as argument.',
        'require' => array(
            'file' => 'Json path of the Application.'
        ),
        'optional' => array(
            'upgradeProcess' => 'Set true to upgrade the processes.',
            'upgradeTemplate' => 'Set true to upgrade the template.'
        )
    ),
    'upgradeComponent' => array(
        'description' => 'FUpgrade an existing component. Require a path to a json file as argument.',
        'require' => array(
            'file' => 'Json path of the Component.'
        ),
        'optional' => array(
            'upgradeProcess' => 'Set true to upgrade the processes.',
            'upgradeTemplate' => 'Set true to upgrade the template.'
        )
    ),
    'upgradeComponentTemplate' => array(
        'description' => 'Upgrade an existing ComponentTemplate. Require a path to a json file as argument.',
        'require' => array(
            'file' => 'Json file path of the component template.'
        ),
        'optional' => array()
    ),
    'ver' => array(
        'description' => 'Show current uCommand version and list of uDeploy versions compatibility',
        'require' => array(),
        'optional' => array()
    ),
    'waitRequestCompletion' => array(
        'description' => 'Wait for a specific application process request for completion',
        'require' => array(
            'process' => 'Application process Id.'
        ),
        'optional' => array(
            'timeout' => 'Timeout in minutes. If Timeout is not set, wait for completion.'
        )
    )
);