<?php
/****************************************************************
* IBM Confidential
*
* SFA100-Collaboration Source Materials
*
* (C) Copyright IBM Corp. 2015
*
* The source code for this program is not published or otherwise
* divested of its trade secrets, irrespective of what has been
* deposited with the U.S. Copyright Office
*
* **************************************************************/

/**
 * API for application requests via REST
 *
 * @author Felice Geracitano.......feliecege@ie.ibm.com
 */

class ApplicationRestApi extends AbstractApi {

    /**
     *
     * Deletes an application using name or ID
     *
     * @param string $application Id|Name
     * @return $string
     */
    public function deleteApplication($application = null){
        $application = str_replace(" ", "%20", $application);
        $command = "-X DELETE ";
        $command .= "'{$this->weburl}/rest/deploy/application/{$application}'";
        return $this->execRest($command);
    }
    
    /**
     *
     * Deletes an application process using ID
     *
     * @params string $processId Id
     * @return $string
     */
    public function deleteApplicationProcess($processId) {
        $command = "-X DELETE ";
        $command .= "'{$this->weburl}/rest/deploy/applicationProcess/{$processId}'";
    
        return $this->execRest($command);
    }
    
    /**
     *
     * Get Application Processes process using Id
     *
     * @params $application string 
     * @return $string
     */
    public function getApplicationProcesses($application = null) {
        $application = str_replace(" ", "%20", $application);
        if ($this->return == 'file') {
            $this->destination = " > '{$this->output}/{$application}.processes.json'";
        }
    
        $action = $this->weburl ."/rest/deploy/application/$application/processes/false " . $this->destination;
        return $this->execRest($action);
    }
    
    /**
     *
     * Get Application Process
     *
     * @params $appProcessID string
     * @params $appProcessName string
     * @return $string
     */
    public function getApplicationProcessRest($appProcessID = null, $appProcessName = null) {
        $appProcessName = str_replace(" ", "%20", $appProcessName);
        if (empty($appProcessName)){
            $appProcessName = 'AppProcess_'.$appProcessID;
        }
        
        if ($this->return == 'file') {
            $this->destination = " > '{$this->output}/{$appProcessName}.json'";
        }
    
        $action = $this->weburl . '/rest/deploy/applicationProcess/'
                . $appProcessID . '/-1' . $this->destination;
        return $this->execRest($action);
    }
    
    /**
     * Import an application from a file path
     *
     * If upgradeComponentTemplate is set (by default, USE_EXISTING_IF_EXISTS) also components are upgraded
     * If upgradeProcess is set (by default, USE_EXISTING_IF_EXISTS) also processes are upgraded
     *
     * allowed value for upgradeComponentTemplate and upgradeProcess
     *  USE_EXISTING_IF_EXISTS
     *  CREATE_NEW_IF_EXISTS
     *  FAIL_IF_EXISTS
     *  FAIL_IF_DOESNT_EXIST
     *  UPGRADE_IF_EXISTS
     *
     * @param string $application
     * @param string $upgradeComponent
     * @param string $upgradeProcess
     *
     * @return boolean|string
     **/
    
    public function importApplication ($application = null, $upgradeComponentTemplate = 'USE_EXISTING_IF_EXISTS', $upgradeProcess = 'USE_EXISTING_IF_EXISTS') {
        $command = "-F file=@'{$application}' ";
        $command .= "'{$this->weburl}/rest/deploy/application/import?upgradeType=USE_EXISTING_IF_EXISTS";
    
        if (in_array( $upgradeComponentTemplate, $this->upgrade_values )) {
            $command .= "&compTempUpgradeType=$upgradeComponentTemplate";
        } else {
            $command .= "&compTempUpgradeType=USE_EXISTING_IF_EXISTS";
        }
        if (in_array( $upgradeProcess, $this->upgrade_values )) {
            $command .= "&processUpgradeType=$upgradeProcess'";
        } else {
            $command .= "&processUpgradeType=USE_EXISTING_IF_EXISTS'";
        }
        return $this->execRest($command);
    }
    
    /**
     *
     * Export an application to a file or returns a json
     *
     * @param string $application
     * @return boolean|string
     */
    public function getApplicationRest($application = null) {
        $application = str_replace(" ", "%20", $application);
        if ($this->return == 'file') {
            $this->destination = " -o '{$this->output}/{$application}.json'";
        }
        $action = "{$this->weburl}/rest/deploy/application/{$application}/export {$this->destination}";
        return $this->execRest($action);
    }
    
    /**
     *
     * Export all applications to a file or returns a json
     * @return boolean|string
     */
    public function getApplicationsRest(){
        if ($this->return == 'file') {
            $this->destination = " -o '{$this->output}/applications.json'";
        }
        $action = "{$this->weburl}/rest/deploy/application?active=true {$this->destination}";
        return $this->execRest($action);
    }
    
    /**
     * Set up a string holding the REST CURL request,
     * to be sent to UCD server in irder to Upgrade a UCD Application based on a JSON formatted backup file.
     * Will either upgrade, Application related: componentTemplate(s) and application-Process(es)
     * or use existent ones, based on the related parameters.
     *
     * If upgradeComponentTemplate is set (by default, USE_EXISTING_IF_EXISTS) also components are upgraded
     * If upgradeProcess is set (by default, USE_EXISTING_IF_EXISTS) also processes are upgraded
     *
     * allowed value for upgradeComponentTemplate and upgradeProcess
     *  USE_EXISTING_IF_EXISTS
     *  CREATE_NEW_IF_EXISTS
     *  FAIL_IF_EXISTS
     *  FAIL_IF_DOESNT_EXIST
     *  UPGRADE_IF_EXISTS
     *
     * @param string $application
     * @param string $upgradeComponent
     * @param string $upgradeProcess
     *
     * @return boolean|string
     */
    public function upgradeApplication($application = null, $upgradeComponentTemplate = 'USE_EXISTING_IF_EXISTS', $upgradeProcess = 'USE_EXISTING_IF_EXISTS') {
        $command = "-F file=@'{$application}' ";
        $command .= "'{$this->weburl}/rest/deploy/application/upgrade?upgradeType=UPGRADE_IF_EXISTS";
    
        if (in_array( $upgradeComponentTemplate, $this->upgrade_values )) {
            $command .= "&compTempUpgradeType=$upgradeComponentTemplate";
        } else {
            $command .= "&compTempUpgradeType=USE_EXISTING_IF_EXISTS";
        }
        if (in_array( $upgradeProcess, $this->upgrade_values )) {
            $command .= "&processUpgradeType=$upgradeProcess'";
        } else {
            $command .= "&processUpgradeType=USE_EXISTING_IF_EXISTS'";
        }
        return $this->execRest($command);
    }
}
