<?php
/****************************************************************
* IBM Confidential
*
* SFA100-Collaboration Source Materials
*
* (C) Copyright IBM Corp. 2015
*
* The source code for this program is not published or otherwise
* divested of its trade secrets, irrespective of what has been
* deposited with the U.S. Copyright Office
*
* **************************************************************/

/**
 * API for process requests via REST
 *
 * @author Felice Geracitano.......feliecege@ie.ibm.com
 */
class ProcessRestApi extends AbstractApi {
    /**
     *
     * Create a new post processing script from a json file
     *
     * @param string $scriptFile
     * @return boolean|string
     */
    public function createPostProcessingScript($scriptFile){
        $action = "-X PUT ";
        $action .= '-H "Content-Type: application/json" ';
        $action .= "{$this->weburl}/rest/script/postprocessing -d @'{$scriptFile}'";
        return $this->execRest($action);
    }
    
    /**
     *
     * Deletes an deleteGenericProcess using ID
     *
     * @param string process ID
     */
    public function deleteGenericProcess($processID = null){
        $command = "-X DELETE ";
        $command .= "'{$this->weburl}/rest/process/{$processID}'";
        return $this->execRest($command);
    }
    
    /**
     *
     * Deletes a componentProcess using ID
     *
     * @param unknown $component ID
     */
    public function deletePostProcessingScript($scriptID = null){
        $command = "-X DELETE ";
        $command .= "'{$this->weburl}/rest/script/postprocessing/{$scriptID}'";
        return $this->execRest($command);
    }
    
    /**
     *
     * Export a generic process
     *
     * @param string $process
     * @return boolean|string
     */
    public function exportProcess($process = null) {
        if ($this->return == 'file') {
            $this->destination = " -o '{$this->output}/{$process}.json'";
        }
    
        $action = "{$this->weburl}/rest/process/{$process}/export {$this->destination}";
        return $this->execRest($action);
    }
    /**
     *
     * Return process
     *
     * @return string
     *
     * Will return false if argument is incorrect
     */
    public function getProcessRest($processId = null){
        if ($this->return == 'file') {
            $this->destination = " -o '{$this->output}/{$processId}.json'";
        }
        $action = "{$this->weburl}/rest/process/{$processId}/-1 {$this->destination}";
        return $this->execRest($action);
    }
    
    /**
     *
     * Get all port precessing scripts
     *
     */
    public function getPostProcessingScripts(){
        if ($this->return == 'file') {
            $this->destination = "> '{$this->output}/postProcessScripts.json'";
        }
        $action = $this->weburl . "/rest/script/postprocessing {$this->destination}";
        return $this->execRest($action);
    }
    
    /**
     *
     * Returns list of all generic processes
     *
     * @return Ambigous <boolean, unknown>
     */
    public function getProcesses(){
        if ($this->return == 'file') {
            $this->destination = "> '{$this->output}/processes.json'";
        }
        $action = $this->weburl . "/rest/process? {$this->destination}";
        return $this->execRest($action);
    }
    
    /**
     *
     * Import new process from file. Upgrade an existing process if exists
     *
     * @param string $file
     * @param boolean $upgrade
     *
     * @return boolean|string
     *
     */
    public function importProcess($file = null, $upgrade = false) {
        if (is_bool($upgrade) && $upgrade) {
            $type = 'upgrade';
        } else {
            $type = 'import';
        }
        $action = "-X POST ";
        $action .= "{$this->weburl}/rest/process/{$type}";
        $action .= ' -H "Content-Type: multipart/form-data"';
        $action .= " -F file=@'{$file}'";
        // Return
        return $this->execRest($action);
    }

}