<?php
/****************************************************************
* IBM Confidential
*
* SFA100-Collaboration Source Materials
*
* (C) Copyright IBM Corp. 2015
*
* The source code for this program is not published or otherwise
* divested of its trade secrets, irrespective of what has been
* deposited with the U.S. Copyright Office
*
* **************************************************************/

/**
 * API for environment requests via UcdClient
 *
 * @author Felice Geracitano.......feliecege@ie.ibm.com
 *
 */
class EnvironmentUdclientApi extends AbstractApi {
    /**
     *
     *
     * Enter description here
     *
     * @param string $environment
     * @param string $application
     * @param string $deleteResources
     * @param string $deleteCloud
     * @return boolean
     */
    public function deleteEnvironment($environment = null, $application = null, $deleteResources = false, $deleteCloud = false) {
        if (empty( $application )) {
            $application = $this->application;
        }
        $action = "deleteEnvironment -environment '{$environment}'" .
                 " -application '{$application}'" .
                 " -deleteAttachedResources {$deleteResources}" .
                 " -deleteCloudInstances {$deleteCloud}";
        return $this->exec( $action );
    }
    
    /**
     *
     * @param string $environment
     * @return string Will return false if argument is incorrect
     */
    public function getEnvironment($environment = null, $application = null) {
        if (empty( $environment )) {
            $environment = $this->environment;
        }
        if (empty( $application )) {
            $application = " -application '{$this->application}'";
        } else {
            $application = " -application '{$application}'";
        }
        
        if ($this->return == 'file') {
            $this->destination = " > '{$this->output}/{$environment}.json'";
        }
        $action = "getEnvironment -environment '{$environment}'{$application}{$this->destination}";
        return $this->exec( $action );
    }
    
    /**
     * @param string        $environment
     * @param string        $application
     * @return string
     *
     * Will return false if argument is incorrect
     */
    public function getEnvironmentBaseResources($environment = null, $application = null){
        if (empty( $environment )) {
            $environment = $this->environment;
        }
        if (empty( $application )) {
            $application = $this->application;
        }
        if (! empty( $application )) {
            $application = ' -application ' . $application;
        }
        if ($this->return == 'file') {
            $this->destination = " > '{$this->output}/{$environment}.baseResources.json'";
        }
        $action = "getEnvironmentBaseResources -environment {$environment}{$application}{$this->destination}";
        return $this->exec( $action );
    }
    

    /**
     * @param string        $environment
     * @param string        $application
     * @return string
     *
     * Will return false if argument is incorrect
     */
    public function getEnvironmentProperties($environment = null, $application = null){
        if (empty( $environment )) {
            $environment = $this->environment;
        }
        if (empty( $application )) {
            $application = $this->application;
        }
        if ($this->return == 'file') {
            $this->destination = " > '{$this->output}/{$environment}.properties.json'";
        }
        $action = "getEnvironmentProperties -environment {$environment} -application {$application}{$this->destination}";
        return $this->exec( $action );
    }
    
    /**
     * @param string        $environment
     * @param string        $property
     * @param string        $application
     * @return string
     *
     * Will return false if argument is incorrect
     */
    public function getEnvironmentProperty($environment = null, $property = null, $application = null){
        if (empty( $environment )) {
            $environment = $this->environment;
        }
        if (empty( $application )) {
            $application = $this->application;
        }
        if ($this->return == 'file') {
            $this->destination = " > '{$this->output}/{$environment}.{$property}.json'";
        }
        $action = "getEnvironmentProperty -name {$property} -environment {$environment} -application {$application}{$this->destination}";
        return $this->exec( $action );
    }
    
    /**
     * @param string    $application
     * @return string
     *
     * Will return false if argument is incorrect
     */
    public function getEnvironmentsInApplication($application = null){
        if (empty( $application )) {
            $application = $this->application;
        }
        if ($this->return == 'file') {
            $this->destination = " > '{$this->output}/{$application}.environments.json'";
        }
        $action = "getEnvironmentsInApplication -application {$application}{$this->destination}";
        return $this->exec( $action );
    }
}
