<?php
/****************************************************************
 * IBM Confidential
 *
 * SFA100-Collaboration Source Materials
 *
 * (C) Copyright IBM Corp. 2014
 *
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has been
 * deposited with the U.S. Copyright Office
 *
 ***************************************************************/

require_once('API/AbstractApi.php');
require_once('API/Udclient.php');
require_once('API/Rest.php');
require_once('Utils/Utils.php');
require_once('Utils/Logger.php');
require_once('Utils/StopWatch.php');

define( "CLASSES", 
        serialize( 
                array (
                    'Application',
                    'ApplicationProcess',
                    'BackupUCD',
                    'Component',
                    'Environment',
                    'Fork',
                    'Process',
                    'Promote',
                    'Resource',
                    'RestoreUCD',
                    'Snapshot',
                    'Team' 
                ) ) );


/**
 * 
 * @class   EntryPoint
 * @author  Marco Bassi         		marcobas@ie.ibm.com
 * @author  Kostadin Ivanov     		kostadii@ie.ibm.com
 * @author  Moises Dominguez Garcia     moisesdg@ie.ibm.com
 * @author  Felice Geracitano           felicege@ie.ibm.com

 */
class EntryPoint extends AbstractApi {
    protected $rest;
    protected $udclient;
    protected $logout = false;
    
    /**
     * Get Rest APIs
     */
    public function rest(){
        if (empty($this->rest)){
            $this->rest = new Rest();
        }
        // Update Api with the father settings
        $this->set($this->rest);
        return $this->rest;
    }

    /**
     *  Set Api objcet with father paramters if needed
     *  @return object
     */
    public function set($api) {
        
        if (isset( $this->server ) && isset( $this->config )) {
            // set up children without display setting message
            $api->setupServer( $this->server, $this->config, false, $this->logout );
        }
        // setupAlias set alias parameter in Api object
        // and return a config array unuseful here
        if (isset( $this->alias )) {
            $api->setupAlias( $this->alias );
        }
        if (isset( $this->output )) {
            $api->setOutput( $this->output, false );
        }
        if (isset( $this->return )) {
            $api->setReturn( $this->return );
        }
    }
    
    /**
     * Get Udclient APIs
     */
    public function udclient(){
        if (empty($this->udclient)){
            $this->udclient = new Udclient();
        }
        $this->set($this->udclient);
        return $this->udclient;
    }
    
    /**
     * Class getter
     */
    public function getClass($name, $alias = null){
        $classes = unserialize (CLASSES);
        if (!in_array($name,$classes)){
            return false;
        }
        return new $name($alias);
    }

}