<?php
/**
 * **************************************************************
 * IBM Confidential
 *
 * Collaboration Source Materials
 *
 * (C) Copyright IBM Corp. 2014-2015
 *
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has been
 * deposited with the U.S. Copyright Office
 *
 * *************************************************************
 */
chdir(__DIR__);

require_once 'include/EntryPoint.php';
require_once 'include/Extensions/BackupUCD.php';
require_once 'include/Extensions/CleanUCD.php';
require_once 'include/Extensions/Fork.php';
require_once 'include/Extensions/Promote.php';
require_once 'include/Extensions/RestoreUCD.php';
require_once 'include/Layers/ApplicationProcess.php';
require_once 'include/Layers/Environment.php';
require_once 'include/Layers/Snapshot.php';
require_once 'include/Layers/Team.php';
require_once 'include/Utils/AliasHandler.php';
require_once 'include/Utils/ArgumentsHandler.php';
require_once 'include/Utils/Logger.php';
require_once 'include/Utils/Utils.php';
include 'config/ucd.config.php';

$return = array ();
$return_msg = '';


// Setup logger
$log = new Logger();
if (file_exists( 'config/logger.config.php' )) {
    include ('config/logger.config.php');
    $log->setLogFile( $config ['log'] );
    $log->setDebug( $config ['debug'] );
    $log->cleanTmpDir( $config['tmp_clean_time'] );
}

// Prompt a start-up message to user
Utils::CLIout( "##################################" );
Utils::CLIout( "#            uCommand            #" );
Utils::CLIout( "# Urban Code Deploy PHP CLI Tool #" );
Utils::CLIout( "#    by SalesConnect - Dublin    #" );
Utils::CLIout( "##################################\n" );


//=====================================================
// CLI 2.0
//=====================================================
$arg_handler = new ArgumentsHandler($argv);
$arguments = $arg_handler->getArguments(); // Error messages handled in the functions

// Valid arguments
switch ($arguments ['action']) {
    case 'addTeamToApplication' :
        $teamAPIs = new Team();
        $result = $teamAPIs->addToApplication($arguments['application'], $arguments['team']);
        break;
    case 'addTeamToComponent' :
        $restore = new RestoreUCD();
        $componentAPIs = new Component();
        if (array_key_exists('component', $arguments)) {
            $result = $componentAPIs->addToTeam($arguments['component'], $arguments['team']);
        } else {
            $result = $restore->addTeamToAllComponents($arguments['team']);
        }
        break;
    case 'addTeamToResource':
        $restore = new RestoreUCD();
        $resourceAPIs = new Resource();
        if (array_key_exists('resource', $arguments)) {
            $result = $resourceAPIs->addToTeam($arguments['resource'], $arguments['team']);
        } else {
            $result = $restore->addTeamToAllResources($arguments['team']);
        }
        break;
    case 'addTeamToAll':
        $teamAPIs = new Team();
        $resourceAPIs = new Resource();
        $result = $teamAPIs->addToUnmapped($arguments['team']);
        $failed = Utils::resultHasFailed($result);
        if (!$failed) {
            Utils::CLIinfo("Unmapped resources have been set to team ${arguments['team']}.");
            $result = true;
        } else {
            $result = false;
        }
        break;
    case 'addVersionFiles':
        $componentAPIs = new Component();
        $component = $arguments['component'];
        $version = $arguments['version'];
        $base = $arguments['base'];
        $include = array_key_exists('include', $arguments) ? $arguments['include'] : null;
        $exclude = array_key_exists('exclude', $arguments) ? $arguments['exclude'] : null;
        $result = $componentAPIs->addFilesToVersion($component, $version, $base, $include, $exclude);
        break;
    case "backup" :
        $backup = new BackupUCD();
        $result = $backup->backupAll();
        $config ['output'] = $backup->getOutput();
        $config ['json_check'] = true;
        break;
    case 'cleanAll' :
        $cleanUCD = new CleanUCD();
        $result = $cleanUCD->cleanAll();
        break;
    case 'config':
        $alias = new AliasHandler();
        $result = $alias->setAll($arguments);
        break;
    case 'createEnvironment' :
        $file_path = $arguments ['file'];
        $environment = new Environment();
        $result = $environment->create( $file_path );
        break;
    case 'createSnapshot' :
        $snapshotAPIs = new Snapshot();
        $file_path = $arguments['file'];
        $result = $snapshotAPIs->create( $file_path );
        break;
    case 'createVersion' :
        $componentAPIs = new Component();
        $component = $arguments['component'];
        $version = $arguments['version'];
        $description = isset($arguments['description'])? $arguments['description'] : null;
        $result = $componentAPIs->createComponentVersion( $component, $version, $description );
        break;
    case 'createVersionAddFiles':
        $componentAPIs = new Component();
        $component = $arguments['component'];
        $version = $arguments['version'];
        $result = $componentAPIs->createComponentVersion($component, $version);
        if ($result !== false) {
            $versionObj = $result;
            $versionId = $versionObj['id'];
            $base = $arguments['base'];
            $include = array_key_exists('include', $arguments) ? $arguments['include'] : null;
            $exclude = array_key_exists('exclude', $arguments) ? $arguments['exclude'] : null;
            $result = $componentAPIs->udclient()->component()->addVersionFiles($component, $version, $base, $include, $exclude);
            if ($result !== false) {
                Utils::CLIinfo("Version '$version' for component '$component': $componentAPIs->weburl/#version/$versionId");
            }
        }
        
        break;
    case 'createVersionsAndSnapshot' :
        $snapshotAPIs = new Snapshot();
        $file_path = isset($arguments['file']) ? $arguments['file'] : null;
        $force = false;
        if (strtolower($arguments['force']) === "true"){
            $force = true;
        }
        $result = $snapshotAPIs->createVersionsAndSnapshot($file_path, $force);
        break;
    case 'exportEnvironmentProperties' :
        $environmentAPIs = new Environment();
        $env = $arguments ['environment'];
        $app = $arguments ['application'];
        $result = $environmentAPIs->exportProperties( $env, $app );
        break;
    case 'forkApplication' :
        $forkAPIs = new Fork();
        $forkAPIs->setOldSuffix($arguments['old']);
        $forkAPIs->setNewSuffix($arguments['new']);
        $result = $forkAPIs->forkApplication($arguments['application']);
        break;
    case 'importEnvironmentProperties' :
        $environmentAPIs = new Environment();
        $file = $arguments['file'];
        $env = $arguments['environment'];
        $app = $arguments['application'];
        // Success | Error handling will be managed at the end of this script
        $result = $environmentAPIs->importProperties( $file, $env, $app );
        break;
    case 'promoteApplication' :
        $promoteAPIs = new Promote();
        $result = $promoteAPIs->application( $arguments ['application'] );
        break;
    case 'promoteConfig' :
    case 'restore' :
        $promoteAPIs = new Promote();
        $source = isset($arguments['dir']) ? $arguments['dir'] : null;
        $envs = isset($arguments['environments']) ? $arguments['environments'] : null;
        $exportEnvironments = false;
        if (strtolower($envs) === "true"){
            $exportEnvironments = true;
        }
        $result = $promoteAPIs->config( $source, $exportEnvironments );
        break;
    case 'promoteResourceTemplate' :
        $promoteAPIs = new Promote();
        $result = $promoteAPIs->resourceTemplate( $arguments ['template'] );
        break;
    case 'promoteSnapshot' :
        $promoteAPIs = new Promote();
        $snapshot = $arguments ['snapshot'];
        $force = false;
        $force_parameter = isset($arguments['force'])? $arguments['force'] : '';
        if (strtolower($force_parameter) === "true"){
            $force = true;
        }
        $result = $promoteAPIs->snapshot( $snapshot, $force );
        break;
    case 'requestStatus' :
        $appProcessAPIs = new ApplicationProcess();
        $processId = $arguments['process'];
        $appProcessAPIs->setRequestId( $processId );
        $result = $appProcessAPIs->status( true );
        if (empty($result)){
            Utils::CLIresult("Action 'requestStatus' completed with error/s.", false);
            exit (1);
        }
        Utils::CLIinfo("The process with id '{$processId}' has status: {$result}");
        exit ($result); // process status
        break;
    case 'restoreApplication' :
        $file_path = $arguments ['file'];
        $applicationAPIs = new Application();
        $result = $applicationAPIs->import($file_path, false);
        break;
    case 'restoreComponent' :
        $file_path = $arguments ['file'];
        $componentAPIs = new Component();
        $result = $componentAPIs->create( $file_path );
        break;
    case 'restoreComponentTemplate' :
        $file_path = $arguments ['file'];
        $componentAPIs = new Component();
        $result = $componentAPIs->createTemplate( $file_path );
        break;
    case 'RTCbackup' :
        $backup = new BackupUCD();
        $cwd = getcwd();
        if ( empty ($config['output']) ) {
            $dir = "{$cwd}/backups";
        } else {
            $dir = $config['output'];
        }
        Utils::CLIinfo( "Removing old backup data from {$dir}" );
        $cleanCommand = "cd {$dir}; rm -R $(ls | grep -v 'build.xml' | grep -v 'component.xml')";
        exec( $cleanCommand, $output, $result );
        chdir( $cwd );
        if ($result == 0) {
            $return = $backup->backupAll();
        } else {
            Utils::CLIerror( "Error while removing old backup data from RTC directory." );
        }
        break;
    case 'run' :
        $appProcessAPIs = new ApplicationProcess();
        $result = $appProcessAPIs->request( $arguments ['file'] );
        if (is_string($result)) {
            Utils::CLIout( "{$result}", true, "id" );
            Utils::CLIout( "{$appProcessAPIs->getWeburl()}/#applicationProcessRequest/{$result}", true, "link" );
        }
        if ($result === false){
            break; // go to default exit 1
        }
        exit (0); // exit code
    case 'runAndWait' :
        $appProcessAPIs = new ApplicationProcess();
        $file_path = $arguments ['file'];
        $timeout = $arguments ['timeout'];
        if (! file_exists($file_path)) {
            Utils::CLIerror("Invalid or missing template for application process.");
            exit(1);
        }
        if (! empty( $timeout )) {
            $timeout = $timeout;
        } else {
            $timeout = true;
        }
        $result = $appProcessAPIs->request( $file_path );
        if (is_string($result)) {
            Utils::CLIout("{$result}", true, "id");
            Utils::CLIout("{$appProcessAPIs->getWeburl()}/#applicationProcessRequest/{$result}", true, "link");
            $result = $appProcessAPIs->waitCompletion($timeout);
        }
        if ($result === false) {
            break; // go to default exit 1
        }
        exit($result);
    case 'setSnapshotStatus' :
        $name = $arguments['snapshot'];
        $status = $arguments['status'];
        $snapshot = new Snapshot();
        $result = $snapshot->setSnapshotStatus( $name, $status );
        break;
    case 'setup' :
        Utils::CLIout("");
        exec('chmod +x ./setup');
        $result = pcntl_exec('./setup');
        break;
    case 'upgrade' :
        $restoreAPIs = new RestoreUCD();
        $result = $restoreAPIs->restoreAll( $arguments['dir'], true );
        break;
    case 'upgradeApplication' :
        $file_path = $arguments['file'];
        $upgradeTemplate = null;
        $upgradeProcess = null;
        if (strtolower($arguments['upgradeProcess']) !== "true" ){
            $upgradeProcess = 'USE_EXISTING_IF_EXISTS';
        }
        if (strtolower($arguments['upgradeTemplate']) !== "true" ){
            $upgradeTemplate = 'USE_EXISTING_IF_EXISTS';
        }
        $applicationAPIs = new Application();
        $result = $applicationAPIs->upgrade( $file_path, $upgradeTemplate, $upgradeProcess );
        break;
    case 'upgradeComponent' :
        $file_path = $arguments['file'];
        $upgradeTemplate = null;
        $upgradeProcess = null;
        if (strtolower($arguments['upgradeProcess']) !== "true" ){
            $upgradeProcess = 'USE_EXISTING_IF_EXISTS';
        }
        if (strtolower($arguments['upgradeTemplate']) !== "true" ){
            $upgradeTemplate = 'USE_EXISTING_IF_EXISTS';
        }
        $componentAPIs = new Component();
        $result = $componentAPIs->upgrade( $file_path, $upgradeTemplate, $upgradeProcess );
        break;
    case 'upgradeComponentTemplate' :
        $file_path = $arguments['file'];
        $componentAPIs = new Component();
        $result = $componentAPIs->createTemplate( $file_path, true );
        break;
    case 'vers' :
    case 'version' :
    case 'versions' :
    case 'ver' :
        include ('include/version.php');
        Utils::CLIout( "Version: {$ver['ucommand']}" );
        Utils::CLIout( "Supported uDeploy versions:" );
        foreach ( $ver ['ucd'] as $ucdver ) {
            Utils::CLIout( "  {$ucdver}" );
        }
        Utils::CLIout( "" );
        break;
    case 'waitRequestCompletion' :
        
        $appProcessAPIs = new ApplicationProcess();
        $process = $arguments ['process'];
        $timeout = $arguments ['timeout'];
        $appProcessAPIs->setRequestId( $process );
        if (! empty( $timeout )) {
            $timeout = $timeout;
        } else {
            $timeout = true;
        }
        $result = $appProcessAPIs->waitCompletion( $timeout );
        if ($result === false) {
            break; // go to default exit 1
        }
        exit( $result );
    default :
        if (!empty($arguments['action'])){
            Utils::CLIerror( "Action '${arguments['action']}' does not exist." );
        }
        // General helper, action list only
        $arg_handler->helper();
        exit( 1 );
}

// Print final mesasge
echo PHP_EOL;
// Result validation

if ($result === false){
    Utils::CLIresult("Action '{$arguments['action']}' completed with error/s.", false);
    exit (1);
}
Utils::CLIresult("Action '{$arguments['action']}' completed successfully.", false);
// JSON validation
if ($config ['json_check'] === true) {
    Utils::validateDirectoryJSON( $config ['output'] );
}
Utils::CLIdebug( var_export( $result, true ) );
$log->log( var_export( $result, true ) );
exit (0);