<?php
/****************************************************************
* IBM Confidential
*
* SFA100-Collaboration Source Materials
*
* (C) Copyright IBM Corp. 2015
*
* The source code for this program is not published or otherwise
* divested of its trade secrets, irrespective of what has been
* deposited with the U.S. Copyright Office
*
* **************************************************************/

/**
 * API for enviroment requests via REST
 *
 * @author Felice Geracitano.......feliecege@ie.ibm.com
 */
class EnvironmentRestApi extends AbstractApi {
    /**
     *
     * Export the environment properties of an application
     *
     * @param string $application
     * @return boolean|string
     */
    public function exportEnvironmentProperties($environment = null) {
        if (empty( $environment )) {
            $environment = $this->environment;
        }
        $this->destination = " -o '{$this->output}/EnvironmentProperties_{$environment}.json'";
    
        $action = "{$this->weburl}/rest/deploy/environment/{$environment}/componentProperties {$this->destination}";
        return $this->execRest($action);
    }
    

    /**
     *
     * get environment resources
     *
     * @param string $environment               Environment ID
     * @return boolean|string
     */
    public function getEnvironmentResources($environment){
        if ($this->return == 'file') {
            $this->destination = "> '{$this->output}/postProcessScripts.json'";
        }
        $action = $this->weburl . "/rest/deploy/environment/{$environment}/resources {$this->destination}";
        return $this->execRest($action);
    }
    
    /**
     *
     * Import the environment properties of an application
     *
     * @param string $jsonData
     * @param string $environmentId
     *
     * @return boolean|string
     */
    public function importEnvironmentProperties($jsonData = null, $environmentId = null) {
        $action = "-X PUT ";
        $action .= "{$this->weburl}/rest/deploy/environment/{$environmentId}/componentProperties";
        $action .= " --data-binary '{$jsonData}' --compressed";
        return $this->execRest($action);
    }
    
    /**
     *
     * Create a new post environment
     *
     * @param string $json
     * @return boolean|string
     */
    public function provisionEnvironment($json = null){
        $action = "-X PUT ";
        $action .= '-H "Content-Type: application/json" ';
        $action .= "{$this->weburl}/cli/environment/provisionEnvironment -d @'{$json}'";
        return $this->execRest($action);
    }
}
