<?php
/****************************************************************
* IBM Confidential
*
* SFA100-Collaboration Source Materials
*
* (C) Copyright IBM Corp. 2015
*
* The source code for this program is not published or otherwise
* divested of its trade secrets, irrespective of what has been
* deposited with the U.S. Copyright Office
*
* **************************************************************/

/**
 * API for resources requests via REST
 *
 * @author Felice Geracitano.......feliecege@ie.ibm.com
 */
class ResourcesRestApi extends AbstractApi {
    /**
     *
     * Create a blueprint giving a valid json file
     *
     * @param string $blueprint
     * @return string
     */
    public function createBlueprint($blueprint = null) {
        $action = "-X PUT ";
        $action .= '-H "Content-Type: application/json" ';
        $action .= "{$this->weburl}/rest/deploy/blueprint -d @'{$blueprint}'";
        return $this->execRest($action);
    }
    
    /**
     *
     * Enter description here ...
     *
     * @param string $resource  Resource filename
     * @return string
     */
    public function createBlueprintResource($resource = null) {
        $action = "-X PUT ";
        $action .= '-H "Content-Type: application/json" ';
        $action .= "{$this->weburl}/rest/resource/resource -d @'{$resource}'";
        return $this->execRest($action);
    }
    
    /**
     *
     * Create a resource template
     *
     * @param string $resourceTemplate      Path to the json file
     *                       description: ""
     *                       name: "Web server stack"
     *                       teamMappings: []
     *
     * @return string
     */
    public function createResourceTemplate($resourceTemplate = null) {
        $action = "-X PUT ";
        $action .= '-H "Content-Type: application/json" ';
        $action .= "{$this->weburl}/rest/resource/resourceTemplate -d @'{$resourceTemplate}'";
        return $this->execRest($action);
    }
    
    /**
     *
     * Create a resource template child
     *
     * @param string $resourceTemplate      Path to the json file
     *                       description: ""
     *                       dynamic: "false"
     *                       inheritTeam: "true"
     *                       name: "Apache"
     *                       parentId: "9d18d9e7-1861-474e-8b78-6414b2fe42ae"
     *                       teamMappings: []
     *
     * @return string
     */
    public function createResourceTemplateChild($resourceTemplateChild = null) {
        $action = "-X PUT ";
        $action .= '-H "Content-Type: application/json" ';
        $action .= "{$this->weburl}/rest/resource/resource -d @'{$resourceTemplateChild}'";
        return $this->execRest($action);
    }
    
    /**
     *
     * Delete a resource template given its ID
     *
     * @param string $templateId
     * @return string
     */
    public function deleteResourceTemplate( $templateId ) {
        $action = "-X DELETE ";
        $action .= "{$this->weburl}/rest/resource/resource/{$templateId} ";
        return $this->execRest($action);
    }
    
    /**
     *
     * Export a blueprint giving information about application, template and blueprint itself.
     * More powerful tool compared to getblueprintsInApplication
     *
     * @param string $blueprintId
     * @param string $blueprintName
     * @return boolean|string
     */
    public function getBlueprint($blueprintId = null, $blueprintName = null) {
        if (empty( $blueprintName )) {
            $blueprintName = $blueprintId;
        }
        if ($this->return == 'file') {
            
            $this->destination = "-o '{$this->output}/{$blueprintName}.json'";
        }
        $action = "{$this->weburl}/rest/deploy/blueprint/{$blueprintId} {$this->destination}";
        return $this->execRest( $action );
    }
    
    /**
     * Export Blueprints In Application
     * @param string        $application
     * @return string
     *
     */
    public function getBlueprintsInApplication ($application = null) {
        $application = str_replace(" ", "%20", $application);
        if (empty( $application )) {
            $application = $this->application;
        }
        if ($this->return == 'file') {
            $this->destination = " > '{$this->output}/{$application}.blueprints.json'";
        }
        $action = "{$this->weburl}/rest/deploy/application/{$application}/blueprints {$this->destination}";
        return $this->execRest( $action );
    }
    
    /**
     * Get Blueprint Resources passing Blueprint Id
     * Blueprint Name is not mandatory to name the file output
     * 
     * @param string        $application
     * @return string
     *
     */
    public function getBlueprintResources($blueprintId = null, $blueprintName = null) {
        if (empty( $blueprintName )) {
            $blueprintName = $blueprintId;
        }
        if ($this->return == 'file') {
            
            $this->destination = "-o '{$this->output}/{$blueprintName}.resources.json'";
        }
        $action = "{$this->weburl}/rest/deploy/blueprint/{$blueprintId}/resources {$this->destination}";
        
        return $this->execRest( $action );
    }
    
    /**
     * Get Resource by Role
     *
     * @param string        $name
     * @return string
     *
     */
    public function getResourceRole( $name = null ) {
        if (empty($name)){
                $name = '*';
        }
        if ( $name == '*' ) {
            $nameForFile = 'resourceRoles';
        } else {
            $nameForFile = "{$name}.resourceRole";
        }
        if ($this->return == 'file') {
            
            $this->destination = "> '{$this->output}/{$nameForFile}.json'";
        }
        $action = $this->weburl . "/rest/resource/resourceRole/componentRoles/?name={$name} {$this->destination}";
        return $this->execRest($action);
    }
    
    /**
     *
     * Export a template resource
     *
     * @param string $templateId
     * @param string $templateName
     * @return string
     */
    public function getResourceTemplate($templateId = null, $templateName = null) {
        if (empty( $templateName )) {
            $templateName = $templateId;
        }
        if ($this->return == 'file') {
            $this->destination = "> '{$this->output}/{$templateName}.json'";
        }
        $action = "-X POST ";
        $action .= '-H "Content-Type: application/json" ';
        $action .= $this->weburl .
                 "/rest/resource/resourceTemplate/{$templateId}/resources? --data-binary '{}' {$this->destination}";
        return $this->execRest( $action );
    }
    
    /**
     *
     * Get a resource template children
     *
     * @param string $templateId
     * @param string $resourceId
     * @return string
     */
    public function getResourceTemplateChildren($templateId = null, $resourceId = null) {
        if ($this->return == 'file') {
            $this->destination = "> '{$this->output}/{$templateId}.json'";
        }
        $action = "'{$this->weburl}/rest/resource/resourceTemplate/{$templateId}/resources/{$resourceId}/children?rowsPerPage=10000&pageNumber=1&orderField=name&sortType=asc' {$this->destination}";
        return $this->execRest( $action );
    }

    /**
     *
     * Export Template Resources from resource id
     * 
     * resource name is not mandatory to name the output file
     *
     * @param string $templateId
     * @param string $templateName
     * @return string
     */
    public function getResourceTemplateResources($resourceId = null, $resourceName = null) {
        if (empty( $resourceName )) {
            $resourceName = $resourceId;
        }
        if ($this->return == 'file') {
            $this->destination = " > '{$this->output}/{$resourceName}.json'";
        }
        $action = "'{$this->weburl}/rest/resource/resource/{$resourceId}/resources?rowsPerPage=99999&pageNumber=1&orderField=name&sortType=asc'{$this->destination}";
        return $this->execRest( $action );
    }
    
    /**
     * Retireve list of resource templates for a uDeploy server
     */
    public function getResourceTemplates() {
        if ($this->return == 'file') {
            $this->destination = "> '{$this->output}/resourceTemplates.json'";
        }
        $action = "'{$this->weburl}/rest/resource/resourceTemplate/?filterFields=application&filterType_application=null' {$this->destination}";
        return $this->execRest($action);
    }
    
    /**
     * Retrieve list of resource templates for a uDeploy server
     */
    public function getResourceTree() {
        if ($this->return == 'file') {
            $this->destination = "> '{$this->output}/resourceTree.json'";
        }
        $action = "-X POST ";
        $action .= '-H "Content-Type: application/json" ';
        $action .= $this->weburl . "/rest/resource/resource/tree --data-binary '{}' {$this->destination}";
        return $this->execRest($action);
    }
    
    /**
     * UpgradeResource passing a file name
     */
    public function upgradeResource($resourceFile = null) {
        Utils::CLIinfo('upgradeResource - UNDER CONSTRUCTION');
        $this->log->info('upgradeResource - UNDER CONSTRUCTION');
        return null;
    
        // @TODO: complete functionality
        //         if (empty($resourceFile)){
        //             if (!empty($this->args[0])) {
        //                 $resourceFile = $this->args[0];
        //             } else {
        //                 return false;
        //             }
        //         }
        //         // below action is CREATING a resource, not updating it
        //         $action = "{$this->weburl}/rest/resource/resource -X PUT --data @'{$resourceFile}'";
    
        //         return $action;
    }
}
