<?php
/****************************************************************
* IBM Confidential
*
* SFA100-Collaboration Source Materials
*
* (C) Copyright IBM Corp. 2015
*
* The source code for this program is not published or otherwise
* divested of its trade secrets, irrespective of what has been
* deposited with the U.S. Copyright Office
*
* **************************************************************/

/**
 * API for system requests via REST
 *
 * @author Felice Geracitano.......feliecege@ie.ibm.com
 */
class SystemRestApi extends AbstractApi {
    
    /**
     * 
     * Batch add a resource to a team
     *
     * @param string $team
     * @param string $resourceFile
     * @return array|boolean
     */
    public function batchResourceMap( $team, $resourceFile ) {
        if ( ! file_exists( $resourceFile ) ) {
            return false;
        }
        $action = '-X PUT ';
        $action .= '-H "Content-Type: application/json" ';
        $team = rawurlencode($team);
        $action .= "{$this->weburl}/security/team/{$team}/batchResourceMappings -d @'{$resourceFile}' {$this->destination}";
        return $this->execRest( $action );
    }
    /**
     *
     * Create a tag passing a file path
     *
     * @param string $file
     * @return string
     */
    public function createTag($file = null) {
        if (! file_exists( $file )) {
            return false;
        }
        
        if ($this->return == 'file') {
            $this->destination = " > '{$this->output}/tag_restore.json'";
        }
        
        $fileContent = json_decode( file_get_contents( $file ), true );
        $type = $fileContent ['objectType'];
        
        $action = '-X PUT ';
        $action .= '-H "Content-Type: application/json" ';
        $action .= "{$this->weburl}/rest/tag/{$type} -d @'{$file}' {$this->destination}";
        return $this->execRest( $action );
    }
    
    /**
     * 
     * Create a new team with the given name 
     *
     * @param unknown $name
     */
    public function createTeam ( $name ) {
        if ($this->return == 'file') {
            $this->destination = " > '{$this->output}/team_{$name}.json'";
        }
        $jsonData = '{"name":"' . $name . '"}';
        $action = '-X POST ';
        $action .= '-H "Content-Type: application/json" ';
        $action .= "{$this->weburl}/security/team --data-binary '{$jsonData}' {$this->destination}";
        return $this->execRest( $action );
    }
    
    /**
     * 
     * Delete a team
     *
     * @param string $team
     * @return string|boolean
     */
    public function deleteTeam ( $team ) {
        $action = '-X DELETE ';
        $team = rawurlencode($team);
        $action .= "{$this->weburl}/security/team/{$team}";
        return $this->execRest( $action );
    }
    
    /**
     *
     * Get tags for a specific type. if a name is set, get that particular tag
     *
     * @param string $type
     * @param string $name
     * @return string
     */
    public function getTag($type = null, $name = '*') {
        if ($this->return == 'file') {
            $this->destination = " > '{$this->output}/{$type}.tags.json'";
        }
        $action = "{$this->weburl}/rest/tag/type/{$type}/?name={$name} {$this->destination}";
        return $this->execRest($action);
    }
    
    /**
     *
     * Get all the teams in uDeploy
     *
     * @return string
     */
    public function getTeams() {
        if ($this->return == 'file') {
            $this->destination = "> '{$this->output}/teams.json'";
        }
        $action = $this->weburl . "/security/team {$this->destination}";
        return $this->execRest($action);
    }
    
    /**
     * 
     * Returns a list of resources that are not associated with the given team.
     * $type defines the type of resource that we want to return
     *
     * @param string $team
     * @param string $type
     * @return array|boolean
     */
    public function getUnmappedResources ( $team, $type ) {
        if ($this->return == 'file') {
            $this->destination = "> 'unmapped_{$team}-{$type}.json'";
        }
        $team = rawurlencode($team);
        $action = "{$this->weburl}/rest/security/team/{$team}/unmappedResources/{$type} {$this->destination}";
        return $this->execRest($action);
    }
}

