<?php
/****************************************************************
* IBM Confidential
*
* SFA100-Collaboration Source Materials
*
* (C) Copyright IBM Corp. 2015
*
* The source code for this program is not published or otherwise
* divested of its trade secrets, irrespective of what has been
* deposited with the U.S. Copyright Office
*
* **************************************************************/

/**
 * API for resource requests via UcdClient
 *
 * @author Felice Geracitano.......feliecege@ie.ibm.com
 *
 */
class ResourceUdclientApi extends AbstractApi {
    /**
     *
     * Associate a team to a resource
     *
     * @param string $resource
     * @param string $team
     * @return boolean|string
     */
    public function addResourceToTeam( $resource = null, $team = null ) {
        $action = "addResourceToTeam -resource '{$resource}' -team '{$team}'";
        return $this->exec($action);
    }
    
    public function createResource($file = null) {
        $action = "createResource '{$file}'";
        return $this->exec($action);
    }
    
    /**
     * 
     * Delete a resource given the id or path
     *
     * @param string $resource
     * @return boolean|string
     */
    public function deleteResource( $resource ) {
        $action = "deleteResource -resource '{$resource}'";
        return $this->exec($action);
    }
    
    /**
     * Export Blueprints In Application
     * @param string        $application
     * @return string
     *
     */
    public function getBlueprintsInApplication($application = null) {
        if (empty( $application )) {
            $application = $this->application;
        }
        if ($this->return == 'file') {
            $this->destination = " > '{$this->output}/{$application}.blueprints.json'";
        }
        $action = "getBlueprintsInApplication -application {$application}{$this->destination}";
        return $this->exec( $action );
    }
    
    /**
     * @param string    $resource
     * @return string
     *
     * Will return false if argument is incorrect
     */
    public function getResource($resource = null){
        if ($this->return == 'file') {
            $this->destination = " > '{$this->output}/{$resource}.json'";
        }
        $action = "getResource -resource {$resource}{$this->destination}";
        return $this->exec($action);
    }
    
    /**
     * @param string    $resource
     * @return string
     *
     * Will return false if argument is incorrect
     */
    public function getResourceProperties($resource = null){
        if ($this->return == 'file') {
            $this->destination = " > '{$this->output}/{$resource}.properties.json'";
        }
        $action = "getResourceProperties -resource {$resource}{$this->destination}";
        return $this->exec($action);
    }
    
    /**
     * @param string    $resource
     * @param string    $property
     * @return string
     *
     * Will return false if argument is incorrect
     */
    public function getResourceProperty($resource = null, $property = null){
        if ($this->return == 'file') {
            $this->destination = " > '{$this->output}/{$resource}.{$property}.json'";
        }
        $action = "getResourceProperty -resource {$resource} -name {$property}{$this->destination}";
        return $this->exec($action);
    }
    
    /**
     * @return string
     *
     * Will return false if argument is incorrect
     */
    public function getResources(){
        if ($this->return == 'file') {
            $this->destination = " > '{$this->output}/resources.json'";
        }
        $action = "getResources{$this->destination}";
        return $this->exec($action);
    }
    /**
     * @param string    $resource
     * @param string    $property
     * @return string
     *
     * Will return false if argument is incorrect
     */
    public function getResourcesWithComponentVersion($component = null, $version = null){
        if ($this->return == 'file') {
            $this->destination = " > '{$this->output}/{$component}.{$version}.resources.json'";
        }
        $action = "getResourcesWithComponentVersion -component '{$component}' -version '{$version}'{$this->destination}";
        return $this->exec($action);
    }
}
