<?php
/****************************************************************
 * IBM Confidential
 *
 * SFA100-Collaboration Source Materials
 *
 * (C) Copyright IBM Corp. 2014
 *
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has been
 * deposited with the U.S. Copyright Office
 *
 ***************************************************************/

class Logger{
    protected $logger;
    protected $debug;
    protected $stdout;
    protected $tmp_clean_file;
    
    public function __construct(){
        self::setLogDir( getcwd() . '/log' );
        if (file_exists('config/logger.config.php')) {
            include('config/logger.config.php');
            self::setStdoutLogFile($config['stdout']);
        }
        $this->tmp_clean_file = getcwd() . '/INIT/CLEAN.cfg';
        self::setLogFile('error.log');
        self::setDebug(false);
    }
    
    public function cleanTmpDir ( $clean_time = 7 ) {
        if ( is_int ( $clean_time ) ) {
            $now = date( 'Y-m-d' );
            if ( file_exists( $this->tmp_clean_file ) ) {
                // Check CLEAN.cfg file
                $date = file_get_contents( $this->tmp_clean_file );
                $today = new DateTime ( $now );
                $last = new DateTime ( $date );
                
                // Proceed with cleanup if the clean time has passed
                $diff = $last->diff( $today );
                if ( $diff->days >= $clean_time ) {
                    $tmp_directory = getcwd() . '/tmp';
                    $this->info( "Cleaning tmp directory after {$diff->days} days.");
                    $command = "find {$tmp_directory}/* -mtime +{$clean_time} -exec rm {} \;";
                    exec ( $command, $output, $return );
                    // Log the execution
                    $this->log( var_export($output, true) );
                    $this->log( "Cleanup completed. Exit code: {$return}");
                    // Update file
                    $this->info( "Updating CLEAN.cfg file. New date: {$now}" );
                    return file_put_contents( $this->tmp_clean_file, $now );
                } else {
                    // Too early - do nothing
                    return null;
                }
            } else {
                // Create file
                $this->info( "Creating CLEAN.cfg file. New date: {$now}" );
                return file_put_contents( $this->tmp_clean_file, $now );
            }
        } else {
            $this->info( "No cleanup performed since no valid cleanup time has been set in logger.config.php" );
            return null;
        }
    }
    
    public function setLogDir($dir) {
        if ( ! is_dir ( $dir ) ) {
            if ( mkdir ( $dir, 0755, true ) === false ) {
                exit ( 1 );
            }
        }
        $this->log_dir = $dir;
        return true;
    }
    
    public function setLogFile($file) {
        $this->logger = "{$this->log_dir}/{$file}";
        return true;
    }
    
    public function getLogFile() {
        return $this->logger;
    }
    
    public function log($message, $type = null){
        $pre = '[' . date('Y/m/d H:i:s') . ']';
        if (!empty($type)){
            $pre .= '[' . strtoupper($type) . ']';
        }
        $message = $pre . $message . "\n\n";
        return file_put_contents($this->logger, $message, FILE_APPEND);
    }
    
    public function error($message) {
        return self::log($message, 'error');
    }
    
    public function info($message) {
        return self::log($message, 'info');
    }
    
    public function warning($message) {
        return self::log($message, 'warning');
    }
    
    public function debug($message) {
        return self::log($message, 'debug');
    }
    
    public function setDebug($debug) {
        if (is_bool($debug)) {
            $this->debug = $debug;
        }
        return $this->debug;
    }
    
    public function isDebug() {
        return $this->debug;
    }
    
    public function setStdoutLogFile($file) {
        $this->stdout = "{$this->log_dir}/{$file}";
        return true;
    }
    
    public function stdoutLog($message) {
        if (!empty($this->stdout)) {
            return file_put_contents($this->stdout, $message, FILE_APPEND);
        }
    }
}