<?php
/****************************************************************
 * IBM Confidential
 *
 * SFA100-Collaboration Source Materials
 *
 * (C) Copyright IBM Corp. 2015
 *
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has been
 * deposited with the U.S. Copyright Office
 *
 ***************************************************************/

/**
 * @class   StopWatch
 * @author  Felice Geracitano         felicege@ie.ibm.com
 * 
 * This class is providing tracking of timings for the different actions
 */

class StopWatch {
    private static $instance; // @var Singleton
    private static $watch;
    
    private function __construct() {
        $watch = array ();
    }
    
    /**
     * Given a string name, return the time difference from start to end.
     * If end is not set, return the time difference to the current timestamp.
     *
     * @param $watch_alias string            
     * @param $format string            
     * @return string | boolean, if something wrong otherwise format date based on
     *         param
     */
    public static function get($watch_alias, $format = "%H h %i m %s s") {
        if (empty( $watch_alias )) {
            Utils::CLIdebug( 
                    __CLASS__ . '::' . __FUNCTION__ .
                             ": Missing alias to get time information" );
            return false;
        }
        if (! isset( self::$watch [$watch_alias] )) {
            Utils::CLIdebug( 
                    __CLASS__ . '::' . __FUNCTION__ .
                             ": No record associated with alias '$watch_alias'" );
            return false;
        }
        
        if (empty( self::$watch [$watch_alias] ["stop"] )) {
            $stop = new DateTime();
        } else {
            $stop = self::$watch [$watch_alias] ["stop"];
        }
        $start = self::$watch [$watch_alias] ["start"];
        $diff = $stop->diff( $start );
        $result = $diff->format( $format );
        if (is_string( $result )) {
            return $result;
        } else {
            Utils::CLIdebug( 
                    __CLASS__ . '::' . __FUNCTION__ .
                             ": something wrong formatting time info" );
        }
        return false;
    }

    /**
     * Get singleton instance for stopwatch
     */
    public static function getInstance() {
        if (is_null( self::$instance )) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    /**
     * This function taken a string as argument, will set the current start
     * timestamp to the alias associated.
     *
     * @param $watch_alias string            
     * @param $override boolean            
     * @return boolean
     */
    public static function start($watch_alias, $override = true) {
        if (empty( $watch_alias )) {
            Utils::CLIdebug( 
                    __CLASS__ . '::' . __FUNCTION__ .
                             ": Missing alias to start tracking time information" );
            return false;
        }
        if (isset( self::$watch [$watch_alias] ) && $override !== true) {
            Utils::CLIdebug( 
                    __CLASS__ . '::' . __FUNCTION__ .
                             ":
                    '$watch_alias' alias has already been registered, choose another alias or override it" );
            return false;
        }
        self::$watch [$watch_alias] = array (
            "start" => new DateTime(),
            "stop" => null 
        );
        return true;
    }
    
    /**
     * This function taken a string as argument, will set the current stop
     * timestamp to the alias associated.
     *
     * @param $watch_alias string
     * @return boolean
     */
    public static function stop($watch_alias) {
        if (empty( $watch_alias )) {
            Utils::CLIdebug( 
                    __CLASS__ . '::' . __FUNCTION__ .
                             ": Missing alias to stop tracking time information" );
            return false;
        }
        if (! isset( self::$watch [$watch_alias] )) {
            Utils::CLIdebug( 
                    __CLASS__ . '::' . __FUNCTION__ .
                             ": No record associated with $watch_alias alias" );
            return false;
        }
        self::$watch [$watch_alias] ["stop"] = new DateTime();
        return true;
    }
}
