<?php
/*
 * IBM UrbanCode Deploy - Component::Process - Impersonation configuration file.
 * 
 * Provides a skeleton with variables, 
 * used for the user impersonation of a Component::Process Step.
 * 
 * @TODO: check with Marco and Gearoid if we need bellow options
 *        1. overwrite (true/false) - if a Process Step has been already impersonated 
 *           -=> overwrite it with the set up in this config file default impersonation settings
 *           
 *        2. mode (online/offlilne) - used to define when the impersonation should be implemented
 *           - online - during UCD backup process
 *           - offline - using a standalone function/process,
 *                       which will use already backed up Components
 *                       (might request a path to a directory with files - still have not thought about this)
 */


/*
 * Template with variables used for User Impersonation of a Component::Process step
 * 
 * REQUIRED variables:
 *  - useImpersonation      - set to TRUE to turn ON impersonation
 *  - impersonationUsername - this is the user as which a specific process step should be executed
 *                            Can be hardcoded (example: 'root', 'www-data' etc.),
 *                            or set up as an Environment/Component etc. variable
 *                            (example: '${p:environment/salesconnect_root_user_instance}')
 *  - impersonationUseSudo  - set to TRUE to be able to use impersonation,
 *                            when your UCD Agent is running as other than 'root' user on your environment.
 *                            Example: UCD Agent is running as user (ucd-agent) and is trying to
 *                                     run a Process step as 'root' or 'www-data'.
 *                            Otherwise you will get an Error message: "su: must be run on terminal".
 *                            
 * OPTIONAL variables:
 *  - impersonationGroup    - used to set a user group to be used in the User Impersonation functionality.
 *                            Can be skipped, as not required by uDeploy (UCD).
 *  - impersonationPassword - used to set a user password to be used.
 *                            Not sure if this works, so it also can be skipped.
 */
$config['impersonation_config']['template'] = array(
    'useImpersonation' => true,
    'impersonationUsername' => 'root',
    'impersonationGroup' => '',
    'impersonationPassword' => '',
    'impersonationUseSudo' => true
);

/*
 * mode (online/offlilne) - used to define when the impersonation should be implemented
 *      - online - during UCD backup process
 *      - offline - using a standalone function/process,
 *                  which will use already backed up Components.
 *                  NOTE: offline (NOT DEVELOPED YET)
 * DEFAULT: online  
 */
$config['impersonation_config']['mode'] = 'online';


/*
 * overwrite (true/false) - if a Process Step has been already impersonated 
 *      -=> overwrite it with the set up in this config file default impersonation TEMPLATE
 * DEFAULT: false
 */
$config['impersonation_config']['overwrite'] = false;


/*
 * Trigger Creation of Component Variable(s).
 * To be used in conjunction with: $config['impersonation_config']['variables_to_create']
 * NOTE: if enabled, $config['impersonation_config']['variables_to_create'] MUST be populated, as defined in its description.
 * DEFAULT: false
 */
$config['impersonation_config']['create_variables'] = true;

/*
 * Template with Component Variables - template, to be used 
 * for importing of variables into a Component.
 * 
 * NOTE: when $config['impersonation_config']['create_variables'] is enabled (set to true).
 *       THIS variable MUST be properly set up as follows:
 *       
 *       $config['impersonation_config']['create_variables'] = array(
 *          array(
 *              'name'          => 'VARIABLE_NAME',
 *              'label'         => 'VARIABLE_LABEL',
 *              'pattern'       => '',
 *              'type'          => 'TEXT',
 *              'value'         => 'VARIABLE_VALUE',
 *              'required'      => true, 
 *              'description'   => 'VARIABLE_DESCRIPTION (can be skipped)'
 *          )
 *       )
 *       
 *       REQUIRED fields:
 *          - name  - The name for the variable to create
 *          - label - The label for the variable to create. Usually is the same as the 'name'
 *          - value - The value for the variable to create. 
 *                    NOTE: this is displayed as: "Default Vallue" in 
 *                          uDeploy User Interface: Component-Environment variable Editor pop-up
 *                    
 *       OPTIONAL fields:
 *          - pattern       - a String pattern against which a variable can be validated. Can be skipped.
 *                            Default value: EMPTY_STRING
 *          - required      - a Boolean flag, used to define whether the variable will be required or not.  
 *                            Default value: false
 *          - description   - description for the variable to create.
 *                            Default value: EMPTY_STRING
 */
$config['impersonation_config']['variables_to_create'] = array(
    array(
        'name'          => 'salesconnect_apache_instance_user',
        'label'         => 'salesconnect_apache_instance_user',
        'pattern'       => '^[a-zA-Z][a-zA-Z0-9_-]{1,8}$',
        'type'          => 'TEXT',
        'value'         => 'apache',
        'required'      => true,
        'description'   => 'The Apache user name to be used when running Scripts and files manipulations under the Apache Web root DIR. Default value: apache. On DEV VMs to be set to: www-data.'
    ), 
    array(
        'name'          => 'salesconnect_db2_instance_user',
        'label'         => 'salesconnect_db2_instance_user',
        'pattern'       => '^[a-zA-Z][a-zA-Z0-9_-]{1,8}$',
        'type'          => 'TEXT',
        'value'         => 'a1insctp',
        'required'      => true,
        'description'   => 'Instance owner user name of the SalesConnect database (case sensitive – lower case)'
    )
);